/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.library.configuration.ActivityDeepCopyConfigurator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ProcessTreeViewer
extends TreeViewer
implements IActionTypeProvider {
    private static final String COPY_TXT = AuthoringUIResources.copy_text;
    private static final String EXTEND_TXT = AuthoringUIResources.extend_text;
    private static final String DEEP_COPY_TXT = AuthoringUIResources.deepCopy_text;
    private int actionType = 1;
    private Menu actionTypePopup;
    private Point actionTypePopupLocation;
    private Command command;
    private IActionManager actionManager;

    private static String getActionText(int actionType) {
        switch (actionType) {
            case 1: {
                return COPY_TXT;
            }
            case 2: {
                return EXTEND_TXT;
            }
            case 3: {
                return DEEP_COPY_TXT;
            }
        }
        return null;
    }

    public ProcessTreeViewer(Composite parent, int style) {
        super(parent, style);
        final Tree tree = this.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                ProcessTreeViewer.this.setItemProviderExpanded(event.getElement(), false);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ProcessTreeViewer.this.setItemProviderExpanded(event.getElement(), true);
            }
        });
        Accessible accessible = tree.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                TreeItem[] items;
                super.getName(e);
                if (e.childID >= 0 && (items = tree.getSelection()) != null && items.length == 1) {
                    String stringToRead = "";
                    TreeItem item = items[0];
                    if (item != null) {
                        TreeColumn[] columns = tree.getColumns();
                        int i = 0;
                        while (i < columns.length) {
                            TreeColumn column = columns[i];
                            stringToRead = String.valueOf(stringToRead) + column.getText() + " " + item.getText(i);
                            ++i;
                        }
                        e.result = stringToRead;
                    }
                }
            }
        });
    }

    public void setupColumns(ColumnDescriptor[] columnDescriptors) {
        TreeColumn[] cols = this.getTree().getColumns();
        int size = cols.length;
        int i = 0;
        while (i < size) {
            cols[i].dispose();
            ++i;
        }
        String[] colProps = new String[columnDescriptors.length];
        int i2 = 0;
        while (i2 < columnDescriptors.length) {
            colProps[i2] = columnDescriptors[i2].id;
            TreeColumn column = new TreeColumn(this.getTree(), columnDescriptors[i2].alignment);
            column.setText(columnDescriptors[i2].label);
            column.setResizable(columnDescriptors[i2].resizable);
            column.setWidth(columnDescriptors[i2].width);
            ++i2;
        }
        this.setColumnProperties(colProps);
    }

    private void setItemProviderExpanded(Object element, boolean expand) {
        Object adapter = this.getAdapterFactory().adapt(element, ITreeItemContentProvider.class);
        if (adapter instanceof IBSItemProvider) {
            ((IBSItemProvider)adapter).setExpanded(Boolean.valueOf(expand));
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.getContentProvider() == null ? null : ((AdapterFactoryContentProvider)this.getContentProvider()).getAdapterFactory();
    }

    protected void setExpanded(Item node, boolean expand) {
        IBSItemProvider bsItemProvider;
        super.setExpanded(node, expand);
        Object adapter = this.getAdapterFactory().adapt(node.getData(), ITreeItemContentProvider.class);
        if (adapter instanceof IBSItemProvider && (bsItemProvider = (IBSItemProvider)adapter).isExpanded() == null) {
            bsItemProvider.setExpanded(Boolean.valueOf(expand));
        }
    }

    private void setExpanded(Item item, Object element) {
        Boolean expand;
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)this.getAdapterFactory().adapt(element, ITreeItemContentProvider.class);
        if (adapter.hasChildren(element) && adapter instanceof IBSItemProvider && (expand = ((IBSItemProvider)adapter).isExpanded()) != null) {
            this.setExpandedState(item, expand);
        }
    }

    protected void internalRefresh(Widget widget, Object element, boolean doStruct, boolean updateLabels) {
        super.internalRefresh(widget, element, doStruct, updateLabels);
        if (doStruct) {
            this.preserveExpandedState(widget);
        }
    }

    private void preserveExpandedState(Widget widget) {
        if (widget instanceof Item) {
            Item item = (Item)widget;
            this.setExpanded(item, item.getData());
        } else {
            Item[] children = this.getChildren(widget);
            int i = 0;
            while (i < children.length) {
                Item child = children[i];
                if (child instanceof Item) {
                    Item item = child;
                    this.setExpanded(item, item.getData());
                }
                ++i;
            }
        }
    }

    protected void internalInitializeTree(Control widget) {
        super.internalInitializeTree(widget);
        this.preserveExpandedState((Widget)widget);
    }

    private void createActionTypePopup(int[] choices) {
        this.actionTypePopup = new Menu(this.getControl());
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.getSource();
                String text = item.getText();
                if (text == COPY_TXT) {
                    ProcessTreeViewer.this.actionType = 1;
                } else if (text == EXTEND_TXT) {
                    ProcessTreeViewer.this.actionType = 2;
                } else if (text == DEEP_COPY_TXT) {
                    ProcessTreeViewer.this.actionType = 3;
                }
                if (ProcessTreeViewer.this.command instanceof ActivityDropCommand) {
                    ActivityDropCommand cmd = (ActivityDropCommand)ProcessTreeViewer.this.command;
                    cmd.setType(ProcessTreeViewer.this.actionType);
                    cmd.setLabel(text);
                    if (ProcessTreeViewer.this.actionType == 3) {
                        cmd.setActivityDeepCopyConfigurator((IConfigurator)new ActivityDeepCopyConfigurator());
                    }
                }
                if (ProcessTreeViewer.this.actionManager != null && ProcessTreeViewer.this.command instanceof IResourceAwareCommand) {
                    ProcessTreeViewer.this.actionManager.execute((IResourceAwareCommand)ProcessTreeViewer.this.command);
                } else {
                    ProcessTreeViewer.this.command.execute();
                }
                ProcessTreeViewer.this.actionTypePopup.setVisible(false);
            }
        };
        int[] nArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            int actionType = nArray[n2];
            MenuItem menuItem = new MenuItem(this.actionTypePopup, 64);
            menuItem.setText(ProcessTreeViewer.getActionText(actionType));
            menuItem.addSelectionListener((SelectionListener)selectionListener);
            ++n2;
        }
    }

    public void setInputData(Object object) {
        this.actionTypePopupLocation = (Point)object;
    }

    public void execute(Command cmd, int[] choices) {
        this.createActionTypePopup(choices);
        this.command = cmd;
        this.actionTypePopup.setLocation(this.actionTypePopupLocation);
        this.actionTypePopup.setVisible(true);
    }

    protected void hookEditingSupport(Control control) {
        try {
            TreeViewerEditor.create((TreeViewer)this, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this){

                protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                    return event.eventType == 3 || event.eventType == 4 || event.eventType == 5;
                }
            }, (int)1);
        }
        catch (NullPointerException nullPointerException) {}
        super.hookEditingSupport(control);
    }

    public void setActionManager(IActionManager actionMgr) {
        this.actionManager = actionMgr;
    }
}

