/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import org.eclipse.epf.authoring.ui.celleditors.AbstractCheckBoxCellEditor;
import org.eclipse.epf.authoring.ui.views.ProcessTreeViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProcessViewer
extends ProcessTreeViewer {
    private String[] columnProperties;
    private AbstractCheckBoxCellEditor[] checkBoxCellEditors = null;

    public ProcessViewer(Composite parent, int style) {
        super(parent, style);
    }

    public Composite getCellEditorParent() {
        return this.getTree();
    }

    public void setCheckBoxCellEditors(AbstractCheckBoxCellEditor[] checkBoxCellEditors) {
        this.checkBoxCellEditors = checkBoxCellEditors;
        int i = 0;
        while (i < checkBoxCellEditors.length) {
            AbstractCheckBoxCellEditor editor = checkBoxCellEditors[i];
            if (editor != null) {
                editor.setColumnIndex(i);
            }
            ++i;
        }
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProcessViewer.this.modifyItem(e);
            }
        });
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 42: {
                        Image image = ProcessViewer.this.getCheckBoxCellEditorImage(event);
                        if (image == null) {
                            return;
                        }
                        TreeColumn col = ProcessViewer.this.getTree().getColumn(event.index);
                        int x = event.x + col.getWidth() / 2;
                        Rectangle rect = image.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(image, x - rect.width / 2, event.y + offset);
                    }
                }
            }
        };
        this.getTree().addListener(42, paintListener);
    }

    protected void doUpdateItem(Item item, Object element) {
        super.doUpdateItem(item, element);
        if (this.checkBoxCellEditors != null && this.columnProperties != null && this.columnProperties.length > 0) {
            int i = 0;
            while (i < this.checkBoxCellEditors.length) {
                AbstractCheckBoxCellEditor editor = this.checkBoxCellEditors[i];
                if (editor != null) {
                    ((TreeItem)item).setText(i, "");
                }
                ++i;
            }
        }
    }

    private Image getCheckBoxCellEditorImage(Event event) {
        return this.getCheckBoxCellEditorImage(event.index, (TreeItem)event.item);
    }

    private Image getCheckBoxCellEditorImage(int columnIndex, TreeItem item) {
        if (this.checkBoxCellEditors == null || this.checkBoxCellEditors[columnIndex] == null) {
            return null;
        }
        return this.checkBoxCellEditors[columnIndex].getImage(item, this.columnProperties[columnIndex]);
    }

    public void setCellModifier(ICellModifier modifier) {
        super.setCellModifier(modifier);
        if (this.checkBoxCellEditors != null) {
            int i = 0;
            while (i < this.checkBoxCellEditors.length) {
                AbstractCheckBoxCellEditor editor = this.checkBoxCellEditors[i];
                if (editor != null) {
                    editor.setCellModifier(modifier);
                }
                ++i;
            }
        }
    }

    private void modifyItem(MouseEvent event) {
        Point pt = new Point(event.x, event.y);
        TreeItem item = this.getTree().getItem(pt);
        if (item == null) {
            return;
        }
        int i = 0;
        while (i < this.getTree().getColumnCount()) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(pt)) {
                Image image = this.getCheckBoxCellEditorImage(i, item);
                if (image == null) {
                    return;
                }
                Rectangle imgRect = image.getBounds();
                int x = rect.x + rect.width / 2 - imgRect.width / 2;
                int offset = Math.max(0, (rect.height - imgRect.height) / 2);
                int y = rect.y + offset;
                imgRect = new Rectangle(x, y, imgRect.width, imgRect.height);
                if (imgRect.contains(pt)) {
                    this.checkBoxCellEditors[i].modify(item, this.columnProperties[i]);
                    return;
                }
            }
            ++i;
        }
    }

    public void setColumnProperties(String[] columnProperties) {
        super.setColumnProperties(columnProperties);
        this.columnProperties = columnProperties;
    }
}

