/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.authoring.ui.views.AbstractLocker;
import org.eclipse.epf.authoring.ui.views.LockerFactory;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.common.ui.util.PerspectiveUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public final class ViewHelper {
    public static boolean promptSave() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && manager.isMethodLibraryModified()) {
            int ret = MsgBox.prompt((String)AuthoringUIResources.saveLibraryDialog_title, (String)AuthoringUIResources.saveLibraryDialog_text, (int)448);
            switch (ret) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                        break;
                    }
                    catch (Exception e) {
                        MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        dialog.displayError(AuthoringUIResources.saveLibraryDialog_title, AuthoringUIResources.saveLibraryError_msg, AuthoringUIResources.error_reason, (Throwable)e);
                        return dialog.displayPrompt(AuthoringUIResources.openLibraryDialog_title, AuthoringUIResources.openLibraryDialog_text);
                    }
                }
                case 128: {
                    manager.discardMethodLibraryChanges();
                    break;
                }
                case 256: {
                    return false;
                }
            }
        }
        return true;
    }

    public static int promptSaveInt() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && manager.isMethodLibraryModified()) {
            int ret = MsgBox.prompt((String)AuthoringUIResources.saveLibraryDialog_title, (String)AuthoringUIResources.saveLibraryDialog_text, (int)448);
            switch (ret) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                    }
                    catch (Exception e) {
                        MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        dialog.displayError(AuthoringUIResources.saveLibraryDialog_title, AuthoringUIResources.saveLibraryError_msg, AuthoringUIResources.error_reason, (Throwable)e);
                    }
                    return 64;
                }
                case 128: {
                    manager.discardMethodLibraryChanges();
                    return 128;
                }
                case 256: {
                    return 256;
                }
            }
        }
        return 256;
    }

    public static void closeAllEditors() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
    }

    public static Object handleDangling(Object object) {
        FeatureValueWrapperItemProvider adapter;
        Object value;
        if (object instanceof MethodElement && ((EObject)object).eResource() == null) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.elementAlreadyDeletedError_msg, (Object)((MethodElement)object).getName()));
            return null;
        }
        if (object instanceof FeatureValueWrapperItemProvider && (value = (adapter = (FeatureValueWrapperItemProvider)object).getValue()) instanceof MethodElement && ((EObject)value).eResource() == null) {
            Object owner = TngUtil.unwrap((Object)adapter.getParent(value));
            if (owner instanceof ItemProviderAdapter) {
                owner = ((ItemProviderAdapter)owner).getTarget();
            }
            String ownerName = ((MethodElement)owner).getName();
            EStructuralFeature feature = adapter.getFeature();
            if (feature != null) {
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(AuthoringUIResources.deleteDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.ViewHelper_alreadydeletedconfirm_text, (Object)((MethodElement)value).getName(), (Object)ownerName)) && feature.isMany()) {
                    ((Collection)((EObject)owner).eGet(feature)).remove(value);
                }
            } else {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.elementAlreadyDeletedError_msg, (Object)((MethodElement)value).getName()));
            }
            return null;
        }
        return object;
    }

    public static boolean isLocked(IStructuredSelection selection) {
        for (Object element : selection) {
            while (element instanceof ITreeItemContentProvider) {
                element = ((ITreeItemContentProvider)element).getParent(null);
            }
            if (!((element = TngUtil.unwrap(element)) instanceof EObject) || !TngUtil.isLocked((EObject)((EObject)element))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCustomizedLocker(IStructuredSelection selection) {
        for (Object element : selection) {
            while (element instanceof ITreeItemContentProvider) {
                element = ((ITreeItemContentProvider)element).getParent(null);
            }
            if (!((element = TngUtil.unwrap(element)) instanceof EObject)) continue;
            AbstractLocker locker = null;
            if (element instanceof MethodConfiguration) {
                locker = LockerFactory.getInstance().getLocker(element);
            } else {
                MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((EObject)element));
                if (plugin != null) {
                    locker = LockerFactory.getInstance().getLocker(plugin);
                }
            }
            if (locker == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLockedWithCustomizedLocker(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            AbstractLocker locker;
            AbstractLocker locker2;
            Object selectedItem;
            Object element = selectedItem = iter.next();
            while (element instanceof ITreeItemContentProvider) {
                element = ((ITreeItemContentProvider)element).getParent(null);
            }
            Object unwrapElement = TngUtil.unwrap(element);
            if (!(unwrapElement instanceof EObject)) continue;
            if (element instanceof MethodConfiguration && (locker2 = LockerFactory.getInstance().getLocker(element)) != null && locker2.isLocked(element)) {
                return true;
            }
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((EObject)unwrapElement));
            if (plugin == null || !((locker = LockerFactory.getInstance().getLocker(plugin)) != null ? locker.isLocked(selectedItem) : TngUtil.isLocked((EObject)((EObject)unwrapElement)))) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtendedLocked(Object destination) {
        block5: {
            if (destination != null) break block5;
            return false;
        }
        try {
            AbstractLocker locker;
            MethodPlugin plugin;
            Object element = destination;
            while (element instanceof ITreeItemContentProvider) {
                element = ((ITreeItemContentProvider)element).getParent(null);
            }
            if ((element = TngUtil.unwrap((Object)element)) instanceof EObject && (plugin = UmaUtil.getMethodPlugin((EObject)((EObject)element))) != null && (locker = LockerFactory.getInstance().getLocker(plugin)) != null && locker.isLocked(destination)) {
                return true;
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return false;
    }

    public static void fixContentDescriptionGUIDs() {
        final MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HashSet<Resource> modifiedResources = new HashSet<Resource>();
                TreeIterator iter = lib.eAllContents();
                while (iter.hasNext()) {
                    InternalEObject element = (InternalEObject)iter.next();
                    if (element.eProxyURI() == null) {
                        String guid;
                        if (!(element instanceof ContentDescription)) continue;
                        ContentDescription content = (ContentDescription)element;
                        DescribableElement container = (DescribableElement)element.eContainer();
                        if (container == null || (guid = UmaUtil.generateGUID((String)container.getGuid())).equals(content.getGuid())) continue;
                        content.setGuid(guid);
                        modifiedResources.add(content.eResource());
                        modifiedResources.add(container.eResource());
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + element.eResource().getURI().toFileString() + "': " + element);
                }
                monitor.subTask(AuthoringUIResources.savingFilesTask_name);
                ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    for (Resource resource : modifiedResources) {
                        monitor.subTask(AuthoringUIResources.bind((String)AuthoringUIResources.savingTask_name, (Object)resource.getURI().toFileString()));
                        persister.save(resource);
                    }
                    persister.commit();
                }
                catch (Exception e) {
                    persister.rollback();
                    throw new WrappedException(e);
                }
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.fixingContentDescriptionGUIDsTask_name);
    }

    private static String checkProxy(InternalEObject element, EReference ref, Object value) {
        InternalEObject eObj;
        if (value instanceof InternalEObject && (eObj = (InternalEObject)value).eIsProxy()) {
            EObject resolved = element.eResolveProxy(eObj);
            String errMsg = null;
            if (resolved == eObj) {
                errMsg = "Unresolved proxy";
            } else if (!ref.getEType().isInstance((Object)resolved)) {
                errMsg = "Invalid data";
            }
            if (errMsg != null) {
                String path = element instanceof NamedElement ? String.valueOf(ref.getEType().getName()) + "(" + Misc.getPathRelativeToLibrary((NamedElement)((NamedElement)element)) + ")." + ref.getName() + " = " : "";
                return String.valueOf(errMsg) + " in '" + element.eResource().getURI().toFileString() + "': " + path + resolved;
            }
        }
        return null;
    }

    public static void checkLibraryHealth(Object context) {
        if (!AuthoringUIPreferences.getEnableLibraryValidation()) {
            return;
        }
        final MethodLibrary lib = context instanceof MethodLibrary ? (MethodLibrary)context : null;
        final ArrayList<MethodPlugin> pluginList = new ArrayList<MethodPlugin>();
        if (context instanceof List) {
            for (Object obj : (List)context) {
                if (!(obj instanceof MethodPlugin)) continue;
                pluginList.add((MethodPlugin)obj);
            }
        }
        if (lib == null && pluginList.isEmpty()) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AuthoringUIPlugin.getDefault().getLogger().logInfo("++++ LIBRARY HEALTH CHECK REPORT - START +++");
                StringWriter strWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(strWriter);
                printWriter.println();
                printWriter.println("UNRESOLVED/INVALID PROXIES IN X-REFERENCES");
                printWriter.println("------------------------------------------");
                Object iter = null;
                if (!pluginList.isEmpty()) {
                    ArrayList list = new ArrayList();
                    for (MethodPlugin plugin : pluginList) {
                        TreeIterator it = plugin.eAllContents();
                        while (it.hasNext()) {
                            list.add(it.next());
                        }
                    }
                    iter = list.iterator();
                } else {
                    iter = lib.eAllContents();
                }
                while (iter.hasNext()) {
                    InternalEObject element = (InternalEObject)iter.next();
                    if (element.eProxyURI() == null) {
                        if (element instanceof ContentDescription) {
                            String contentPath;
                            File contentDir;
                            String modelPath;
                            File dir;
                            ProcessComponent procComp;
                            ContentDescription content = (ContentDescription)element;
                            DescribableElement container = (DescribableElement)element.eContainer();
                            if (container != null) {
                                String guid = UmaUtil.generateGUID((String)container.getGuid());
                                if (!guid.equals(content.getGuid())) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError("ContentDescription with invalid GUID: " + content.getGuid() + " in '" + content.eResource().getURI().toFileString() + "'");
                                }
                            } else {
                                AuthoringUIPlugin.getDefault().getLogger().logError("ContentDescription without a container: " + content);
                            }
                            if (content instanceof BreakdownElementDescription && (procComp = UmaUtil.getProcessComponent((MethodElement)content)) != null && !(dir = new File(modelPath = procComp.eResource().getURI().toFileString()).getParentFile()).equals(contentDir = new File(contentPath = content.eResource().getURI().toFileString()).getParentFile())) {
                                AuthoringUIPlugin.getDefault().getLogger().logError("Content file of " + container.eClass().getName() + " '" + container.getName() + "' in '" + modelPath + " is misplaced: " + contentPath);
                            }
                        }
                        ArrayList xReferences = new ArrayList(element.eClass().getEAllReferences());
                        xReferences.removeAll((Collection<?>)element.eClass().getEAllContainments());
                        for (EReference ref : xReferences) {
                            Object value = element.eGet((EStructuralFeature)ref, false);
                            if (ref.isMany()) {
                                if (!(value instanceof InternalEList)) continue;
                                InternalEList list = (InternalEList)value;
                                Iterator iter1 = list.basicIterator();
                                while (iter1.hasNext()) {
                                    String msg = ViewHelper.checkProxy(element, ref, iter1.next());
                                    if (msg == null) continue;
                                    printWriter.println(msg);
                                }
                                continue;
                            }
                            String msg = ViewHelper.checkProxy(element, ref, value);
                            if (msg == null) continue;
                            printWriter.println(msg);
                        }
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + element.eResource().getURI().toFileString() + "': " + element);
                }
                AuthoringUIPlugin.getDefault().getLogger().logError(strWriter.toString());
                AuthoringUIPlugin.getDefault().getLogger().logInfo("++++ LIBRARY HEALTH CHECK REPORT - END +++");
            }
        };
        if (UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.viewHelper_performHealthCheck)) {
            String title = AuthoringUIResources.viewHelperHealthCheckDialog_title;
            String message = AuthoringUIResources.viewHelperHealthCheckDialog_message;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(title, message);
        }
    }

    public static void removeInvalidReferences() {
        final MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HashSet<Resource> modifiedResources = new HashSet<Resource>();
                TreeIterator iter = lib.eAllContents();
                while (iter.hasNext()) {
                    InternalEObject element = (InternalEObject)iter.next();
                    if (element.eProxyURI() == null) {
                        ArrayList xReferences = new ArrayList(element.eClass().getEAllReferences());
                        xReferences.removeAll((Collection<?>)element.eClass().getEAllContainments());
                        for (EReference ref : xReferences) {
                            Object value = element.eGet((EStructuralFeature)ref, false);
                            if (ref.isMany()) {
                                if (!(value instanceof InternalEList)) continue;
                                InternalEList list = (InternalEList)value;
                                ArrayList invalidProxies = new ArrayList();
                                Iterator iter1 = list.basicIterator();
                                while (iter1.hasNext()) {
                                    Object v = iter1.next();
                                    if (!this.isInvalidReference(element, ref, v)) continue;
                                    invalidProxies.add(v);
                                }
                                if (invalidProxies.isEmpty()) continue;
                                this.removeInvalidReferences(element, list, invalidProxies);
                                modifiedResources.add(element.eResource());
                                continue;
                            }
                            if (!this.isInvalidReference(element, ref, value)) continue;
                            element.eSet((EStructuralFeature)ref, null);
                            modifiedResources.add(element.eResource());
                        }
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + element.eResource().getURI().toFileString() + "': " + element);
                }
                monitor.subTask(AuthoringUIResources.savingFilesTask_name);
                ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    for (Resource resource : modifiedResources) {
                        monitor.subTask(AuthoringUIResources.bind((String)AuthoringUIResources.savingTask_name, (Object)resource.getURI().toFileString()));
                        persister.save(resource);
                    }
                    persister.commit();
                }
                catch (Exception e) {
                    persister.rollback();
                    throw new WrappedException(e);
                }
            }

            private boolean isInvalidReference(InternalEObject element, EReference ref, Object value) {
                InternalEObject eObj;
                if (value instanceof InternalEObject && (eObj = (InternalEObject)value).eIsProxy()) {
                    EObject resolved = element.eResolveProxy(eObj);
                    if (!ref.getEType().isInstance((Object)resolved)) {
                        return true;
                    }
                }
                return false;
            }

            private void removeInvalidReferences(InternalEObject element, InternalEList values, Collection invalidProxies) {
                int max;
                ArrayList<EObject> list = new ArrayList<EObject>(values.basicList());
                list.removeAll(invalidProxies);
                values.clear();
                int i = max = list.size() - 1;
                while (i > -1) {
                    list.set(i, element.eResolveProxy((InternalEObject)list.get(i)));
                    --i;
                }
                values.addAll(list);
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.deletingInvalidReferencesTask_name);
    }

    public static void reloadCurrentLibaryOnRollbackError(Shell shell) {
        ViewHelper.reloadCurrentLibrary(shell, AuthoringUIResources.ViewHelper_reloadLibOnRollbackError);
    }

    public static void reloadCurrentLibrary(final Shell shell, final String message) {
        Display display = MsgBox.getDisplay();
        Runnable runnable = new Runnable(){

            public void run() {
                ViewHelper.doReloadCurrentLibrary(shell, message);
            }
        };
        if (display != null) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private static void doReloadCurrentLibrary(Shell shell, String message) {
        if (shell == null) {
            MsgBox.getDefaultShell();
        }
        String title = AuthoringUIResources.reloadDialog_title;
        if (message == null) {
            message = AuthoringUIResources.reloadDialog_message;
        }
        AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(title, message);
        String libDir = LibraryService.getInstance().getCurrentMethodLibraryLocation();
        LibraryUIManager.getInstance().openLibrary(libDir);
    }

    public static IViewPart openView(String viewId) {
        return ViewHelper.findView(viewId, true);
    }

    public static IViewPart findView(String viewId, boolean show) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IViewPart view = activePage.findView(viewId);
                if (view == null) {
                    view = activePage.showView(viewId);
                }
                if (!show) {
                    activePage.hideView(view);
                }
                return view;
            }
        }
        catch (Exception e) {
            if (CommandLineRunUtil.getInstance().isNeedToRun()) {
                return null;
            }
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.internalError_msg, (Throwable)e);
        }
        return null;
    }

    public static IViewPart findView(String viewId) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                return activePage.findView(viewId);
            }
        }
        catch (Exception e) {
            if (CommandLineRunUtil.getInstance().isNeedToRun()) {
                return null;
            }
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.internalError_msg, (Throwable)e);
        }
        return null;
    }

    public static boolean isViewInCurrentPerspective(String viewId) {
        String perspectiveId = PerspectiveUtil.getActivePerspectiveId();
        return ViewHelper.isViewInPerspective(viewId, perspectiveId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isViewInPerspective(String viewId, String perspectiveId) {
        if (viewId == null || perspectiveId == null) {
            return false;
        }
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = null;
        if (extensionRegistry != null) {
            extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.ui", "perspectiveExtensions");
        }
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String id = configElement.getAttribute("targetID");
                        if (perspectiveId.equals(id)) {
                            IConfigurationElement[] configElementsForView = configElement.getChildren("view");
                            int k = 0;
                            while (k < configElementsForView.length) {
                                IConfigurationElement configurationElement = configElementsForView[k];
                                if (viewId.equals(configurationElement.getAttribute("id"))) {
                                    return true;
                                }
                                ++k;
                            }
                            IConfigurationElement[] configElementsForViewShortcut = configElement.getChildren("viewShortcut");
                            int l = 0;
                            while (l < configElementsForViewShortcut.length) {
                                IConfigurationElement configurationElement = configElementsForViewShortcut[l];
                                if (viewId.equals(configurationElement.getAttribute("id"))) {
                                    return true;
                                }
                                ++l;
                            }
                        }
                    }
                    catch (Exception e) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public static void refreshView(AbstractBaseView configView) {
        Object input;
        Control ctrl = configView.getViewer().getControl();
        if (ctrl != null && !ctrl.isDisposed() && (input = configView.getViewer().getInput()) instanceof EObject) {
            EObject eObject = (EObject)input;
            if (eObject.eIsProxy()) {
                configView.setInputForViewer(RefreshJob.getInstance().resolve(eObject));
            } else {
                ISelection selection = configView.getViewer().getSelection();
                configView.getViewer().refresh();
                ViewHelper.restoreSelection(configView.getViewer(), selection);
            }
        }
    }

    public static void restoreSelection(Viewer viewer, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            boolean restore = false;
            ArrayList<EObject> resolvedList = new ArrayList<EObject>();
            for (Object object : structuredSelection) {
                if (!(object instanceof EObject)) continue;
                EObject eObj = (EObject)object;
                if (eObj.eIsProxy()) {
                    eObj = RefreshJob.getInstance().resolve(eObj);
                    restore = true;
                }
                if (eObj.eIsProxy()) continue;
                resolvedList.add(eObj);
            }
            if (restore) {
                viewer.setSelection((ISelection)new StructuredSelection(resolvedList), true);
            }
        }
    }
}

