/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationMainPage;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewConfigurationWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = NewConfigurationWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.authoring.ui.newConfigurationWizard";
    protected NewConfigurationMainPage mainPage;
    protected MethodConfiguration config;
    protected MethodLibrary library;
    protected ILibraryPersister.FailSafeMethodLibraryPersister persister;

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(AuthoringUIResources.newConfigurationWizard_title);
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.mainPage = this.createMainPage();
            super.addPage((IWizardPage)this.mainPage);
        } else {
            ArrayList<Object> wizardPages = new ArrayList<Object>();
            IWizardPage page = this.wizardExtender.getReplaceWizardPage(NewConfigurationMainPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.mainPage = this.createMainPage();
                wizardPages.add((Object)this.mainPage);
            }
            super.getNewWizardPages(wizardPages);
            for (IWizardPage iWizardPage : wizardPages) {
                super.addPage(iWizardPage);
            }
            this.wizardExtender.initWizardPages(wizardPages);
        }
    }

    protected NewConfigurationMainPage createMainPage() {
        return new NewConfigurationMainPage();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodConfiguration.gif"));
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        this.config = config;
    }

    public boolean doFinish() {
        boolean ret = this.createMethodConfiguration(this.mainPage.getConfigurationName(), this.mainPage.getBriefDescription(), (WizardPage)this.mainPage);
        if (ret) {
            this.library = LibraryService.getInstance().getCurrentMethodLibrary();
            this.persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            Job job = new Job("Persistence for method configuration"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        NewConfigurationWizard.this.persister.save(NewConfigurationWizard.this.library.eResource());
                        NewConfigurationWizard.this.persister.commit();
                        if (AuthoringUIPreferences.getEnableAutoNameGen()) {
                            LibraryUtil.addNameTrackPresentationNameMark((MethodElement)NewConfigurationWizard.this.config);
                        }
                    }
                    catch (Exception e) {
                        try {
                            NewConfigurationWizard.this.persister.rollback();
                        }
                        catch (Exception ex) {
                            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                        }
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newConfigurationWizard_title, AuthoringUIResources.internalError_msg, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return ret;
    }

    public boolean createMethodConfiguration(String name, String briefDesc, WizardPage wizardPage) {
        MethodLibrary library;
        block6: {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException();
            }
            library = LibraryService.getInstance().getCurrentMethodLibrary();
            MethodConfiguration c = this.config == null ? UmaFactory.eINSTANCE.createMethodConfiguration() : this.config;
            c.setName(name);
            if (this.nameCheck(name, wizardPage, library, c)) break block6;
            return false;
        }
        try {
            if (this.config == null) {
                this.config = LibraryService.getInstance().createMethodConfiguration(name, library);
            }
            if (briefDesc != null) {
                this.config.setBriefDescription(briefDesc);
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newConfigurationWizard_title, AuthoringUIResources.internalError_msg, (Throwable)e);
        }
        return true;
    }

    private boolean nameCheck(String name, WizardPage wizardPage, MethodLibrary library, MethodConfiguration methodConfig) {
        String errmsg = null;
        if (name.indexOf("&") > -1) {
            errmsg = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)name);
        } else {
            IValidator validator = IValidatorFactory.INSTANCE.createNameValidator((Object)library, (NamedElement)methodConfig);
            errmsg = validator.isValid(name);
        }
        if (errmsg != null) {
            wizardPage.setErrorMessage(errmsg);
            return false;
        }
        return true;
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }

    private boolean superPerformFinish() {
        return super.performFinish();
    }

    public boolean performFinish() {
        final boolean[] resultHolder = new boolean[1];
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                resultHolder[0] = NewConfigurationWizard.this.superPerformFinish();
            }
        });
        return resultHolder[0];
    }
}

