/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class SaveAllEditorsPage
extends BaseWizardPage {
    private static final String SAVE_AND_CLOSE_PAGE_TITLE = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveAndClosePageTitle;
    private static final String SAVE_AND_CLOSE_PAGE_DESC = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveAndClosePageDescription;
    private static final String SAVE_PAGE_TITLE = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveTitle;
    private static final String SAVE_PAGE_DESC = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveDescription;
    private boolean doClose;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Button selectAll;
    private Button deselectAll;

    public static boolean addPageIfNeeded(Wizard wizard, boolean doClose) {
        if (SaveAllEditorsPage.isUnsavedEditor()) {
            wizard.addPage((IWizardPage)new SaveAllEditorsPage(doClose));
            return true;
        }
        SaveAllEditorsPage.performClose(doClose);
        return false;
    }

    public static boolean addPageIfNeeded(Wizard wizard, boolean doClose, String title, String description, ImageDescriptor image) {
        if (SaveAllEditorsPage.isUnsavedEditor()) {
            SaveAllEditorsPage page = new SaveAllEditorsPage(doClose);
            if (title != null) {
                page.setTitle(title);
            }
            if (description != null) {
                page.setDescription(description);
            }
            if (image != null) {
                page.setImageDescriptor(image);
            }
            wizard.addPage((IWizardPage)page);
            return true;
        }
        SaveAllEditorsPage.performClose(doClose);
        return false;
    }

    public SaveAllEditorsPage(boolean close) {
        super(SAVE_PAGE_TITLE);
        this.doClose = close;
        if (this.doClose) {
            this.setTitle(SAVE_AND_CLOSE_PAGE_TITLE);
            this.setDescription(SAVE_AND_CLOSE_PAGE_DESC);
        } else {
            this.setTitle(SAVE_PAGE_TITLE);
            this.setDescription(SAVE_PAGE_DESC);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.ctrl_chkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2308);
        this.ctrl_chkboxTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IEditorReference ref = (IEditorReference)element;
                return ref.getEditor(false).getTitle();
            }

            public Image getImage(Object element) {
                IEditorReference ref = (IEditorReference)element;
                return ref.getEditor(false).getTitleImage();
            }
        });
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ctrl_chkboxTableViewer.setInput((Object)EditorChooser.getInstance().getOpenMethodEditors().toArray());
        this.ctrl_chkboxTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IEditorReference && ((IEditorReference)element).isDirty();
            }
        });
        this.ctrl_chkboxTableViewer.setAllChecked(true);
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)new GridLayout(1, true));
        buttonContainer.setLayoutData((Object)new GridData(-1, 1, false, true));
        this.selectAll = new Button(buttonContainer, 8);
        this.selectAll.setText(AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_SelectAllButtonLabel);
        this.selectAll.setLayoutData((Object)new GridData(4, 1, false, true));
        this.deselectAll = new Button(buttonContainer, 8);
        this.deselectAll.setText(AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_DeselectAllButtonLabel);
        this.deselectAll.setLayoutData((Object)new GridData(4, 1, false, true));
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void refresh() {
        if (this.ctrl_chkboxTableViewer != null) {
            this.ctrl_chkboxTableViewer.refresh();
            if (this.ctrl_chkboxTableViewer.getTable() != null && this.ctrl_chkboxTableViewer.getTable().getItems() != null && this.ctrl_chkboxTableViewer.getTable().getItems().length == 0) {
                if (this.ctrl_chkboxTableViewer.getControl() != null) {
                    this.ctrl_chkboxTableViewer.getControl().setEnabled(false);
                }
                this.selectAll.setEnabled(false);
                this.deselectAll.setEnabled(false);
            }
        }
    }

    private void addListeners() {
        IWizardContainer container;
        if (this.getWizard() != null && (container = this.getWizard().getContainer()) instanceof WizardDialog) {
            ((WizardDialog)container).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    SaveAllEditorsPage.this.refresh();
                }
            });
        }
        this.selectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SaveAllEditorsPage.this.ctrl_chkboxTableViewer.setAllChecked(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SaveAllEditorsPage.this.ctrl_chkboxTableViewer.setAllChecked(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public IWizardPage getNextPage() {
        this.performSaveAndClose();
        return super.getNextPage();
    }

    protected void performSaveAndClose() {
        Object[] checkedArray = this.ctrl_chkboxTableViewer.getCheckedElements();
        int i = 0;
        while (i < checkedArray.length) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveEditor(((IEditorReference)checkedArray[i]).getEditor(false), false);
            ++i;
        }
        SaveAllEditorsPage.performClose(this.doClose);
    }

    protected static void performClose(boolean doClose) {
        if (doClose) {
            EditorChooser.getInstance().closeAllMethodEditors();
        }
    }

    private static boolean isUnsavedEditor() {
        boolean anEditorIsDirty = false;
        List<IEditorReference> methodEditors = EditorChooser.getInstance().getOpenMethodEditors();
        for (IEditorReference editor : methodEditors) {
            if (!editor.isDirty()) continue;
            anEditorIsDirty = true;
            break;
        }
        return anEditorIsDirty;
    }

    private static boolean isOpenEditor(boolean doClose) {
        List<IEditorReference> methodEditors = EditorChooser.getInstance().getOpenMethodEditors();
        return doClose && methodEditors.size() > 0;
    }

    public boolean isPageComplete() {
        return true;
    }
}

