/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.service.utils;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.service.utils.ICommandLineRunner;
import org.osgi.framework.Bundle;

public class CommandLineRunUtil {
    private static CommandLineRunUtil instance = new CommandLineRunUtil();
    private boolean needToRun = false;
    private boolean neverExcuted = true;

    public static CommandLineRunUtil getInstance() {
        return instance;
    }

    public boolean execute(String[] args) {
        this.setNeverExcuted(false);
        this.executeCommandRunner(args, "commandLinePluginImporter");
        return false;
    }

    protected boolean executeCommandRunner(String[] args, String runnerId) {
        ICommandLineRunner runner = CommandLineRunUtil.getRunner(runnerId);
        if (runner != null) {
            return runner.execute(args);
        }
        return false;
    }

    private static final ICommandLineRunner getRunner(String id) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.epf.common.service", "commandLineRunners");
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String pluginId = extension.getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)pluginId);
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String className;
                IConfigurationElement configElement = configElements[j];
                String runnerId = configElement.getAttribute("runnerId");
                if (runnerId != null && (runnerId = runnerId.trim()).equals(id) && (className = configElement.getAttribute("class")) != null) {
                    className = className.trim();
                    try {
                        ICommandLineRunner runner = (ICommandLineRunner)bundle.loadClass(className).newInstance();
                        return runner;
                    }
                    catch (Exception exception) {}
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public boolean isNeedToRun() {
        return this.needToRun;
    }

    public void setNeedToRun(boolean needToRun) {
        this.needToRun = needToRun;
    }

    public static void setInstance(CommandLineRunUtil instance) {
        CommandLineRunUtil.instance = instance;
    }

    public boolean isNeverExcuted() {
        return this.neverExcuted;
    }

    protected void setNeverExcuted(boolean neverExcuted) {
        this.neverExcuted = neverExcuted;
    }
}

