/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.service.versioning;

import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.osgi.framework.Version;

public class EPFVersion {
    protected Version toolVersion;
    protected Version libraryVersion;
    protected Version xmlSchemaVersion;

    public EPFVersion() {
        this.toolVersion = Version.emptyVersion;
        this.libraryVersion = Version.emptyVersion;
        this.xmlSchemaVersion = Version.emptyVersion;
    }

    public EPFVersion(String toolVersion, String libraryVersion, String xmlSchemaVersion) {
        this.toolVersion = new Version(toolVersion);
        this.libraryVersion = new Version(libraryVersion);
        this.xmlSchemaVersion = new Version(xmlSchemaVersion);
    }

    public Version getToolVersion() {
        return this.toolVersion;
    }

    public Version getLibraryVersion() {
        return this.libraryVersion;
    }

    public Version getXMLSchemaVersion() {
        return this.xmlSchemaVersion;
    }

    public int compareToolVersionTo(Version toolVersion) {
        if (!VersionUtil.isVersionCheckingDisabled()) {
            return this.getToolVersion().compareTo(toolVersion);
        }
        return 0;
    }

    public int compareLibraryVersionTo(Version libraryVersion) {
        if (!VersionUtil.isVersionCheckingDisabled()) {
            return this.getLibraryVersion().compareTo(libraryVersion);
        }
        return 0;
    }

    public int compareXMLSchemaVersionTo(Version XMLSchemaVersion) {
        if (!VersionUtil.isVersionCheckingDisabled()) {
            return this.getXMLSchemaVersion().compareTo(XMLSchemaVersion);
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.getToolVersion().toString()) + "," + this.getLibraryVersion().toString() + "," + this.getXMLSchemaVersion().toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EPFVersion)) {
            return false;
        }
        EPFVersion other = (EPFVersion)object;
        return this.getToolVersion().equals((Object)other.getToolVersion()) && this.getLibraryVersion().equals((Object)other.getLibraryVersion()) && this.getXMLSchemaVersion().equals((Object)other.getXMLSchemaVersion());
    }

    public int hashCode() {
        int result = this.toolVersion.hashCode();
        result ^= this.libraryVersion.hashCode();
        return result ^= this.xmlSchemaVersion.hashCode();
    }
}

