/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.service.versioning;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epf.common.service.versioning.EPFVersion;
import org.osgi.framework.Version;

public class EPFVersions {
    public static final String TOOL_ID = "epf";
    private static String nsUri = "http://www.eclipse.org/epf";
    private static EPFVersion EPF_10 = new EPFVersion("1.0", "1.0.3.0", "1.0.0");
    private static EPFVersion EPF_11 = new EPFVersion("1.1", "1.0.4.0", "1.0.0");
    private static EPFVersion EPF_12 = new EPFVersion("1.2", "1.0.4.1", "1.0.1");
    private static EPFVersion EPF_15 = new EPFVersion("1.5", "1.0.5.0", "1.0.2");
    private static EPFVersion EPF_151;
    private static EPFVersion currentVersion;

    static {
        currentVersion = EPF_151 = new EPFVersion("1.5.1", "1.0.6.0", "1.0.2");
    }

    public EPFVersion getCurrentVersion() {
        return currentVersion;
    }

    public EPFVersion getVersion(String toolVersion) {
        if (toolVersion != null) {
            for (EPFVersion ver : this.getAllVersions()) {
                if (!ver.getToolVersion().equals((Object)new Version(toolVersion))) continue;
                return ver;
            }
        }
        return null;
    }

    public Collection getAllVersions() {
        ArrayList<EPFVersion> versions = new ArrayList<EPFVersion>();
        versions.add(EPF_10);
        versions.add(EPF_11);
        versions.add(EPF_12);
        versions.add(EPF_15);
        versions.add(EPF_151);
        return versions;
    }

    public EPFVersion getMinToolVersionForLibraryVersion(Version libraryVersion) {
        for (EPFVersion versionInfo : this.getAllVersions()) {
            if (versionInfo.getLibraryVersion().compareTo(libraryVersion) != 0) continue;
            return versionInfo;
        }
        return null;
    }

    public EPFVersion getMinToolVersionForCurrentLibraryVersion() {
        Version libraryVersion = this.getCurrentVersion().getLibraryVersion();
        return this.getMinToolVersionForLibraryVersion(libraryVersion);
    }

    public EPFVersion getMinToolVersionForXMLSchemaVersion(Version xmlSchemaVersion) {
        for (EPFVersion versionInfo : this.getAllVersions()) {
            if (versionInfo.getXMLSchemaVersion().compareTo(xmlSchemaVersion) != 0) continue;
            return versionInfo;
        }
        return null;
    }

    public EPFVersion getMinToolVersionForCurrentXMLSchemaVersion() {
        Version xmlSchemaVersion = this.getCurrentVersion().getXMLSchemaVersion();
        return this.getMinToolVersionForXMLSchemaVersion(xmlSchemaVersion);
    }

    public String getNsURI() {
        return nsUri;
    }
}

