/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.service.versioning;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.service.ServicePlugin;
import org.eclipse.epf.common.service.versioning.EPFVersion;
import org.eclipse.epf.common.service.versioning.EPFVersions;
import org.eclipse.epf.common.service.versioning.ILibraryExtensionVersionCheck;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionUtil {
    public static final String EXTENSION_POINT_NAMESPACE = ServicePlugin.class.getPackage().getName();
    public static final String EXTENSION_POINT_NAME = "version";
    public static final String EXTENSION_VERSIONS_INFO = "versions";
    public static final String EXTENSION_LIB_EXTENSION_CHECK = "libraryExtensionVersionCheck";
    private static final String DISABLE_VERSION_CHECKING_PREF = "disable_version_checking";
    public static Map<String, EPFVersions> versions = new LinkedHashMap<String, EPFVersions>();
    public static Map<String, ILibraryExtensionVersionCheck> libExtCheckers = new LinkedHashMap<String, ILibraryExtensionVersionCheck>();
    protected static boolean versionCheckingDisabled = false;
    private static List<String> toolIDsCheckList = new ArrayList<String>();
    public static final Pattern p_XMIVersionPattern;
    public static final Pattern p_XMLVersionAttributePattern;
    public static final Pattern p_XMI_ELEMENT_START_TAG;
    public static final String XML_ELEMENT_END_TAG = ">";
    public static final String XMI_ATTRIBUTE_TAG = "xmi";
    public static final String XML_ELEMENT_START_TAG = "<uma:MethodLibrary";
    public static final String XML_VERSIONS_SEPARATOR = ";";
    public static final String XML_TOOL_VERSION_SEPARATOR = "=";

    static {
        toolIDsCheckList.add("epf");
        try {
            String valueStr = ServicePlugin.getDefault().getPreferenceStore().getString(DISABLE_VERSION_CHECKING_PREF);
            versionCheckingDisabled = Boolean.valueOf(valueStr);
        }
        catch (MissingResourceException missingResourceException) {
            versionCheckingDisabled = false;
        }
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                VersionUtil.initExtension(extension);
                ++i;
            }
        }
        p_XMIVersionPattern = Pattern.compile("(\\w+?):version=\"(.+?)\"", 32);
        p_XMLVersionAttributePattern = Pattern.compile("tool=\"(.*?)\"", 32);
        p_XMI_ELEMENT_START_TAG = Pattern.compile("<?xml version=\".+?\" encoding=\".+?\"?>");
    }

    protected static void initExtension(IExtension extension) {
        String extensionID = extension.getSimpleIdentifier();
        String pluginId = extension.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)pluginId);
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            IConfigurationElement configElement = configElements[j];
            try {
                String className;
                if (EXTENSION_VERSIONS_INFO.equals(configElement.getName()) && (className = configElement.getAttribute("class")) != null) {
                    versions.put(extensionID, (EPFVersions)bundle.loadClass(className).newInstance());
                    break;
                }
                if (EXTENSION_LIB_EXTENSION_CHECK.equals(configElement.getName()) && (className = configElement.getAttribute("class")) != null) {
                    libExtCheckers.put(extensionID, (ILibraryExtensionVersionCheck)bundle.loadClass(className).newInstance());
                    break;
                }
            }
            catch (Exception e) {
                ServicePlugin.getDefault().getLogger().logError((Throwable)e);
            }
            ++j;
        }
    }

    public static Map getVersionsMap() {
        return Collections.unmodifiableMap(versions);
    }

    public static Set<String> getAllToolIDs() {
        return Collections.unmodifiableSet(versions.keySet());
    }

    public static EPFVersions getVersions(String toolID) {
        return versions.get(toolID);
    }

    public static boolean isVersionCheckingDisabled() {
        return versionCheckingDisabled;
    }

    protected static Map readVersionsFromXMLFile(File xmlFile) {
        String toolsAttribute;
        String rootElement;
        Matcher mAttribute;
        int xmiElementEndIdx;
        int xmiElementStartIdx;
        LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
        StringBuffer buf = null;
        try {
            buf = FileUtil.readFile((File)xmlFile, (String)"UTF-8");
        }
        catch (Exception ex) {
            ServicePlugin.getDefault().getLogger().logError((Throwable)ex);
        }
        if (buf != null && (xmiElementStartIdx = buf.indexOf(XML_ELEMENT_START_TAG)) != -1 && (xmiElementEndIdx = buf.indexOf(XML_ELEMENT_END_TAG, xmiElementStartIdx + XML_ELEMENT_START_TAG.length())) != -1 && (mAttribute = p_XMLVersionAttributePattern.matcher(rootElement = buf.substring(xmiElementStartIdx, xmiElementEndIdx))).find() && (toolsAttribute = mAttribute.group(1)) != null && toolsAttribute.length() > 0) {
            String[] versionsArray = StrUtil.split((String)toolsAttribute, (String)XML_VERSIONS_SEPARATOR);
            int i = 0;
            while (i < versionsArray.length) {
                String[] versionInfoArray;
                if (versionsArray[i] != null && versionsArray[i].length() > 0 && (versionInfoArray = StrUtil.split((String)versionsArray[i], (String)XML_TOOL_VERSION_SEPARATOR)).length == 2) {
                    String toolID = versionInfoArray[0];
                    String toolVersion = versionInfoArray[1];
                    if (toolID != null && toolID.trim().length() > 0 && toolVersion != null && toolVersion.trim().length() > 0) {
                        versions.put(toolID, toolVersion);
                    }
                }
                ++i;
            }
        }
        if (versions.size() == 0) {
            return null;
        }
        return versions;
    }

    protected static Map readVersionsFromXMIFile(File xmiFile) {
        int docHeaderEndIdx;
        int xmiElementEndIdx;
        Matcher docStartMatcher;
        LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
        StringBuffer buf = null;
        try {
            buf = FileUtil.readFile((File)xmiFile, (String)"UTF-8");
        }
        catch (Exception ex) {
            ServicePlugin.getDefault().getLogger().logError((Throwable)ex);
        }
        if (buf != null && (docStartMatcher = p_XMI_ELEMENT_START_TAG.matcher(buf)).find() && (xmiElementEndIdx = buf.indexOf(XML_ELEMENT_END_TAG, docHeaderEndIdx = docStartMatcher.end())) != -1) {
            String rootElement = buf.substring(docHeaderEndIdx, xmiElementEndIdx + 1);
            Matcher m = p_XMIVersionPattern.matcher(rootElement);
            while (m.find()) {
                String toolID = m.group(1);
                if (toolID.equals(XMI_ATTRIBUTE_TAG)) continue;
                String toolVersion = m.group(2);
                if (toolID == null || toolID.trim().length() <= 0 || toolVersion == null || toolVersion.trim().length() <= 0) continue;
                versions.put(toolID, toolVersion);
            }
        }
        if (versions.size() == 0) {
            return null;
        }
        return versions;
    }

    public static Map readVersionsFromFile(File file) {
        if (file.getName().toUpperCase().endsWith("XMI")) {
            return VersionUtil.readVersionsFromXMIFile(file);
        }
        if (file.getName().toUpperCase().endsWith("XML")) {
            return VersionUtil.readVersionsFromXMLFile(file);
        }
        Map versions = VersionUtil.readVersionsFromXMIFile(file);
        if (versions != null) {
            return versions;
        }
        versions = VersionUtil.readVersionsFromXMLFile(file);
        if (versions != null) {
            return versions;
        }
        return null;
    }

    public static VersionCheckInfo checkXMLVersion(File file) {
        Map versionMap = VersionUtil.readVersionsFromFile(file);
        if (versionMap == null) {
            return null;
        }
        VersionCheckInfo vci = null;
        for (String toolID : toolIDsCheckList) {
            String toolVersion;
            if (versionMap.get(toolID) == null || (vci = VersionUtil._checkXMLVersion(toolID, toolVersion = (String)versionMap.get(toolID))) == null) continue;
            return vci;
        }
        return null;
    }

    private static VersionCheckInfo _checkXMLVersion(String toolID, String toolVersion) {
        EPFVersions versions = VersionUtil.getVersions(toolID);
        if (versions != null) {
            EPFVersion minCurrVersion = versions.getMinToolVersionForCurrentXMLSchemaVersion();
            int result = minCurrVersion.compareToolVersionTo(new Version(toolVersion));
            String currentMinToolVersion = minCurrVersion.getToolVersion().toString();
            return new VersionCheckInfo(toolID, toolVersion, currentMinToolVersion, -result);
        }
        return null;
    }

    public static VersionCheckInfo checkLibraryVersion(File file) {
        Map versionMap;
        if (file.getName().equals("library.xmi")) {
            for (String toolID : toolIDsCheckList) {
                if (libExtCheckers.get(toolID) == null) continue;
                VersionCheckInfo vci = null;
                ILibraryExtensionVersionCheck extCheck = libExtCheckers.get(toolID);
                vci = extCheck.checkLibraryVersion(file.getParentFile());
                if (vci == null) continue;
                return vci;
            }
        }
        if ((versionMap = VersionUtil.readVersionsFromFile(file)) == null) {
            return null;
        }
        VersionCheckInfo vci = null;
        for (String toolID : toolIDsCheckList) {
            String toolVersion;
            if (versionMap.get(toolID) == null || (vci = VersionUtil._checkLibVersion(toolID, toolVersion = (String)versionMap.get(toolID))) == null) continue;
            return vci;
        }
        return null;
    }

    private static VersionCheckInfo _checkLibVersion(String toolID, String toolVersion) {
        EPFVersions versions = VersionUtil.getVersions(toolID);
        if (versions != null) {
            EPFVersion minCurrVersion = versions.getMinToolVersionForCurrentLibraryVersion();
            int result = minCurrVersion.compareToolVersionTo(new Version(toolVersion));
            String currentMinToolVersion = minCurrVersion.getToolVersion().toString();
            return new VersionCheckInfo(toolID, toolVersion, currentMinToolVersion, -result);
        }
        return null;
    }

    public static String getPrimaryToolID() {
        return toolIDsCheckList.get(0);
    }

    public static boolean addToolID(String toolID, String toolIDfollowing) {
        if (toolIDfollowing != null) {
            int idx = toolIDsCheckList.indexOf(toolIDfollowing);
            if (idx != -1) {
                toolIDsCheckList.add(idx, toolID);
                return true;
            }
            return false;
        }
        toolIDsCheckList.add(0, toolID);
        return true;
    }

    public static class VersionCheckInfo {
        public String toolID;
        public String toolVersion;
        public String currentMinToolVersion;
        public int result;

        public VersionCheckInfo(String id, String toolVersion, String currentMinToolVersion, int result) {
            this.toolID = id;
            this.toolVersion = toolVersion;
            this.currentMinToolVersion = currentMinToolVersion;
            this.result = result;
        }
    }
}

