/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.dataexchange.internal.importing;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.dataexchange.importing.PluginService;
import org.eclipse.epf.dataexchange.internal.importing.PluginServiceImpl;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaFactory;

public class LibraryServiceImpl
implements org.eclipse.epf.dataexchange.importing.LibraryService {
    public MethodPlugin createPlugin(String name, String guid) throws Exception {
        return this.createPlugin(name, guid, null);
    }

    public MethodPlugin createPlugin(String name, String guid, Map options) throws Exception {
        Map renameElementMap;
        MethodPlugin plugin = UmaFactory.eINSTANCE.createMethodPlugin();
        plugin.setName(name);
        plugin.setGuid(guid);
        plugin = ModelStorage.initialize((MethodPlugin)plugin);
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        library.getMethodPlugins().add(plugin);
        if (options != null && (renameElementMap = (Map)options.get("renameElementMap")) != null) {
            LibraryServiceImpl.ensureUniqueName((EObject)library, (MethodElement)plugin, renameElementMap);
        }
        MethodLibraryPersister.INSTANCE.save(library.eResource());
        MethodLibraryPersister.INSTANCE.save(plugin.eResource());
        library.eResource().setModified(true);
        plugin.eResource().setModified(true);
        return plugin;
    }

    public MethodConfiguration createConfiguration(String name, String guid) {
        MethodConfiguration config = UmaFactory.eINSTANCE.createMethodConfiguration();
        config.setName(name);
        config.setGuid(guid);
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        boolean oldNotify = library.eDeliver();
        try {
            library.eSetDeliver(false);
            library.getPredefinedConfigurations().add(config);
        }
        finally {
            library.eSetDeliver(oldNotify);
        }
        return config;
    }

    public PluginService createPluginService(MethodPlugin plugin) {
        return new PluginServiceImpl(plugin);
    }

    private static void ensureUniqueName(EObject owner, MethodElement newObj, Map renameElementMap) {
        String name;
        if (owner == null) {
            return;
        }
        Class<?> cls = newObj.getClass();
        HashMap<String, MethodElement> nameMap = new HashMap<String, MethodElement>();
        int i = 0;
        while (i < owner.eContents().size()) {
            Object oldObj = owner.eContents().get(i);
            if (oldObj.getClass() == cls && oldObj != newObj) {
                MethodElement oldElem = (MethodElement)oldObj;
                nameMap.put(oldElem.getName(), oldElem);
            }
            ++i;
        }
        String renamed = name = newObj.getName();
        while (nameMap.containsKey(renamed)) {
            renamed = String.valueOf(renamed) + "_renamed";
        }
        if (renamed != name) {
            newObj.setName(renamed);
            Object[] entryVal = new Object[]{newObj, name, nameMap.get(name), renamed};
            renameElementMap.put(newObj.getGuid(), entryVal);
        }
    }
}

