/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.dataexchange.util;

import java.io.File;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.dataexchange.util.IResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.uma.MethodPlugin;

public class ContentProcessor {
    protected static final Pattern p_src_ref = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);
    protected static final Pattern p_href_ref = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    IResourceHandler handler;
    ILogger logger;

    public ContentProcessor(IResourceHandler handler, ILogger logger) {
        this.handler = handler;
        this.logger = logger;
    }

    public String resolveResourceFiles(Object owner, String source) {
        StringBuffer sb = new StringBuffer();
        try {
            String url;
            Matcher m = p_src_ref.matcher(source);
            while (m.find()) {
                url = m.group(1);
                String new_url = this.processResourceUrl(owner, url);
                String replacement = "src=\"" + new_url + "\"";
                m.appendReplacement(sb, this.fixReplacementStr(replacement));
            }
            m.appendTail(sb);
            m = p_href_ref.matcher(sb.toString());
            sb.setLength(0);
            while (m.find()) {
                url = m.group(1);
                String mark = "";
                int index = url.indexOf("#");
                if (index >= 0) {
                    mark = url.substring(index);
                    url = url.substring(0, index);
                }
                if (url.length() > 0) {
                    url = this.processResourceUrl(owner, url);
                }
                m.appendReplacement(sb, this.fixReplacementStr("href=\"" + url + mark + "\""));
            }
            m.appendTail(sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private String fixReplacementStr(String str) {
        try {
            int index = str.indexOf("$");
            if (index < 0) {
                return str;
            }
            StringBuffer b = new StringBuffer();
            int start = 0;
            while (index >= 0) {
                b.append(str.substring(start, index)).append("\\$");
                start = index + 1;
                index = str.indexOf("$", start);
            }
            b.append(str.substring(start));
            return b.toString();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return str;
        }
    }

    protected boolean isFileUrl(String url) {
        return url != null && url.length() != 0 && !url.startsWith("http") && !url.startsWith("www.") && !url.startsWith("mailto:") && url.toLowerCase().indexOf("javascript:") < 0;
    }

    protected boolean isValidFilePath(File f) {
        return f != null && f.exists();
    }

    public String processResourceUrl(Object owner, String url) {
        if (!this.isFileUrl(url)) {
            return url;
        }
        UrlInfo info = null;
        try {
            info = this.handler.resolveFileUrl(owner, url);
        }
        catch (Exception exception) {
            this.logger.logWarning("error processing url '" + url + "'");
            return url;
        }
        if (info.sourceFile == null || info.targetFile == null) {
            return url;
        }
        if (info.sourceFile.isFile() && info.sourceFile.exists()) {
            FileUtil.copyFile((File)info.sourceFile, (File)info.targetFile);
            return info.targetUrl;
        }
        return url;
    }

    protected void processUrlText(Object owner, String source) {
        String url;
        Matcher m = p_href_ref.matcher(source);
        if (m.find() && (url = m.group(1)).toLowerCase().indexOf("javaScript:") < 0) {
            int index = url.indexOf("#");
            if (index >= 0) {
                url = url.substring(0, index);
            }
            if (url.length() > 0) {
                this.processResourceUrl(owner, url);
            }
        }
    }

    public void copyResource(String sourceFile) {
        this.handler.copyResource(sourceFile);
    }

    public void copyResource(String sourceFile, EObject obj, MethodPlugin umaPlugin) {
        this.handler.copyResource(sourceFile, obj, umaPlugin);
    }

    public String resolveAttachmentResources(Object owner, String urls) {
        if (urls != null && urls.length() != 0) {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer st = new StringTokenizer(urls, "|");
            while (st.hasMoreTokens()) {
                String url = st.nextToken();
                url = this.processResourceUrl(owner, url);
                if (buffer.length() > 0) {
                    buffer.append("|");
                }
                buffer.append(url);
            }
            return buffer.toString();
        }
        return "";
    }
}

