/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTypeCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Map<EModelElement, String> elementToNewTypeMap = new HashMap<EModelElement, String>();
    private Map<EModelElement, String> elementToOldTypeMap;
    private Map<View, String> viewToNewTypeMap = new HashMap<View, String>();
    private Map<View, String> viewToOldTypeMap;

    public Collection<Resource> getModifiedResources() {
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        for (EModelElement e : this.elementToNewTypeMap.keySet()) {
            Resource resource = e.eResource();
            if (resource == null) continue;
            modifiedResources.add(resource);
        }
        return modifiedResources;
    }

    public void execute() {
        String oldType;
        if (this.elementToOldTypeMap == null) {
            this.elementToOldTypeMap = new HashMap<EModelElement, String>();
        } else {
            this.elementToOldTypeMap.clear();
        }
        for (Map.Entry<EModelElement, String> entry : this.elementToNewTypeMap.entrySet()) {
            final EModelElement e = entry.getKey();
            final String type = entry.getValue();
            try {
                oldType = BridgeHelper.getEAnnotationDetail((EModelElement)e, (String)"type");
                TxUtil.runInTransaction((EObject)e, (Runnable)new Runnable(){

                    public void run() {
                        BridgeHelper.addEAnnotationType((EModelElement)e, (String)type);
                    }
                });
                this.elementToOldTypeMap.put(e, oldType);
            }
            catch (Exception ex) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
                throw new WrappedException(ex);
            }
        }
        if (!this.viewToNewTypeMap.isEmpty()) {
            if (this.viewToOldTypeMap == null) {
                this.viewToOldTypeMap = new HashMap<View, String>();
            } else {
                this.viewToOldTypeMap.clear();
            }
            for (Map.Entry<EModelElement, String> entry : this.viewToNewTypeMap.entrySet()) {
                final View view = (View)entry.getKey();
                final String newType = entry.getValue();
                oldType = view.getType();
                try {
                    TxUtil.runInTransaction((EObject)view, (Runnable)new Runnable(){

                        public void run() {
                            String newNameType = String.valueOf(SetTypeCommand.getViewNameType(Integer.parseInt(newType)));
                            String oldNameType = String.valueOf(SetTypeCommand.getViewNameType(Integer.parseInt(oldType)));
                            view.setType(newType);
                            for (View child : view.getChildren()) {
                                if (!child.getType().equals(oldNameType)) continue;
                                child.setType(newNameType);
                            }
                        }
                    });
                    this.viewToOldTypeMap.put(view, oldType);
                }
                catch (Exception e) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                    throw new WrappedException(e);
                }
            }
        }
    }

    public void undo() {
        if (this.elementToOldTypeMap != null && !this.elementToOldTypeMap.isEmpty()) {
            for (Map.Entry<EModelElement, String> entry : this.elementToOldTypeMap.entrySet()) {
                final EModelElement e = entry.getKey();
                final String type = entry.getValue();
                try {
                    TxUtil.runInTransaction((EObject)e, (Runnable)new Runnable(){

                        public void run() {
                            BridgeHelper.addEAnnotationType((EModelElement)e, (String)type);
                        }
                    });
                }
                catch (Exception ex) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
                    throw new WrappedException(ex);
                }
            }
            this.elementToOldTypeMap.clear();
        }
        if (this.viewToOldTypeMap != null && !this.viewToOldTypeMap.isEmpty()) {
            for (Map.Entry<EModelElement, String> entry : this.viewToOldTypeMap.entrySet()) {
                final View view = (View)entry.getKey();
                final String oldType = entry.getValue();
                try {
                    TxUtil.runInTransaction((EObject)view, (Runnable)new Runnable(){

                        public void run() {
                            String newNameType = String.valueOf(SetTypeCommand.getViewNameType(Integer.parseInt(view.getType())));
                            String oldNameType = String.valueOf(SetTypeCommand.getViewNameType(Integer.parseInt(oldType)));
                            view.setType(oldType);
                            for (View child : view.getChildren()) {
                                if (!child.getType().equals(newNameType)) continue;
                                child.setType(oldNameType);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                    throw new WrappedException(e);
                }
            }
            this.viewToOldTypeMap.clear();
        }
    }

    public void redo() {
        this.execute();
    }

    protected boolean prepare() {
        return !this.elementToNewTypeMap.isEmpty();
    }

    public void prepare(View view, EModelElement e, String type) {
        this.elementToNewTypeMap.put(e, type);
        int viewType = SetTypeCommand.getViewType(type);
        if (viewType != -1) {
            this.viewToNewTypeMap.put(view, String.valueOf(viewType));
        }
    }

    public void dispose() {
        if (this.elementToNewTypeMap != null) {
            this.elementToNewTypeMap.clear();
        }
        if (this.elementToOldTypeMap != null) {
            this.elementToOldTypeMap.clear();
        }
        if (this.viewToNewTypeMap != null) {
            this.viewToNewTypeMap.clear();
        }
        if (this.viewToOldTypeMap != null) {
            this.viewToOldTypeMap.clear();
        }
    }

    public static int getViewType(String elementType) {
        if ("Activity".equals(elementType)) {
            return 1007;
        }
        if ("Phase".equals(elementType)) {
            return 1010;
        }
        if ("Iteration".equals(elementType)) {
            return 1011;
        }
        if ("Milestone".equals(elementType)) {
            return 1012;
        }
        if ("Task".equals(elementType)) {
            return 1009;
        }
        return -1;
    }

    public static int getViewNameType(int viewType) {
        switch (viewType) {
            case 1007: {
                return 4005;
            }
            case 1010: {
                return 4009;
            }
            case 1011: {
                return 4010;
            }
            case 1009: {
                return 4008;
            }
            case 1012: {
                return 4011;
            }
        }
        return -1;
    }
}

