/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.custom.figures;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class DecisionNodeFigure
extends DefaultSizeNodeFigure
implements IPolygonAnchorableFigure {
    private int spacing;

    public DecisionNodeFigure(int width, int height, int spacing) {
        super(width, height);
        this.spacing = spacing;
        this.createFigure(width, height);
    }

    public DecisionNodeFigure(Dimension defSize) {
        super(defSize);
    }

    public DecisionNodeFigure(int width, int height) {
        super(width, height);
    }

    public PointList getPolygonPoints() {
        return this.getPoints();
    }

    protected void paintFigure(Graphics g) {
        PointList points = this.getPointList(this.getBounds().getCopy());
        g.fillPolygon(points);
        g.drawPolygon(points);
    }

    protected PointList getPointList(Rectangle rect) {
        PointList points = new PointList();
        int halfX = rect.x + rect.width / 2;
        int halfY = rect.y + rect.height / 2;
        Point p1 = new Point(halfX, rect.y);
        Point p2 = new Point(rect.x + rect.width - 1, halfY);
        Point p3 = new Point(halfX, rect.y + rect.height - 1);
        Point p4 = new Point(rect.x, halfY);
        points.addPoint(p1);
        points.addPoint(p2);
        points.addPoint(p3);
        points.addPoint(p4);
        points.addPoint(p1);
        return points;
    }

    public IFigure getContentPane() {
        return (IFigure)this.getChildren().get(0);
    }

    public void createFigure(int width, int height) {
        this.setOpaque(true);
        this.setLayoutManager((LayoutManager)new StackLayout(){

            public void layout(IFigure figure) {
                Rectangle r = figure.getClientArea();
                List children = figure.getChildren();
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    Dimension d = child.getPreferredSize(r.width, r.height);
                    d.width = Math.min(d.width, r.width);
                    d.height = Math.min(d.height, r.height);
                    Rectangle childRect = new Rectangle(r.x + (r.width - d.width) / 2, r.y + (r.height - d.height) / 2, d.width, d.height);
                    child.setBounds(childRect);
                    ++i;
                }
            }
        });
        Figure f = new Figure();
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
        layout.setSpacing(this.spacing);
        f.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)f);
    }

    public PointList getPoints() {
        return this.getPointList(this.getBounds().getCopy());
    }
}

