/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.custom.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.ad.edit.parts.ActivityPartitionEditPart;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.AddCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createAddCommand(EditPart child, Object constraint) {
        EditPart parent = child.getParent();
        if (parent instanceof ActivityPartitionEditPart && child instanceof ShapeEditPart && constraint instanceof Rectangle) {
            boolean adjustLocationNeeded;
            Rectangle rect = (Rectangle)constraint;
            IFigure parentFigure = ((ActivityPartitionEditPart)parent).getFigure();
            View view = (View)child.getModel();
            boolean bl = adjustLocationNeeded = ViewUtil.resolveSemanticElement((View)view) != null || parentFigure.getBounds().contains(rect.getLocation());
            if (adjustLocationNeeded) {
                int x = rect.x - ((ActivityPartitionEditPart)parent).getLocation().x;
                int y = rect.y - ((ActivityPartitionEditPart)parent).getLocation().y;
                SetBoundsCommand boundsCommand = new SetBoundsCommand(((ShapeEditPart)child).getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), new Point(x, y));
                return new ICommandProxy((ICommand)boundsCommand);
            }
        }
        return super.createAddCommand(child, constraint);
    }

    protected Command getMoveChildrenCommand(Request request) {
        return super.getMoveChildrenCommand(request);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return super.createChangeConstraintCommand(child, constraint);
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        Command cmd;
        block5: {
            block4: {
                cmd = super.createChangeConstraintCommand(request, child, constraint);
                if (!(child instanceof ActivityPartitionEditPart)) break block4;
                List list = ActivityXYLayoutEditPolicy.getNodesInPartition((ActivityPartitionEditPart)child);
                if (list == null || list.isEmpty()) break block5;
                for (EditPart element : list) {
                    if (!(element instanceof ShapeNodeEditPart)) continue;
                    ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
                    req.setEditParts(element);
                    req.setMoveDelta(request.getMoveDelta());
                    req.setSizeDelta(request.getSizeDelta());
                    req.setLocation(request.getLocation());
                    req.setExtendedData(request.getExtendedData());
                    req.setResizeDirection(request.getResizeDirection());
                    cmd = cmd.chain(element.getParent().getCommand((Request)req));
                }
                break block5;
            }
            EditPart parent = child.getParent();
            if (parent instanceof DiagramEditPart) {
                List children = ((DiagramEditPart)parent).getChildren();
                for (EditPart part : children) {
                    if (!(part instanceof ActivityPartitionEditPart)) continue;
                    Node view = (Node)part.getModel();
                    LayoutConstraint lConstaint = view.getLayoutConstraint();
                    if (lConstaint instanceof Bounds) {
                        Rectangle partitionConstraint = ((ActivityPartitionEditPart)part).getFigure().getBounds();
                        if (!(constraint instanceof Rectangle) || !partitionConstraint.contains((Rectangle)constraint)) continue;
                        request.setType((Object)"create child");
                        cmd = cmd.chain(part.getCommand((Request)request));
                        continue;
                    }
                    if (!ActivityDiagramEditorPlugin.getInstance().isDebugging()) continue;
                    System.out.println("LayoutConstraint: " + lConstaint);
                }
            }
        }
        return cmd;
    }

    private static List getNodesInPartition(ActivityPartitionEditPart child) {
        ArrayList<EditPart> nodes = new ArrayList<EditPart>();
        ActivityPartition partition = (ActivityPartition)((Node)child.getModel()).getElement();
        EList list = partition.getNodes();
        for (Object element : list) {
            nodes.add(ActivityXYLayoutEditPolicy.findEditPartyByElement(child.getParent(), element));
        }
        return nodes;
    }

    private static EditPart findEditPartyByElement(EditPart parent, Object element) {
        List list = parent.getChildren();
        for (EditPart editPart : list) {
            if (((Node)editPart.getModel()).getElement() != element) continue;
            return editPart;
        }
        return null;
    }

    protected Command getAddCommand(Request request) {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy with Reparent if necessary");
        command.add(super.getAddCommand(request));
        if (request instanceof ChangeBoundsRequest && request.getType() == "add children") {
            ChangeBoundsRequest changeRequest = (ChangeBoundsRequest)request;
            List editParts = changeRequest.getEditParts();
            int i = 0;
            while (i < editParts.size()) {
                IGraphicalEditPart childPart = (IGraphicalEditPart)editParts.get(i);
                IGraphicalEditPart parent = (IGraphicalEditPart)childPart.getParent();
                if (parent instanceof ActivityPartitionEditPart) {
                    Point point = childPart.getFigure().getBounds().getLocation().getCopy();
                    point.translate(changeRequest.getMoveDelta());
                    if (!parent.getFigure().getBounds().contains(point)) {
                        command.add(this.getReparentCommand(childPart, parent, changeRequest));
                    }
                }
                ++i;
            }
        }
        return command.unwrap();
    }

    protected Command getReparentCommand(IGraphicalEditPart gep, IGraphicalEditPart oldParent, ChangeBoundsRequest changeRequest) {
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View container = (View)this.getHost().getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)gep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (element != null) {
            cc.compose((IUndoableOperation)new ReparentingElementsCommand(new MoveRequest(editingDomain, context, UMLPackage.eINSTANCE.getActivity_Node(), element), element, view, oldParent));
            cc.compose((IUndoableOperation)new AddCommand(gep.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)container), (IAdaptable)new EObjectAdapter((EObject)view)));
            cc.compose((IUndoableOperation)this.adjustLocationCommand(gep, changeRequest));
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    private ICommand adjustLocationCommand(IGraphicalEditPart child, ChangeBoundsRequest request) {
        if (child instanceof ShapeEditPart) {
            Point location = request.getMoveDelta().getCopy();
            Point childLocation = child.getFigure().getBounds().getLocation();
            location.x += childLocation.x;
            location.y += childLocation.y;
            SetBoundsCommand boundsCommand = new SetBoundsCommand(((ShapeEditPart)child).getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)((View)child.getModel())), location);
            return boundsCommand;
        }
        return null;
    }

    public class ReparentingElementsCommand
    extends EditElementCommand {
        private final EObject moveElement;
        private IGraphicalEditPart oldParent;
        private View view;

        public ReparentingElementsCommand(MoveRequest req, EObject element, View view, IGraphicalEditPart oldParent) {
            this("reparent on move", element, (IEditCommandRequest)req);
            this.oldParent = oldParent;
            this.view = view;
        }

        protected ReparentingElementsCommand(String label, EObject elementToEdit, IEditCommandRequest request) {
            super(label, elementToEdit, request);
            this.moveElement = elementToEdit;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            View parentView = (View)ActivityXYLayoutEditPolicy.this.getHost().getModel();
            if (parentView.getElement() instanceof Activity && this.moveElement instanceof ActivityNode) {
                View oldParentView = (View)this.oldParent.getModel();
                ((ActivityNode)this.moveElement).getInPartitions().remove((Object)oldParentView.getElement());
            }
            return null;
        }

        public boolean canExecute() {
            return this.moveElement != null;
        }
    }
}

