/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.util.DiagramCoreValidation;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.MergeNode;

public class ControlFlowReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;
    private EditPart host;

    public ControlFlowReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ControlFlow)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        ActivityNode join;
        EList list;
        if (!(this.oldEnd instanceof ActivityNode) || !(this.newEnd instanceof ActivityNode)) {
            return false;
        }
        ActivityNode target = this.getLink().getTarget();
        if (!this.canConnect((ActivityNode)this.newEnd, target)) {
            return false;
        }
        return !(this.newEnd instanceof MergeNode) && !(this.newEnd instanceof JoinNode) || (list = (join = (ActivityNode)this.newEnd).getOutgoings()) == null || list.size() < 1;
    }

    protected boolean canReorientTarget() {
        ActivityNode join;
        EList list;
        if (!(this.oldEnd instanceof ActivityNode) || !(this.newEnd instanceof ActivityNode)) {
            return false;
        }
        ActivityNode source = this.getLink().getSource();
        if (!this.canConnect(source, (ActivityNode)this.newEnd)) {
            return false;
        }
        return !(this.newEnd instanceof DecisionNode) && !(this.newEnd instanceof ForkNode) || (list = (join = (ActivityNode)this.newEnd).getIncomings()) == null || list.size() < 1;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ControlFlow getLink() {
        return (ControlFlow)this.getElementToEdit();
    }

    protected ActivityNode getOldSource() {
        return (ActivityNode)this.oldEnd;
    }

    protected ActivityNode getNewSource() {
        return (ActivityNode)this.newEnd;
    }

    protected ActivityNode getOldTarget() {
        return (ActivityNode)this.oldEnd;
    }

    protected ActivityNode getNewTarget() {
        return (ActivityNode)this.newEnd;
    }

    public void setHost(EditPart host) {
        this.host = host;
    }

    public EditPart getHost() {
        return this.host;
    }

    private boolean canConnect(ActivityNode source, ActivityNode target) {
        if (!(this.getLink().eContainer() instanceof Activity)) {
            return false;
        }
        if (DiagramCoreValidation.isDuplicateRelationship((EObject)source, (EObject)target)) {
            return false;
        }
        return this.getHost() == null || DiagramCoreValidation.canConnect((EditPart)this.getHost(), (EObject)source, (EObject)target) == null;
    }
}

