/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.add.part;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.add.ADDImages;
import org.eclipse.epf.diagram.add.edit.parts.ActivityDetailDiagramEditPart;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.service.DiagramResetService;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.actions.DiagramActionsService;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;

public class ADDiagramEditor
extends AbstractDiagramEditor {
    DiagramActionsService actionService = null;

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        DiagramRootEditPart root = (DiagramRootEditPart)this.getDiagramGraphicalViewer().getRootEditPart();
        LayeredPane cfr_ignored_0 = (LayeredPane)root.getLayer((Object)"Printable Layers");
        FreeformLayer extLabelsLayer = new FreeformLayer();
        extLabelsLayer.setLayoutManager((LayoutManager)new DelegatingLayout());
        LayeredPane scalableLayers = (LayeredPane)root.getLayer((Object)"Scalable Layers");
        FreeformLayer scaledFeedbackLayer = new FreeformLayer();
        scaledFeedbackLayer.setEnabled(false);
        scalableLayers.addLayerAfter((Layer)scaledFeedbackLayer, (Object)"Scaled Feedback Layer", (Object)"Decoration Unprintable Layer");
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        super.setGraphicalViewer(viewer);
        if (this.actionService != null) {
            this.actionService.setGraphicalViewer(viewer);
        }
    }

    public void cleanUpDiagram() {
        DiagramResetService service = new DiagramResetService(this.getDiagramManager().getEditingDomain(), this.getGraphicalViewer(), this.getEditDomain(), this.getActionRegistry());
        service.cleanUpDiagram();
    }

    public void contributeToContextMenu(IMenuManager menu) {
        IContributionItem item1;
        IContributionItem item;
        super.contributeToContextMenu(menu);
        boolean canModify = this.isEditable();
        IAction action = this.getActionRegistry().getAction((Object)"reset_diagram_layout");
        if (action.isEnabled() && canModify) {
            menu.insertBefore("showPropertiesViewAction", action);
        }
        if ((item = menu.find("toolbarArrangeAllAction")) != null) {
            item.setVisible(false);
        }
        if ((item1 = menu.find("formatMenu")) != null && item1 instanceof IMenuManager) {
            ((IMenuManager)item1).setVisible(false);
        }
    }

    protected void createActions() {
        super.createActions();
        Action resetLayoutAction = new Action(DiagramCoreResources.ActivityDetailDiagramEditor_ResetDiagramLayout_text){

            public void run() {
                DiagramEditorUtil.refresh((DiagramEditPart)ADDiagramEditor.this.getDiagramEditPart(), (IProgressMonitor)new NullProgressMonitor());
                if (ADDiagramEditor.this.getGraphicalViewer().getContents() instanceof ActivityDetailDiagramEditPart) {
                    ActivityDetailDiagramEditPart dep = (ActivityDetailDiagramEditPart)ADDiagramEditor.this.getGraphicalViewer().getContents();
                    ArrayList<EditPart> local = new ArrayList<EditPart>();
                    if (dep.getChildren() != null && !dep.getChildren().isEmpty()) {
                        for (Object next : dep.getChildren()) {
                            if (next instanceof NoteEditPart) continue;
                            local.add((EditPart)next);
                        }
                    }
                    dep.getRecentlyAddedParts().addAll(local);
                    ADDiagramEditor.this.cleanUpDiagram();
                }
            }

            public boolean isEnabled() {
                return ADDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().size() == 0;
            }

            public String getId() {
                return "reset_diagram_layout";
            }
        };
        resetLayoutAction.setDisabledImageDescriptor(ADDImages.DISABLED_IMG_DESC_RESET_DIAGRAM_LAYOUT);
        resetLayoutAction.setImageDescriptor(ADDImages.IMG_DESC_RESET_DIAGRAM_LAYOUT);
        this.getActionRegistry().registerAction((IAction)resetLayoutAction);
    }

    public void resetLayout() {
        if (((ActivityDetailDiagram)this.getDiagram().getElement()).isAutoLayout()) {
            IAction action = this.getActionRegistry().getAction((Object)"reset_diagram_layout");
            action.run();
        } else {
            this.layoutRecentlyAdded();
        }
    }

    private void layoutRecentlyAdded() {
        Activity activity;
        this.getGraphicalViewer().getContents().refresh();
        this.getDiagramEditPart().getViewport().validate();
        this.cleanUpDiagram();
        EObject diagramElement = this.getDiagram().getElement();
        if (diagramElement instanceof Diagram && TngUtil.isLocked((EObject)(activity = (Activity)((Diagram)diagramElement).getLinkedElement()))) {
            this.getCommandStack().flush();
            this.firePropertyChange(257);
        }
    }

    protected String getPartNamePrefix() {
        return DiagramCoreResources.ActivityDetailDiagram_prefix;
    }

    protected Image getPartImage() {
        return ActivityDetailDiagramEditorPlugin.getInstance().getSharedImage("full/etool16/ADDEditor.gif");
    }

    public void runResetLayoutAction() {
        this.layoutRecentlyAdded();
        if (((ActivityDetailDiagram)this.getDiagram().getElement()).isAutoLayout()) {
            IAction action = this.getActionRegistry().getAction((Object)"reset_diagram_layout");
            action.run();
        }
    }

    protected boolean isOrphan(EObject modelElement) {
        return modelElement instanceof Node && BridgeHelper.getMethodElement((EObject)modelElement) == null;
    }
}

