/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.add.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.RoleNode;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(ActivityDetailDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("ADD".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return DiagramVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                ActivityDetailDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return DiagramVisualIDRegistry.getDiagramVisualID(domainElement, domainElementMetaclass);
    }

    private static int getDiagramVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (ModelPackage.eINSTANCE.getActivityDetailDiagram().isSuperTypeOf(domainElementMetaclass) && DiagramVisualIDRegistry.isDiagramActivityDetailDiagram_79((ActivityDetailDiagram)domainElement)) {
            return 79;
        }
        return DiagramVisualIDRegistry.getUnrecognizedDiagramID(domainElement);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return DiagramVisualIDRegistry.getNodeVisualID(containerView, domainElement, domainElementMetaclass, null);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement, EClass domainElementMetaclass, String semanticHint) {
        int containerVisualID;
        String containerModelID = DiagramVisualIDRegistry.getModelID(containerView);
        if (!"ADD".equals(containerModelID)) {
            return -1;
        }
        if ("ADD".equals(containerModelID)) {
            containerVisualID = DiagramVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return -1;
        }
        int nodeVisualID = semanticHint != null ? DiagramVisualIDRegistry.getVisualID(semanticHint) : -1;
        switch (containerVisualID) {
            case 1001: {
                if (5001 == nodeVisualID) {
                    return 5001;
                }
                if ((semanticHint == null || 2001 == nodeVisualID) && ModelPackage.eINSTANCE.getRoleNode().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isNodeRoleNode_2001((RoleNode)domainElement))) {
                    return 2001;
                }
                if ((semanticHint == null || 2002 == nodeVisualID) && ModelPackage.eINSTANCE.getTaskNode().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isNodeTaskNode_2002((TaskNode)domainElement))) {
                    return 2002;
                }
                return DiagramVisualIDRegistry.getUnrecognizedRoleTaskComposite_1001ChildNodeID(domainElement, semanticHint);
            }
            case 1002: {
                if (5002 == nodeVisualID) {
                    return 5002;
                }
                if ((semanticHint == null || 2003 == nodeVisualID) && ModelPackage.eINSTANCE.getWorkProductDescriptorNode().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isNodeWorkProductDescriptorNode_2003((WorkProductDescriptorNode)domainElement))) {
                    return 2003;
                }
                return DiagramVisualIDRegistry.getUnrecognizedWorkProductComposite_1002ChildNodeID(domainElement, semanticHint);
            }
            case 2001: {
                if (4001 == nodeVisualID) {
                    return 4001;
                }
                return DiagramVisualIDRegistry.getUnrecognizedRoleNode_2001ChildNodeID(domainElement, semanticHint);
            }
            case 2002: {
                if (4002 == nodeVisualID) {
                    return 4002;
                }
                return DiagramVisualIDRegistry.getUnrecognizedTaskNode_2002ChildNodeID(domainElement, semanticHint);
            }
            case 2003: {
                if (4003 == nodeVisualID) {
                    return 4003;
                }
                return DiagramVisualIDRegistry.getUnrecognizedWorkProductDescriptorNode_2003ChildNodeID(domainElement, semanticHint);
            }
            case 5001: {
                return DiagramVisualIDRegistry.getUnrecognizedRoleTaskCompositeRoleTaskCompartment_5001ChildNodeID(domainElement, semanticHint);
            }
            case 5002: {
                return DiagramVisualIDRegistry.getUnrecognizedWorkProductCompositeWorkProductCompartment_5002ChildNodeID(domainElement, semanticHint);
            }
            case 79: {
                if ((semanticHint == null || 1001 == nodeVisualID) && ModelPackage.eINSTANCE.getRoleTaskComposite().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isNodeRoleTaskComposite_1001((RoleTaskComposite)domainElement))) {
                    return 1001;
                }
                if ((semanticHint == null || 1002 == nodeVisualID) && ModelPackage.eINSTANCE.getWorkProductComposite().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isNodeWorkProductComposite_1002((WorkProductComposite)domainElement))) {
                    return 1002;
                }
                return DiagramVisualIDRegistry.getUnrecognizedActivityDetailDiagram_79ChildNodeID(domainElement, semanticHint);
            }
            case 3001: {
                if (4004 == nodeVisualID) {
                    return 4004;
                }
                return DiagramVisualIDRegistry.getUnrecognizedLink_3001LinkLabelID(semanticHint);
            }
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return DiagramVisualIDRegistry.getLinkWithClassVisualID(domainElement, domainElementMetaclass);
    }

    public static int getLinkWithClassVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (ModelPackage.eINSTANCE.getLink().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isLinkWithClassLink_3001((Link)domainElement))) {
            return 3001;
        }
        return DiagramVisualIDRegistry.getUnrecognizedLinkWithClassID(domainElement);
    }

    private static boolean isDiagramActivityDetailDiagram_79(ActivityDetailDiagram element) {
        return true;
    }

    private static int getUnrecognizedDiagramID(EObject domainElement) {
        return -1;
    }

    private static boolean isNodeRoleTaskComposite_1001(RoleTaskComposite element) {
        return true;
    }

    private static boolean isNodeWorkProductComposite_1002(WorkProductComposite element) {
        return true;
    }

    private static boolean isNodeRoleNode_2001(RoleNode element) {
        return true;
    }

    private static boolean isNodeTaskNode_2002(TaskNode element) {
        return true;
    }

    private static boolean isNodeWorkProductDescriptorNode_2003(WorkProductDescriptorNode element) {
        return true;
    }

    private static int getUnrecognizedRoleTaskComposite_1001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedWorkProductComposite_1002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedRoleNode_2001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedTaskNode_2002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedWorkProductDescriptorNode_2003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedRoleTaskCompositeRoleTaskCompartment_5001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedWorkProductCompositeWorkProductCompartment_5002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedActivityDetailDiagram_79ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLink_3001LinkLabelID(String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkWithClassID(EObject domainElement) {
        return -1;
    }

    private static boolean isLinkWithClassLink_3001(Link element) {
        return true;
    }
}

