/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ActionDelegate
extends Action
implements IObjectActionDelegate {
    protected IWorkbenchPart targetPart;
    protected List<EditPart> selectedParts = new ArrayList<EditPart>();
    protected Request targetRequest;

    public ActionDelegate() {
    }

    public ActionDelegate(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        this.execute(this.getCommand(), (IProgressMonitor)new NullProgressMonitor());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.dropMenuItems();
        this.selectedParts.clear();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() > 0 && structuredSelection.getFirstElement() instanceof EditPart) {
            this.selectedParts.addAll(structuredSelection.toList());
        }
    }

    protected DiagramCommandStack getDiagramCommandStack() {
        Object stack = this.targetPart.getAdapter(CommandStack.class);
        return stack instanceof DiagramCommandStack ? (DiagramCommandStack)stack : null;
    }

    protected final IWorkbenchPart getWorkbenchPart() {
        return this.targetPart;
    }

    protected DiagramContextMenuProvider getDiagramContextMenuProvider() {
        if (this.targetPart != null) {
            DiagramGraphicalViewer viewer = (DiagramGraphicalViewer)this.targetPart.getAdapter(GraphicalViewer.class);
            DiagramContextMenuProvider provider = (DiagramContextMenuProvider)viewer.getContextMenu();
            return provider;
        }
        return null;
    }

    protected final void execute(Command command, IProgressMonitor progressMonitor) {
        if (command == null || !command.canExecute()) {
            return;
        }
        if (this.getDiagramCommandStack() != null) {
            this.getDiagramCommandStack().execute(command, progressMonitor);
        }
    }

    protected abstract Command getCommand();

    protected void dropMenuItems() {
    }

    protected TransactionalEditingDomain getEditingDomain() {
        EditingDomain domain;
        IEditingDomainProvider edProvider;
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null && (edProvider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class)) != null && (domain = edProvider.getEditingDomain()) instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected abstract Request createTargetRequest();
}

