/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.actions.ActionDelegate;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.services.Services;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Activity;

public class DeleteDiagramAction
extends ActionDelegate {
    private EditPart mySelectedElement;

    public DeleteDiagramAction() {
    }

    public DeleteDiagramAction(IAction action, IWorkbenchPart targetPart) {
        super(action, targetPart);
    }

    public void run(IAction action) {
        Diagram diagram;
        if (DiagramCorePlugin.getDefault().getMsgDialog().displayPrompt(DiagramCoreResources.DeleteDiagram_text, DiagramCoreResources.DeleteDiagram_prompt) && this.mySelectedElement != null && (diagram = (Diagram)this.mySelectedElement.getModel()) != null) {
            try {
                IStatus status;
                Resource resource = diagram.eResource();
                if (resource != null && !(status = Services.getAccessController().checkModify(new Resource[]{resource}, (Object)this.targetPart.getSite().getShell())).isOK()) {
                    return;
                }
                DiagramHelper.deleteDiagram(diagram, true);
                this.targetPart.getSite().getPage().closeEditor(this.targetPart.getSite().getPage().getActiveEditor(), false);
            }
            catch (Exception ex) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.dropMenuItems();
        this.mySelectedElement = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof EditPart) {
            this.mySelectedElement = (EditPart)structuredSelection.getFirstElement();
        }
        if (this.mySelectedElement != null) {
            Diagram diagram;
            action.setChecked(false);
            if (this.mySelectedElement instanceof DiagramEditPart && !((DiagramEditPart)this.mySelectedElement).isEditModeEnabled()) {
                action.setEnabled(false);
                IContributionItem item = this.getDiagramContextMenuProvider().find("editMenu");
                if (item != null) {
                    item.setVisible(false);
                }
            }
            if ((diagram = (Diagram)this.mySelectedElement.getModel()) != null) {
                EObject model = diagram.getElement();
                if (model instanceof Activity) {
                    NodeAdapter adapter = BridgeHelper.getNodeAdapter(model);
                    if (adapter != null && adapter.isTargetReadOnly()) {
                        action.setEnabled(false);
                        IContributionItem item = this.getDiagramContextMenuProvider().find("editMenu");
                        if (item != null) {
                            item.setVisible(false);
                        }
                    }
                } else {
                    boolean cfr_ignored_0 = model instanceof org.eclipse.epf.diagram.model.Diagram;
                }
            }
        } else {
            action.setEnabled(false);
        }
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected Command getCommand() {
        return null;
    }
}

