/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.actions.ActionDelegate;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.commands.DeleteDiagramCommand;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.util.DiagramCoreValidation;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.ActivityNode;

public class DeleteElementActionDelegate
extends ActionDelegate {
    private Request secondaryTargetRequest;

    public DeleteElementActionDelegate() {
    }

    public DeleteElementActionDelegate(IAction action, IWorkbenchPart targetPart) {
        super(action, targetPart);
    }

    protected org.eclipse.gef.commands.Command getCommand() {
        this.targetRequest = null;
        Request request = this.getTargetRequest();
        Iterator editParts = this.selectedParts.iterator();
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Process targetProcess = this.getOwningProcess();
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(this.getEditingDomain(), DiagramCoreResources.deleteCommand_label){

            public boolean canUndo() {
                for (EditPart editPart : DeleteElementActionDelegate.this.selectedParts) {
                    MethodElement e;
                    if (!(editPart instanceof IGraphicalEditPart)) continue;
                    IGraphicalEditPart gEditPart = (IGraphicalEditPart)editPart;
                    View view = (View)gEditPart.getModel();
                    EObject element = ViewUtil.resolveSemanticElement((View)view);
                    if (view instanceof Diagram || element instanceof Diagram || (e = BridgeHelper.getMethodElement(view)) == null || !(e instanceof Activity)) continue;
                    return false;
                }
                return true;
            }
        };
        while (editParts.hasNext()) {
            EditPart editPart = (EditPart)editParts.next();
            if (!(editPart instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart gEditPart = (IGraphicalEditPart)editPart;
            View view = (View)gEditPart.getModel();
            EObject element = ViewUtil.resolveSemanticElement((View)view);
            if (view instanceof Diagram || element instanceof Diagram) {
                return null;
            }
            MethodElement e = BridgeHelper.getMethodElement(view);
            if (e != null && e instanceof Activity) {
                activities.add((Activity)e);
            }
            org.eclipse.gef.commands.Command curCommand = null;
            curCommand = editPart instanceof IGraphicalEditPart && this.isCanonical((IGraphicalEditPart)editPart) ? editPart.getCommand(request) : editPart.getCommand(this.getSecondaryTargetRequest());
            if (curCommand == null && this.isDiagramUIObject(view)) {
                curCommand = editPart.getCommand(this.getSecondaryTargetRequest());
            }
            if (curCommand == null) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty() || command.size() != this.selectedParts.size()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!activities.isEmpty()) {
            new DeleteDiagramCommand(activities, targetProcess).execute();
        }
        return new ICommandProxy((ICommand)command);
    }

    private boolean isDiagramUIObject(View view) {
        return view.getElement() == null;
    }

    protected Request createTargetRequest() {
        return new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(this.getEditingDomain(), false));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setEnabled(true);
        super.selectionChanged(action, selection);
        for (EditPart element : this.selectedParts) {
            View view = (View)element.getModel();
            if (view.getElement() == null) continue;
            if (view instanceof Diagram || BridgeHelper.isReadOnly(view) || TngUtil.isLocked((EObject)this.getOwningProcess()) || view.getElement() instanceof LinkedObject && view.getDiagram().getElement() instanceof ActivityDetailDiagram || (BridgeHelper.getMethodElement(view) != null || view.getElement() instanceof ActivityNode && BridgeHelper.isSynchBar((ActivityNode)view.getElement())) && BridgeHelper.isInherited((EModelElement)view)) {
                action.setEnabled(false);
                this.setEnabled(false);
                break;
            }
            if (!(view instanceof Edge) || DiagramCoreValidation.checkDelete((Edge)view) == null) continue;
            action.setEnabled(false);
            this.setEnabled(false);
            break;
        }
    }

    public void run(IAction action) {
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<BreakdownElement> elements = new ArrayList<BreakdownElement>();
        for (Object editPart : this.selectedParts) {
            MethodElement element;
            Object obj;
            if (!(editPart instanceof EditPart) || !((obj = ((EditPart)editPart).getModel()) instanceof Node) || (element = BridgeHelper.getMethodElement((View)((Node)obj))) == null || !(element instanceof BreakdownElement)) continue;
            elements.add((BreakdownElement)element);
        }
        if (!elements.isEmpty()) {
            ProcessDeleteAction deleteAction = new ProcessDeleteAction(){

                public Command createCommand(Collection selection) {
                    this.domain = null;
                    for (Object element : selection) {
                        if (!(element instanceof WorkProductDescriptor)) continue;
                        this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
                        break;
                    }
                    if (this.domain == null) {
                        this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
                    }
                    return super.createCommand(selection);
                }
            };
            deleteAction.updateSelection((IStructuredSelection)new StructuredSelection(elements));
            deleteAction.run();
            if (deleteAction.isDeletionConfirmed()) {
                super.run(action);
                BusyIndicator.showWhile((Display)this.targetPart.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ((AbstractDiagramEditor)DeleteElementActionDelegate.this.targetPart).doSave((IProgressMonitor)new NullProgressMonitor());
                        if (DeleteElementActionDelegate.this.getDiagramCommandStack() != null) {
                            DeleteElementActionDelegate.this.getDiagramCommandStack().flush();
                        }
                    }
                });
            }
        } else {
            super.run(action);
        }
    }

    private boolean isCanonical(IGraphicalEditPart gep) {
        CanonicalEditPolicy cep;
        EditPart parent = gep.getParent();
        return parent instanceof IGraphicalEditPart && (cep = (CanonicalEditPolicy)parent.getEditPolicy((Object)"Canonical")) != null && cep.isEnabled();
    }

    public Request getSecondaryTargetRequest() {
        if (this.secondaryTargetRequest == null) {
            this.secondaryTargetRequest = new GroupRequest((Object)"delete");
        }
        return this.secondaryTargetRequest;
    }

    private Process getOwningProcess() {
        Diagram d;
        DiagramAdapter adapter;
        if (this.targetPart != null && (adapter = BridgeHelper.getDiagramAdapter((d = ((AbstractDiagramEditor)this.targetPart).getDiagram()).getElement())) != null) {
            return TngUtil.getOwningProcess((BreakdownElement)adapter.getActivity());
        }
        return null;
    }
}

