/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.model.DiagramResources;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.persistence.UnnormalizedURIException;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.JoinNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgeHelper {
    public static final String UMA_ELEMENT = "uma_element";
    public static final String UMA_URI = "uri";
    public static final String UMA_TYPE = "type";
    public static final String UMA_PHASE = "Phase";
    public static final String UMA_ITERATION = "Iteration";
    public static final String UMA_ACTIVITY = "Activity";
    public static final String UMA_TASK_DESCRIPTOR = "Task";
    public static final String UMA_MILESTONE = "Milestone";
    public static final String ANNOTATION_INHERIRED = "inherited";
    public static List<IElementType> elementTypes = new ArrayList<IElementType>();
    public static Map<String, EClass> typeStringToEClass = new HashMap<String, EClass>();
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();

    static {
        typeStringToEClass.put(UMA_PHASE, UmaPackage.Literals.PHASE);
        typeStringToEClass.put(UMA_ITERATION, UmaPackage.Literals.ITERATION);
        typeStringToEClass.put(UMA_ACTIVITY, UmaPackage.Literals.ACTIVITY);
        typeStringToEClass.put(UMA_TASK_DESCRIPTOR, UmaPackage.Literals.TASK_DESCRIPTOR);
        typeStringToEClass.put(UMA_MILESTONE, UmaPackage.Literals.MILESTONE);
    }

    public static void setSemanticModel(ActivityEdge link, WorkOrder workOrder) {
    }

    public static boolean isReadOnly(View view) {
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(view.getElement());
        if (nodeAdapter != null) {
            return nodeAdapter.isTargetReadOnly();
        }
        if (view.getElement() instanceof Node) {
            return ((Node)view.getElement()).isReadOnly();
        }
        return false;
    }

    public static MethodElement getMethodElement(View view) {
        return BridgeHelper.getMethodElement(view.getElement());
    }

    public static MethodElement getMethodElement(EObject modelObject) {
        if (modelObject instanceof LinkedObject) {
            return ((LinkedObject)modelObject).getLinkedElement();
        }
        if (modelObject instanceof EModelElement) {
            return BridgeHelper.getMethodElement((EModelElement)modelObject);
        }
        return null;
    }

    public static MethodElement getMethodElement(View view, org.eclipse.epf.uma.Activity owner) {
        Resource resource;
        EObject modelObject = view.getElement();
        if (modelObject instanceof LinkedObject) {
            return ((LinkedObject)modelObject).getLinkedElement();
        }
        if (modelObject instanceof EModelElement && (resource = owner.eResource()) != null && resource.getResourceSet() != null) {
            return BridgeHelper.getMethodElementFromAnnotation((EModelElement)modelObject, resource.getResourceSet());
        }
        return null;
    }

    public static boolean isSuppressed(View view) {
        NodeAdapter nodeAdapter;
        EObject element = view.getElement();
        if (element instanceof NamedNode) {
            return ((NamedNode)element).isSuppressed();
        }
        if (element instanceof EModelElement && (nodeAdapter = BridgeHelper.getNodeAdapter(element)) != null) {
            BreakdownElementWrapperItemProvider o = nodeAdapter.getWrapper();
            if (o == null) {
                o = nodeAdapter.getElement();
            }
            org.eclipse.epf.uma.Activity activity = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((View)view.getDiagram());
            Process proc = TngUtil.getOwningProcess((BreakdownElement)activity);
            Suppression suppression = Suppression.getSuppression((Process)proc);
            return suppression.isSuppressed((Object)o);
        }
        return false;
    }

    public static void removeLink(ActivityEdge link) {
        Activity activity = link.getActivity();
        ActivityNode sourceNode = link.getSource();
        ActivityNode targetNode = link.getTarget();
        boolean srcNotify = sourceNode != null ? sourceNode.eDeliver() : false;
        boolean targetNotify = targetNode != null ? targetNode.eDeliver() : false;
        try {
            if (sourceNode != null) {
                sourceNode.eSetDeliver(false);
            }
            if (targetNode != null) {
                targetNode.eSetDeliver(false);
            }
            link.setSource(null);
            link.setTarget(null);
            if (activity != null) {
                activity.getEdges().remove((Object)link);
            }
        }
        finally {
            if (sourceNode != null) {
                sourceNode.eSetDeliver(srcNotify);
            }
            if (targetNode != null) {
                targetNode.eSetDeliver(targetNotify);
            }
        }
    }

    public static ActivityNode findNode(Activity container, Object object, boolean checkBase) {
        if (container != null) {
            for (ActivityNode node : container.getNodes()) {
                MethodElement e = BridgeHelper.getMethodElement((EModelElement)node);
                if (object == e) {
                    return node;
                }
                if (!checkBase || !(e instanceof VariabilityElement)) continue;
                VariabilityElement ve = ((VariabilityElement)e).getVariabilityBasedOnElement();
                while (ve != null) {
                    if (ve == object) {
                        return node;
                    }
                    ve = ve.getVariabilityBasedOnElement();
                }
            }
        }
        return null;
    }

    public static boolean isSynchBar(ActivityNode node) {
        return node instanceof ForkNode || node instanceof JoinNode;
    }

    public static ActivityNode findNode(Activity container, Object object) {
        for (ActivityNode node : container.getNodes()) {
            MethodElement element = BridgeHelper.getMethodElement((EModelElement)node);
            if (object == element) {
                return node;
            }
            if (!(object instanceof TaskDescriptor)) continue;
            DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
            TaskDescriptor greenParent = (TaskDescriptor)propUtil.getGreenParentDescriptor((Descriptor)((TaskDescriptor)object));
            while (greenParent != null) {
                if (greenParent == element) {
                    return node;
                }
                greenParent = (TaskDescriptor)propUtil.getGreenParentDescriptor((Descriptor)greenParent);
            }
        }
        return null;
    }

    public static URI getProxyURI(MethodElement e) {
        Resource resource = e.eResource();
        if (resource instanceof ILibraryResource) {
            return ((ILibraryResource)resource).getProxyURI((EObject)e);
        }
        if (resource != null) {
            return resource.getURI().appendFragment(e.getGuid());
        }
        return null;
    }

    public static boolean associate(EModelElement element, MethodElement me) {
        EAnnotation annotation = BridgeHelper.addEAnnotation(element, me);
        if (annotation != null) {
            String type = BridgeHelper.getType(me);
            if (type != null) {
                annotation.getDetails().put((Object)UMA_TYPE, (Object)type);
            }
            return true;
        }
        return false;
    }

    public static EClass getType(String type) {
        return typeStringToEClass.get(type);
    }

    public static String getType(MethodElement me) {
        if (me instanceof Phase) {
            return UMA_PHASE;
        }
        if (me instanceof Iteration) {
            return UMA_ITERATION;
        }
        if (me instanceof Milestone) {
            return UMA_MILESTONE;
        }
        if (me instanceof org.eclipse.epf.uma.Activity) {
            return UMA_ACTIVITY;
        }
        if (me instanceof TaskDescriptor) {
            return UMA_TASK_DESCRIPTOR;
        }
        return null;
    }

    public static EAnnotation addEAnnotation(EModelElement element, MethodElement me) {
        URI uri = BridgeHelper.getProxyURI(me);
        if (uri != null) {
            EAnnotation eAnnotation = element.getEAnnotation(UMA_ELEMENT);
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(UMA_ELEMENT);
                element.getEAnnotations().add((Object)eAnnotation);
            }
            eAnnotation.getDetails().put((Object)UMA_URI, (Object)uri.toString());
            return eAnnotation;
        }
        return null;
    }

    private static Activity getActivity(EModelElement e) {
        EModelElement o = e;
        while (o != null && !(o instanceof Activity)) {
            o = o.eContainer();
        }
        return (Activity)o;
    }

    public static MethodElement getMethodElementFromAnnotation(EModelElement node, ResourceSet resourceSet) {
        EAnnotation eAnnotation = node.getEAnnotation(UMA_ELEMENT);
        try {
            String uri;
            if (eAnnotation != null && (uri = (String)eAnnotation.getDetails().get((Object)UMA_URI)) != null) {
                EObject o = resourceSet.getEObject(URI.createURI((String)uri), false);
                if (o instanceof MethodElement) {
                    return (MethodElement)o;
                }
                if (DEBUG) {
                    System.err.println("Not a method element: " + o);
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof UnnormalizedURIException)) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            }
            return null;
        }
        return null;
    }

    public static MethodElement getMethodElementFromAnnotation(EModelElement node) {
        Activity diagram = BridgeHelper.getActivity(node);
        if (diagram == null) {
            return null;
        }
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)diagram);
        if (nodeAdapter == null || nodeAdapter.getElement() == null) {
            return null;
        }
        Resource resource = nodeAdapter.getElement().eResource();
        if (resource != null && resource.getResourceSet() != null) {
            return BridgeHelper.getMethodElementFromAnnotation(node, resource.getResourceSet());
        }
        return null;
    }

    public static MethodElement getMethodElement(EModelElement node) {
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
        return nodeAdapter != null ? nodeAdapter.getElement() : BridgeHelper.getMethodElementFromAnnotation(node);
    }

    public static NodeAdapter getNodeAdapter(EObject node) {
        if (node != null) {
            for (Object adapter : node.eAdapters()) {
                if (!(adapter instanceof NodeAdapter)) continue;
                return (NodeAdapter)((Object)adapter);
            }
        }
        return null;
    }

    public static DiagramAdapter getDiagramAdapter(EObject node) {
        for (Object adapter : node.eAdapters()) {
            if (!(adapter instanceof DiagramAdapter)) continue;
            return (DiagramAdapter)((Object)adapter);
        }
        return null;
    }

    public static void getSyncBarSourceNodes(ActivityNode node, Collection actNodes) {
        for (ActivityEdge link : node.getIncomings()) {
            ActivityNode source = link.getSource();
            if (BridgeHelper.getMethodElement((EModelElement)source) instanceof WorkBreakdownElement) {
                actNodes.add(source);
                continue;
            }
            if (!BridgeHelper.isSynchBar(source)) continue;
            BridgeHelper.getSyncBarSourceNodes(source, actNodes);
        }
    }

    public static void getTargetNodes(Collection actNodes, ActivityNode node, Class type) {
        if (node != null) {
            for (ActivityEdge link : node.getOutgoings()) {
                ActivityNode target = link.getTarget();
                if (type.isInstance(BridgeHelper.getMethodElement((EModelElement)target))) {
                    actNodes.add(target);
                    continue;
                }
                if (!(target instanceof ControlNode)) continue;
                BridgeHelper.getTargetNodes(actNodes, target, type);
            }
        }
    }

    public static void getSuccessorNodes(Collection<ActivityNode> actNodes, ActivityNode node) {
        if (node != null) {
            for (ActivityEdge link : node.getOutgoings()) {
                ActivityNode target = link.getTarget();
                if (BridgeHelper.getMethodElement((EModelElement)target) instanceof WorkBreakdownElement) {
                    actNodes.add(target);
                    continue;
                }
                if (!BridgeHelper.isSynchBar(target)) continue;
                BridgeHelper.getSuccessorNodes(actNodes, target);
            }
        }
    }

    public static void getPredecessorNodes(Collection<ActivityNode> actNodes, ActivityNode node) {
        if (node != null) {
            for (ActivityEdge link : node.getIncomings()) {
                ActivityNode source = link.getSource();
                if (BridgeHelper.getMethodElement((EModelElement)source) instanceof WorkBreakdownElement) {
                    actNodes.add(source);
                    continue;
                }
                if (!BridgeHelper.isSynchBar(source)) continue;
                BridgeHelper.getPredecessorNodes(actNodes, source);
            }
        }
    }

    public static void getSourceNodes(Collection actNodes, ActivityNode node, Class type) {
        if (node != null) {
            for (ActivityEdge link : node.getIncomings()) {
                ActivityNode source = link.getSource();
                if (type.isInstance(BridgeHelper.getMethodElement((EModelElement)source))) {
                    actNodes.add(source);
                    continue;
                }
                if (!(source instanceof ControlNode)) continue;
                BridgeHelper.getSourceNodes(actNodes, source, type);
            }
        }
    }

    public static void getSyncBarTargetNodes(ActivityNode typedNode, Collection actNodes) {
        for (ActivityEdge link : typedNode.getOutgoings()) {
            ActivityNode target = link.getTarget();
            if (BridgeHelper.getMethodElement((EModelElement)target) instanceof WorkBreakdownElement) {
                actNodes.add(target);
                continue;
            }
            if (!BridgeHelper.isSynchBar(target)) continue;
            BridgeHelper.getSyncBarTargetNodes(target, actNodes);
        }
    }

    public static boolean canRemoveAllPreds(ActivityEdge link, ActivityNode oldSource, ActivityNode oldTarget) {
        MethodElement targetElement = BridgeHelper.getMethodElement((EModelElement)oldTarget);
        if (targetElement instanceof WorkBreakdownElement) {
            EList inlist = oldTarget.getIncomings();
            for (ActivityEdge incominglink : inlist) {
                if (BridgeHelper.isSynchBar(incominglink.getSource())) {
                    ArrayList col = new ArrayList();
                    BridgeHelper.getSourceNodes(col, incominglink.getSource(), WorkBreakdownElement.class);
                    if (!col.contains(oldSource)) continue;
                    return false;
                }
                if (incominglink.getSource() == null || !(BridgeHelper.getMethodElement((EModelElement)incominglink.getSource()) instanceof WorkBreakdownElement) || !incominglink.getSource().equals(oldSource)) continue;
                return false;
            }
        }
        return true;
    }

    public static void markInherited(EModelElement element) {
        if (BridgeHelper.isInherited(element)) {
            return;
        }
        EAnnotation eAnnotation = element.getEAnnotation(ANNOTATION_INHERIRED);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(ANNOTATION_INHERIRED);
            element.getEAnnotations().add((Object)eAnnotation);
        }
    }

    public static void unmarkInHerited(EModelElement element) {
        EAnnotation eAnnotation = element.getEAnnotation(ANNOTATION_INHERIRED);
        if (eAnnotation != null) {
            element.getEAnnotations().remove((Object)eAnnotation);
        }
    }

    public static Diagram copyDiagram(Diagram baseDiagram) {
        Diagram copy = (Diagram)EcoreUtil.copy((EObject)baseDiagram);
        EList children = copy.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            View view = (View)children.get(i);
            BridgeHelper.markInherited((EModelElement)view);
            ++i;
        }
        return copy;
    }

    public static EList addEAnnotationDetail(EModelElement element, String detailName, String detailValue) {
        EAnnotation eAnnotation = element.getEAnnotation(UMA_ELEMENT);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(UMA_ELEMENT);
            eAnnotation.getDetails().put((Object)UMA_TYPE, (Object)detailValue);
            element.getEAnnotations().add((Object)eAnnotation);
        } else {
            eAnnotation.getDetails().put((Object)UMA_TYPE, (Object)detailValue);
        }
        return element.getEAnnotations();
    }

    public static EList addEAnnotationType(EModelElement element, String type) {
        EClass rightType;
        ActivityNode node;
        MethodElement e;
        EList result = BridgeHelper.addEAnnotationDetail(element, UMA_TYPE, type);
        if (element instanceof ActivityNode && (e = BridgeHelper.getMethodElement((EModelElement)(node = (ActivityNode)element))) instanceof BreakdownElement && type != null && !type.equals(BridgeHelper.getType(e)) && (rightType = BridgeHelper.getType(type)) != null) {
            BreakdownElement rightElement = (BreakdownElement)UmaFactory.eINSTANCE.create(rightType);
            org.eclipse.epf.uma.Activity activity = ((BreakdownElement)e).getSuperActivities();
            if (activity != null) {
                List list = activity.getBreakdownElements();
                list.set(list.indexOf(e), rightElement);
                ProcessPackage pkg = (ProcessPackage)activity.eContainer();
                if (pkg != null) {
                    pkg.getProcessElements().add(rightElement);
                    List childPkgs = pkg.getChildPackages();
                    if (!childPkgs.isEmpty()) {
                        for (ProcessPackage child : pkg.getChildPackages()) {
                            List pList = child.getProcessElements();
                            if (pList.isEmpty() || !pList.contains(e)) continue;
                            pList.set(pList.indexOf(e), rightElement);
                        }
                    }
                }
                BridgeHelper.associate((EModelElement)node, (MethodElement)rightElement);
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                if (nodeAdapter != null) {
                    nodeAdapter.dispose();
                }
                DiagramAdapter diagramAdapter = (DiagramAdapter)BridgeHelper.getNodeAdapter((EObject)node.getActivity());
                diagramAdapter.addNodeAdapterTo(node);
            }
        }
        return result;
    }

    public static String getEAnnotationType(EModelElement element, String detailName) {
        return BridgeHelper.getEAnnotationDetail(element, detailName);
    }

    public static String getEAnnotationDetail(EModelElement element, String detailName) {
        EAnnotation eAnnotation = element.getEAnnotation(UMA_ELEMENT);
        if (eAnnotation != null) {
            return (String)eAnnotation.getDetails().get((Object)detailName);
        }
        return null;
    }

    public static String getType(ActivityNode node) {
        return BridgeHelper.getEAnnotationDetail((EModelElement)node, UMA_TYPE);
    }

    public static String getType(BreakdownElement e) {
        if (e instanceof Iteration) {
            return UMA_ITERATION;
        }
        if (e instanceof Phase) {
            return UMA_PHASE;
        }
        if (e instanceof org.eclipse.epf.uma.Activity) {
            return UMA_ACTIVITY;
        }
        if (e instanceof Milestone) {
            return UMA_MILESTONE;
        }
        if (e instanceof TaskDescriptor) {
            return UMA_TASK_DESCRIPTOR;
        }
        return null;
    }

    public static boolean isInherited(EModelElement e) {
        String source;
        EAnnotation eAnnotation = e.getEAnnotation(ANNOTATION_INHERIRED);
        return eAnnotation != null && (source = eAnnotation.getSource()) != null && source.length() > 0;
    }

    private static EClass getEClassFromType(String annotationType) {
        if (UMA_ACTIVITY.equals(annotationType)) {
            return UmaPackage.eINSTANCE.getActivity();
        }
        if (UMA_ITERATION.equals(annotationType)) {
            return UmaPackage.eINSTANCE.getIteration();
        }
        if (UMA_MILESTONE.equals(annotationType)) {
            return UmaPackage.eINSTANCE.getMilestone();
        }
        if (UMA_PHASE.equals(annotationType)) {
            return UmaPackage.eINSTANCE.getPhase();
        }
        if (UMA_TASK_DESCRIPTOR.equals(annotationType)) {
            return UmaPackage.eINSTANCE.getTaskDescriptor();
        }
        return null;
    }

    public static void setDefaultName(ActivityNode node) {
        Activity parentAct = node.getActivity();
        MethodElement element = BridgeHelper.getMethodElement((EModelElement)parentAct);
        MethodElement obj = BridgeHelper.getMethodElement((EModelElement)node);
        int classID = obj.eClass().getClassifierID();
        org.eclipse.epf.uma.Activity act = (org.eclipse.epf.uma.Activity)element;
        ArrayList<BreakdownElement> siblings = new ArrayList<BreakdownElement>();
        for (BreakdownElement e : act.getBreakdownElements()) {
            if (e.eClass().getClassifierID() != classID) continue;
            siblings.add(e);
        }
        String baseName = MessageFormat.format(DiagramResources.defaultBaseName, TngUtil.getTypeText((String)obj.eClass().getName()));
        TngUtil.setDefaultName(siblings, (MethodElement)obj, (String)baseName);
        node.setName(obj.getName());
    }

    public static View getView(View diagram, Object node) {
        for (View child : diagram.getChildren()) {
            if (child.getElement() == node) {
                return child;
            }
            if (!(child.getElement() instanceof ActivityPartition)) continue;
            for (View element : child.getChildren()) {
                if (element.getElement() != node) continue;
                return child;
            }
        }
        return null;
    }

    public static String getNodeName(MethodElement e) {
        if (e instanceof BreakdownElement) {
            return ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)e));
        }
        if (e instanceof DescribableElement) {
            return ((DescribableElement)e).getPresentationName();
        }
        return e.getName();
    }
}

