/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.diagram.core.bridge.ActivityDiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlNode;

public class WorkBreakdownElementNodeAdapter
extends NodeAdapter {
    public WorkBreakdownElementNodeAdapter(MethodElement e) {
        super(e);
    }

    private boolean isValid(WorkOrder wo) {
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)wo, (String)"predecessor_is_sibling");
        if (prop != null) {
            return true;
        }
        ActivityNode node = this.getNode();
        Activity diagram = this.getDiagram();
        ActivityDiagramAdapter diagramAdapter = (ActivityDiagramAdapter)BridgeHelper.getDiagramAdapter((EObject)diagram);
        List<WorkBreakdownElement> localPredecessors = diagramAdapter.getLocalPredecessors(node);
        return localPredecessors.contains(wo.getPred());
    }

    public void handleSuppressed(boolean b) {
        if (b) {
            EList incomings = this.getNode().getIncomings();
            int i = 0;
            while (i < incomings.size()) {
                Object obj = incomings.get(i);
                ActivityEdge link = null;
                if (obj != null) {
                    link = (ActivityEdge)obj;
                }
                if (link != null && link.getSource() != null) {
                    NodeAdapter sourceNodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getSource());
                    boolean oldNotify1 = sourceNodeAdapter != null ? sourceNodeAdapter.notificationEnabled : false;
                    try {
                        if (sourceNodeAdapter != null) {
                            sourceNodeAdapter.notificationEnabled = false;
                        }
                        link.setTarget(null);
                        this.getNode().getIncomings().remove((Object)link);
                    }
                    finally {
                        if (sourceNodeAdapter != null) {
                            sourceNodeAdapter.notificationEnabled = oldNotify1;
                        }
                    }
                }
                ++i;
            }
            EList outGoings = this.getNode().getOutgoings();
            int i2 = 0;
            while (i2 < outGoings.size()) {
                Object obj = outGoings.get(i2);
                ActivityEdge link = null;
                if (obj != null) {
                    link = (ActivityEdge)obj;
                }
                if (link != null && link.getTarget() != null) {
                    NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getTarget());
                    boolean oldNotify1 = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
                    try {
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = false;
                        }
                        link.setSource(null);
                        this.getNode().getIncomings().remove((Object)link);
                    }
                    finally {
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = oldNotify1;
                        }
                    }
                }
                ++i2;
            }
        } else {
            EList nodes = this.getDiagram().getNodes();
            for (ActivityNode element : nodes) {
                MethodElement me;
                if (element == this.getNode() || !(this.target instanceof MethodElement) || (me = BridgeHelper.getMethodElement((EModelElement)element)) == null) continue;
                this.addIncomingConnection(me);
                this.addOutgoingConnection(me);
            }
        }
    }

    protected NodeAdapter.MethodElementAdapter createMethodElementAdapter() {
        return new WorkBreakdownElementAdapter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeFromUMA(ActivityEdge link, ActivityNode oldSource, ActivityNode oldTarget) {
        org.eclipse.epf.uma.Activity diagramActivity = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((EModelElement)this.getDiagram());
        ProcessPackage pkg = (ProcessPackage)diagramActivity.eContainer();
        MethodElement targetElement = BridgeHelper.getMethodElement((EModelElement)oldTarget);
        if (targetElement instanceof WorkBreakdownElement) {
            WorkBreakdownElement succ = (WorkBreakdownElement)targetElement;
            if (diagramActivity != succ.getSuperActivities()) {
                WorkBreakdownElement pred;
                WorkOrder order;
                MethodElement sourceElement = BridgeHelper.getMethodElement((EModelElement)oldSource);
                if (!(sourceElement instanceof WorkBreakdownElement) || (order = ProcessUtil.findWorkOrder((org.eclipse.epf.uma.Activity)diagramActivity, (WorkBreakdownElement)succ, (WorkBreakdownElement)(pred = (WorkBreakdownElement)sourceElement))) == null) return;
                this.getActionManager().doAction(4, (EObject)pkg, (EStructuralFeature)UmaPackage.Literals.PROCESS_PACKAGE__PROCESS_ELEMENTS, (Object)order, -1);
                return;
            } else {
                NodeAdapter targetNodeAdapter = BridgeHelper.getNodeAdapter((EObject)oldTarget);
                boolean notify = targetNodeAdapter != null ? targetNodeAdapter.notificationEnabled : false;
                try {
                    WorkBreakdownElement e;
                    Collection workOrders;
                    MethodElement pred;
                    if (targetNodeAdapter != null) {
                        targetNodeAdapter.notificationEnabled = false;
                    }
                    if (!BridgeHelper.canRemoveAllPreds(link, oldSource, oldTarget) || !((pred = BridgeHelper.getMethodElement((EModelElement)oldSource)) instanceof WorkBreakdownElement) || (workOrders = UmaUtil.findWorkOrder((WorkBreakdownElement)(e = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)oldTarget)), (WorkBreakdownElement)((WorkBreakdownElement)pred), (boolean)true)).isEmpty()) return;
                    this.getActionManager().doAction(6, (EObject)e, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)workOrders, -1);
                    return;
                }
                finally {
                    if (targetNodeAdapter != null) {
                        targetNodeAdapter.notificationEnabled = notify;
                    }
                }
            }
        } else {
            if (!(oldTarget instanceof ControlNode) || !BridgeHelper.isSynchBar(oldTarget)) return;
            ArrayList<ActivityNode> actNodes = new ArrayList<ActivityNode>();
            BridgeHelper.getSuccessorNodes(actNodes, oldTarget);
            MethodElement pred = BridgeHelper.getMethodElement((EModelElement)oldSource);
            for (ActivityNode node : actNodes) {
                WorkOrder wo;
                WorkBreakdownElement e = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)node);
                if (diagramActivity == e.getSuperActivities()) {
                    NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                    boolean notify = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
                    try {
                        WorkOrder wo2;
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = false;
                        }
                        if (!BridgeHelper.canRemoveAllPreds(link, oldSource, node)) continue;
                        while ((wo2 = UmaUtil.findWorkOrder((WorkBreakdownElement)e, (Object)pred)) != null) {
                            this.getActionManager().doAction(4, (EObject)e, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)wo2, -1);
                        }
                        continue;
                    }
                    finally {
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = notify;
                        }
                    }
                }
                if (!(pred instanceof WorkBreakdownElement) || (wo = ProcessUtil.findWorkOrder((org.eclipse.epf.uma.Activity)diagramActivity, (WorkBreakdownElement)e, (WorkBreakdownElement)((WorkBreakdownElement)pred))) == null) continue;
                this.getActionManager().doAction(4, (EObject)pkg, (EStructuralFeature)UmaPackage.Literals.PROCESS_PACKAGE__PROCESS_ELEMENTS, (Object)wo, -1);
            }
        }
    }

    protected boolean addToUMA(ActivityEdge link) {
        if (!super.addToUMA(link)) {
            return false;
        }
        MethodElement e = BridgeHelper.getMethodElement((EModelElement)link.getSource());
        org.eclipse.epf.uma.Activity diagramActivity = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((EModelElement)this.getDiagram());
        ProcessPackage cfr_ignored_0 = (ProcessPackage)diagramActivity.eContainer();
        if (e instanceof WorkBreakdownElement) {
            WorkBreakdownElement succ = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)link.getTarget());
            WorkBreakdownElement pred = (WorkBreakdownElement)e;
            this.addWorkOrder(link.getTarget(), succ, link.getSource(), pred, diagramActivity, link);
        } else if (BridgeHelper.isSynchBar(link.getSource())) {
            ArrayList actNodes = new ArrayList();
            BridgeHelper.getSyncBarSourceNodes(link.getSource(), actNodes);
            WorkBreakdownElement succ = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)link.getTarget());
            for (ActivityNode node : actNodes) {
                WorkBreakdownElement pred = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)node);
                this.addWorkOrder(link.getTarget(), succ, node, pred, diagramActivity, null);
            }
        }
        return true;
    }

    protected ActivityEdge addIncomingConnection(MethodElement source) {
        ActivityEdge link = super.addIncomingConnection(source);
        if (link == null) {
            return link;
        }
        WorkOrder workOrder = UmaUtil.findWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)this.getElement()), (Object)source);
        BridgeHelper.setSemanticModel(link, workOrder);
        return link;
    }

    protected ActivityEdge addOutgoingConnection(MethodElement target) {
        ActivityEdge link = super.addOutgoingConnection(target);
        WorkOrder workOrder = UmaUtil.findWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)target), (Object)this.getElement());
        BridgeHelper.setSemanticModel(link, workOrder);
        return link;
    }

    protected boolean removeIncomingConnection(MethodElement source) {
        for (ActivityEdge link : this.getNode().getIncomings()) {
            if (link.getSource() == null || BridgeHelper.getMethodElement((EModelElement)link.getSource()) != source) continue;
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getSource());
            boolean oldNotify = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
            try {
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = false;
                }
                link.setSource(null);
            }
            finally {
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = oldNotify;
                }
            }
            link.setTarget(null);
            BridgeHelper.setSemanticModel(link, null);
            this.getDiagram().getEdges().remove((Object)link);
            return true;
        }
        return false;
    }

    private class WorkBreakdownElementAdapter
    extends NodeAdapter.MethodElementAdapter {
        private WorkBreakdownElementAdapter() {
        }

        protected Collection handleNotification(Notification msg) {
            block0 : switch (msg.getFeatureID(WorkBreakdownElement.class)) {
                case 34: {
                    switch (msg.getEventType()) {
                        case 3: {
                            WorkOrder obj = (WorkOrder)msg.getNewValue();
                            if (!WorkBreakdownElementNodeAdapter.this.isValid(obj)) break block0;
                            WorkBreakdownElementNodeAdapter.this.addIncomingConnection((MethodElement)obj.getPred());
                            break;
                        }
                        case 4: {
                            WorkOrder obj = (WorkOrder)msg.getOldValue();
                            WorkBreakdownElementNodeAdapter.this.removeIncomingConnection((MethodElement)obj.getPred());
                            break;
                        }
                        case 5: {
                            Collection collection = (Collection)msg.getNewValue();
                            for (WorkOrder obj : collection) {
                                if (!WorkBreakdownElementNodeAdapter.this.isValid(obj)) continue;
                                WorkBreakdownElementNodeAdapter.this.addIncomingConnection((MethodElement)obj.getPred());
                            }
                            break block0;
                        }
                        case 6: {
                            Collection collection = (Collection)msg.getOldValue();
                            for (WorkOrder obj : collection) {
                                WorkBreakdownElementNodeAdapter.this.removeIncomingConnection((MethodElement)obj.getPred());
                            }
                        }
                    }
                    break;
                }
                case 7: {
                    switch (msg.getEventType()) {
                        default: 
                    }
                    break;
                }
                default: {
                    return super.handleNotification(msg);
                }
            }
            return Collections.EMPTY_LIST;
        }
    }
}

