/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.StructuredActivityNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyDiagramCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Collection<?> elements;
    private Map<EObject, EObject> copyToOriginalMap;
    private Collection<Diagram> copiedElements;
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();
    private Process targetProcess;
    private DiagramManager mgr;
    private InternalTransactionalEditingDomain domain;
    private Map<EObject, EObject> originalToCopyMap;

    private CopyDiagramCommand(Collection<?> elements, Process targetProcess) {
        this.elements = elements;
        this.targetProcess = targetProcess;
        this.mgr = DiagramManager.getInstance(targetProcess, (Object)this);
        this.domain = this.mgr.getEditingDomain();
    }

    public CopyDiagramCommand(Collection<?> elements, CopyCommand.Helper copyHelper, Process targetProcess) {
        this(elements, targetProcess);
        this.originalToCopyMap = copyHelper;
    }

    public CopyDiagramCommand(Collection<?> elements, Map<EObject, EObject> copyToOriginalMap, Process targetProcess) {
        this(elements, targetProcess);
        this.copyToOriginalMap = copyToOriginalMap;
    }

    public void execute() {
        try {
            TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                public void run() {
                    CopyDiagramCommand.this.doExecute();
                }
            });
        }
        catch (ExecutionException e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void redo() {
        this.execute();
    }

    protected Map<?, ?> getCopyToOriginalMap() {
        if (this.copyToOriginalMap == null && this.originalToCopyMap != null) {
            this.copyToOriginalMap = new HashMap<EObject, EObject>();
            for (Map.Entry<EObject, EObject> entry : this.originalToCopyMap.entrySet()) {
                this.copyToOriginalMap.put(entry.getValue(), entry.getKey());
            }
        }
        return this.copyToOriginalMap;
    }

    private void doExecute() {
        if (this.copiedElements == null) {
            this.copiedElements = new ArrayList<Diagram>();
        } else {
            this.copiedElements.clear();
        }
        DiagramService diagramSvc = new DiagramService();
        try {
            try {
                for (Object e : this.elements) {
                    Object orig = this.getCopyToOriginalMap().get(e);
                    if (orig == null || !(orig instanceof Activity) || e == null || !(e instanceof Activity)) continue;
                    Activity copyActivity = (Activity)e;
                    Activity origActivity = (Activity)orig;
                    Collection<Diagram> diagrams = diagramSvc.getDiagrams(origActivity);
                    if (diagrams == null || diagrams.isEmpty()) continue;
                    for (Diagram diagram : diagrams) {
                        if (diagram == null) continue;
                        Diagram diagramCopy = DiagramHelper.copyDiagram((EditingDomain)this.domain, diagram);
                        this.updateReferences(diagramCopy);
                        int diagramType = DiagramHelper.getDiagramType(diagramCopy);
                        this.mgr.associate(diagramCopy, diagramType, copyActivity);
                        this.copiedElements.add(diagramCopy);
                    }
                }
            }
            catch (Exception ex) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
                if (DEBUG) {
                    ex.printStackTrace();
                }
                diagramSvc.dispose();
            }
        }
        finally {
            diagramSvc.dispose();
        }
    }

    public void updateReferences(Diagram copy) {
        EObject obj;
        int diagramType = DiagramHelper.getDiagramType(copy);
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node node : copy.getChildren()) {
            obj = node.getElement();
            children.add(node);
            if (!(obj instanceof ActivityPartition)) continue;
            children.addAll((Collection<Node>)node.getChildren());
        }
        for (Node node : children) {
            NamedNode namedNode;
            MethodElement me;
            Object mappedMethodElement;
            obj = node.getElement();
            if (diagramType == 0) {
                EModelElement modelElement;
                if (!(obj instanceof StructuredActivityNode) && !(obj instanceof ActivityParameterNode) || (mappedMethodElement = this.getCopiedElement(me = BridgeHelper.getMethodElementFromAnnotation(modelElement = (EModelElement)obj, this.targetProcess.eResource().getResourceSet()))) == null) continue;
                BridgeHelper.addEAnnotation(modelElement, (MethodElement)mappedMethodElement);
                continue;
            }
            if (diagramType == 2) {
                if (!(obj instanceof NodeContainer)) continue;
                NodeContainer nodeContainer = (NodeContainer)obj;
                me = nodeContainer.getLinkedElement();
                mappedMethodElement = this.getCopiedElement(me);
                if (mappedMethodElement != null) {
                    nodeContainer.setLinkedElement((MethodElement)mappedMethodElement);
                }
                EList nodes = nodeContainer.getNodes();
                int i = 0;
                while (i < nodes.size()) {
                    NamedNode namedNode2 = (NamedNode)nodes.get(i);
                    me = namedNode2.getLinkedElement();
                    mappedMethodElement = this.getCopiedElement(me);
                    if (mappedMethodElement != null) {
                        namedNode2.setLinkedElement((MethodElement)mappedMethodElement);
                    }
                    ++i;
                }
                continue;
            }
            if (diagramType != 1 || !(obj instanceof NamedNode) || (mappedMethodElement = this.getCopiedElement(me = (namedNode = (NamedNode)obj).getLinkedElement())) == null) continue;
            namedNode.setLinkedElement((MethodElement)mappedMethodElement);
        }
    }

    private Object getCopiedElement(Object element) {
        if (this.originalToCopyMap == null && this.copyToOriginalMap != null) {
            this.originalToCopyMap = new HashMap<EObject, EObject>();
            for (Map.Entry<EObject, EObject> entry : this.copyToOriginalMap.entrySet()) {
                this.originalToCopyMap.put(entry.getValue(), entry.getKey());
            }
        }
        return this.originalToCopyMap != null ? this.originalToCopyMap.get(element) : null;
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        block3: {
            if (this.copiedElements != null && !this.copiedElements.isEmpty()) {
                try {
                    TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                for (Diagram diagram : CopyDiagramCommand.this.copiedElements) {
                                    CopyDiagramCommand.this.mgr.getResource().getContents().remove((Object)diagram.getElement());
                                    CopyDiagramCommand.this.mgr.getResource().getContents().remove((Object)diagram);
                                }
                            }
                            catch (CoreException e) {
                                throw new WrappedException((Exception)((Object)e));
                            }
                        }
                    });
                    this.copiedElements.clear();
                }
                catch (Exception ex) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
                    if (!DEBUG) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }

    public Collection<Resource> getModifiedResources() {
        if (this.copiedElements == null || this.copiedElements.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        for (Diagram diagram : this.copiedElements) {
            if (diagram == null || diagram.eResource() == null) continue;
            modifiedResources.add(diagram.eResource());
        }
        return modifiedResources;
    }

    public void dispose() {
        if (this.mgr != null) {
            this.mgr.removeConsumer((Object)this);
        }
        super.dispose();
    }
}

