/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.util.ConfigurationSetter;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.StructuredActivityNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyDiagramForDeepCopyCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Collection<?> elements;
    private Map<?, ?> copyToOriginalMap;
    private Collection<Diagram> copiedElements;
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();
    private Process targetProcess;
    private DiagramManager mgr;
    private InternalTransactionalEditingDomain domain;
    private CopyHelper copyHelper;
    private MethodConfiguration config;
    private Process srcProcess;
    private HashMap<BreakdownElement, String> copyToWrapperPathMap;

    public CopyDiagramForDeepCopyCommand(Collection<?> elements, Map<?, ?> copyToOriginalMap, Process srcProcess, Process targetProcess, CopyHelper copyHelper, MethodConfiguration config) {
        this.copyHelper = copyHelper;
        this.config = config;
        this.srcProcess = srcProcess;
        this.elements = elements;
        this.copyToOriginalMap = copyToOriginalMap;
        this.targetProcess = targetProcess;
        this.mgr = DiagramManager.getInstance(targetProcess, (Object)this);
        this.domain = this.mgr.getEditingDomain();
    }

    public void execute() {
        try {
            TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                public void run() {
                    CopyDiagramForDeepCopyCommand.this.doExecute();
                }
            });
        }
        catch (ExecutionException e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void redo() {
        this.execute();
    }

    private void doExecute() {
        if (this.copiedElements == null) {
            this.copiedElements = new ArrayList<Diagram>();
        } else {
            this.copiedElements.clear();
        }
        this.copyToWrapperPathMap = new HashMap();
        if (this.copyHelper != null) {
            for (Map.Entry entry : this.copyHelper.getWrapperPathToCopyMap().entrySet()) {
                this.copyToWrapperPathMap.put((BreakdownElement)entry.getValue(), (String)entry.getKey());
            }
        }
        DiagramService diagramSvc = new DiagramService();
        try {
            try {
                for (Object e : this.elements) {
                    Object orig = this.copyToOriginalMap.get(e);
                    if (orig == null || !(orig instanceof org.eclipse.epf.uma.Activity) || e == null || !(e instanceof org.eclipse.epf.uma.Activity)) continue;
                    org.eclipse.epf.uma.Activity copyActivity = (org.eclipse.epf.uma.Activity)e;
                    org.eclipse.epf.uma.Activity origActivity = (org.eclipse.epf.uma.Activity)orig;
                    Collection<Diagram> diagrams = diagramSvc.getDiagrams(origActivity);
                    if (diagrams == null || diagrams.isEmpty()) continue;
                    for (Diagram diagram : diagrams) {
                        if (diagram == null) continue;
                        Diagram diagramCopy = DiagramHelper.copyDiagram((EditingDomain)this.domain, diagram);
                        this.updateReferences(diagramCopy, copyActivity, origActivity);
                        for (Object edge : diagramCopy.getEdges()) {
                            BridgeHelper.unmarkInHerited((EModelElement)((Edge)edge));
                        }
                        int diagramType = DiagramHelper.getDiagramType(diagramCopy);
                        this.mgr.associate(diagramCopy, diagramType, copyActivity);
                        this.copiedElements.add(diagramCopy);
                    }
                }
            }
            catch (Exception ex) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
                if (DEBUG) {
                    ex.printStackTrace();
                }
                diagramSvc.dispose();
            }
        }
        finally {
            diagramSvc.dispose();
        }
    }

    private void clearReadOnly(org.eclipse.epf.diagram.model.Node node) {
        node.setReadOnly(false);
        if (node instanceof NodeContainer) {
            for (org.eclipse.epf.diagram.model.Node child : ((NodeContainer)node).getNodes()) {
                child.setReadOnly(false);
            }
        }
    }

    private BreakdownElementWrapperItemProvider getOriginalWrapper(org.eclipse.epf.uma.Activity copy) {
        String wrapperPath = this.copyToWrapperPathMap.get(copy);
        if (wrapperPath == null) {
            return null;
        }
        if (this.srcProcess != null) {
            Suppression suppression = Suppression.getSuppression((Process)this.srcProcess);
            ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            ConfigurationSetter configSetter = new ConfigurationSetter((AdapterFactory)adapterFactory);
            try {
                configSetter.set(this.config);
                StringTokenizer tokens = new StringTokenizer(wrapperPath, "/");
                ArrayList<String> guidList = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    guidList.add(tokens.nextToken());
                }
                String[] guidPath = new String[guidList.size()];
                guidList.toArray(guidPath);
                Object o = suppression.getObjectByPath(guidPath, (AdapterFactory)adapterFactory);
                if (o instanceof BreakdownElementWrapperItemProvider) {
                    BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)o;
                    return breakdownElementWrapperItemProvider;
                }
                System.out.println("CopyDiagramCommand.getOriginalWrapper(): invalid wrapper for copy activity: " + o);
            }
            finally {
                configSetter.restore();
            }
        }
        return null;
    }

    private Collection<BreakdownElement> getBreakdownElements(org.eclipse.epf.uma.Activity origActivity, org.eclipse.epf.uma.Activity copyActivity) {
        BreakdownElementWrapperItemProvider wrapper = this.getOriginalWrapper(copyActivity);
        BreakdownElementWrapperItemProvider object = wrapper != null ? wrapper : origActivity;
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ConfigurationSetter configSetter = new ConfigurationSetter((AdapterFactory)adapterFactory);
        try {
            configSetter.set(this.config);
            ITreeItemContentProvider ip = (ITreeItemContentProvider)adapterFactory.adapt((Object)object, ITreeItemContentProvider.class);
            Collection origChildren = ip.getChildren((Object)origActivity);
            ArrayList<BreakdownElement> elements = new ArrayList<BreakdownElement>();
            for (Object origChild : origChildren) {
                Object e = TngUtil.unwrap(origChild);
                if (!(e instanceof BreakdownElement)) continue;
                elements.add((BreakdownElement)e);
            }
            ArrayList<BreakdownElement> arrayList = elements;
            return arrayList;
        }
        finally {
            configSetter.restore();
        }
    }

    private static BreakdownElement getBreakdownElement(Collection<BreakdownElement> elements, org.eclipse.epf.uma.Activity base) {
        for (BreakdownElement e : elements) {
            if (!(e instanceof VariabilityElement)) continue;
            boolean found = false;
            VariabilityElement ve = (VariabilityElement)e;
            while (ve.getVariabilityBasedOnElement() != null) {
                if (ve.getVariabilityBasedOnElement() == base) {
                    found = true;
                    break;
                }
                ve = ve.getVariabilityBasedOnElement();
            }
            if (!found) continue;
            return e;
        }
        return null;
    }

    public void updateReferences(Diagram copy, org.eclipse.epf.uma.Activity copyActivity, org.eclipse.epf.uma.Activity origActivity) {
        EAnnotation annotation;
        Activity umlActivity;
        EObject diagramModel;
        BreakdownElement mappedMethodElement;
        Node modelElement;
        MethodElement me;
        int diagramType = DiagramHelper.getDiagramType(copy);
        CopyFinder copyFinder = new CopyFinder(origActivity, copyActivity);
        EList copyChildren = copy.getChildren();
        if (!copyChildren.isEmpty()) {
            EObject obj;
            ArrayList<Node> children = new ArrayList<Node>();
            for (Node node : copyChildren) {
                obj = node.getElement();
                children.add(node);
                if (!(obj instanceof ActivityPartition)) continue;
                children.addAll((Collection<Node>)node.getChildren());
            }
            for (Node node : children) {
                NamedNode namedNode;
                BridgeHelper.unmarkInHerited((EModelElement)node);
                obj = node.getElement();
                if (diagramType == 0) {
                    if (!(obj instanceof StructuredActivityNode) && !(obj instanceof ActivityParameterNode) || !((me = BridgeHelper.getMethodElementFromAnnotation((EModelElement)(modelElement = (EModelElement)obj), this.targetProcess.eResource().getResourceSet())) instanceof BreakdownElement) || (mappedMethodElement = copyFinder.findCopy((BreakdownElement)me)) == null) continue;
                    BridgeHelper.addEAnnotation((EModelElement)modelElement, (MethodElement)mappedMethodElement);
                    continue;
                }
                if (diagramType == 2) {
                    if (obj instanceof org.eclipse.epf.diagram.model.Node) {
                        this.clearReadOnly((org.eclipse.epf.diagram.model.Node)obj);
                    }
                    if (!(obj instanceof NodeContainer)) continue;
                    NodeContainer nodeContainer = (NodeContainer)obj;
                    me = nodeContainer.getLinkedElement();
                    mappedMethodElement = null;
                    if (me instanceof BreakdownElement && (mappedMethodElement = copyFinder.findCopy((BreakdownElement)me)) != null) {
                        nodeContainer.setLinkedElement((MethodElement)mappedMethodElement);
                    }
                    EList nodes = nodeContainer.getNodes();
                    int i = 0;
                    while (i < nodes.size()) {
                        NamedNode namedNode2 = (NamedNode)nodes.get(i);
                        me = namedNode2.getLinkedElement();
                        if (me instanceof BreakdownElement && (mappedMethodElement = copyFinder.findCopy((BreakdownElement)me)) != null) {
                            namedNode2.setLinkedElement((MethodElement)mappedMethodElement);
                        }
                        ++i;
                    }
                    continue;
                }
                if (diagramType != 1) continue;
                if (obj instanceof org.eclipse.epf.diagram.model.Node) {
                    this.clearReadOnly((org.eclipse.epf.diagram.model.Node)obj);
                }
                if (!(obj instanceof NamedNode) || !((me = (namedNode = (NamedNode)obj).getLinkedElement()) instanceof BreakdownElement) || (mappedMethodElement = copyFinder.findCopy((BreakdownElement)me)) == null) continue;
                namedNode.setLinkedElement((MethodElement)mappedMethodElement);
            }
        } else {
            switch (diagramType) {
                case 0: {
                    diagramModel = copy.getElement();
                    if (!(diagramModel instanceof Activity)) break;
                    umlActivity = (Activity)diagramModel;
                    for (Node node : umlActivity.getNodes()) {
                        if (!(node instanceof StructuredActivityNode) && !(node instanceof ActivityParameterNode) || !((me = BridgeHelper.getMethodElementFromAnnotation((EModelElement)(modelElement = node), this.targetProcess.eResource().getResourceSet())) instanceof BreakdownElement) || (mappedMethodElement = copyFinder.findCopy((BreakdownElement)me)) == null) continue;
                        BridgeHelper.addEAnnotation((EModelElement)modelElement, (MethodElement)mappedMethodElement);
                    }
                    for (ActivityEdge edge : umlActivity.getEdges()) {
                        annotation = edge.getEAnnotation("uma_element");
                        if (annotation == null) continue;
                        EcoreUtil.remove((EObject)annotation);
                    }
                    break;
                }
            }
        }
        switch (diagramType) {
            case 0: {
                diagramModel = copy.getElement();
                if (!(diagramModel instanceof Activity)) break;
                umlActivity = (Activity)diagramModel;
                for (ActivityEdge edge : umlActivity.getEdges()) {
                    annotation = edge.getEAnnotation("uma_element");
                    if (annotation == null) continue;
                    EcoreUtil.remove((EObject)annotation);
                }
                break;
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        block3: {
            if (this.copiedElements != null && !this.copiedElements.isEmpty()) {
                try {
                    TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                for (Diagram diagram : CopyDiagramForDeepCopyCommand.this.copiedElements) {
                                    CopyDiagramForDeepCopyCommand.this.mgr.getResource().getContents().remove((Object)diagram.getElement());
                                    CopyDiagramForDeepCopyCommand.this.mgr.getResource().getContents().remove((Object)diagram);
                                }
                            }
                            catch (CoreException e) {
                                throw new WrappedException((Exception)((Object)e));
                            }
                        }
                    });
                    this.copiedElements.clear();
                }
                catch (Exception ex) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
                    if (!DEBUG) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }

    public Collection getModifiedResources() {
        if (this.copiedElements == null || this.copiedElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        for (Diagram diagram : this.copiedElements) {
            if (diagram == null || diagram.eResource() == null) continue;
            modifiedResources.add(diagram.eResource());
        }
        return modifiedResources;
    }

    public void dispose() {
        if (this.mgr != null) {
            this.mgr.removeConsumer((Object)this);
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyFinder {
        private org.eclipse.epf.uma.Activity origActivity;
        private org.eclipse.epf.uma.Activity copyActivity;
        private Map<BreakdownElement, BreakdownElement> originalToCopyMap;
        private Collection<BreakdownElement> elements;

        private CopyFinder(org.eclipse.epf.uma.Activity origActivity, org.eclipse.epf.uma.Activity copyActivity) {
            this.origActivity = origActivity;
            this.copyActivity = copyActivity;
        }

        public Map<BreakdownElement, BreakdownElement> getOriginalToCopyMap() {
            if (this.originalToCopyMap == null) {
                this.originalToCopyMap = new HashMap<BreakdownElement, BreakdownElement>();
                for (BreakdownElement e : this.copyActivity.getBreakdownElements()) {
                    BreakdownElement orig = (BreakdownElement)CopyDiagramForDeepCopyCommand.this.copyHelper.getOriginal((Object)e);
                    this.originalToCopyMap.put(orig, e);
                }
            }
            return this.originalToCopyMap;
        }

        BreakdownElement findCopy(BreakdownElement original) {
            BreakdownElement copy = this.getOriginalToCopyMap().get(original);
            if (copy == null && original instanceof org.eclipse.epf.uma.Activity) {
                if (this.elements == null) {
                    this.elements = CopyDiagramForDeepCopyCommand.this.getBreakdownElements(this.origActivity, this.copyActivity);
                }
                copy = CopyDiagramForDeepCopyCommand.getBreakdownElement(this.elements, (org.eclipse.epf.uma.Activity)original);
            }
            return copy;
        }
    }
}

