/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.commands.CopyDiagramCommand;
import org.eclipse.epf.diagram.core.commands.CopyDiagramForDeepCopyCommand;
import org.eclipse.epf.diagram.core.commands.DeleteDiagramCommand;
import org.eclipse.epf.diagram.core.commands.DeleteDiagramNodeCommand;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.command.ResourceAwareCompoundCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.process.command.ProcessDeepCopyCommand;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedCommandProvider
implements INestedCommandProvider {
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();

    public Command createNestedCommand(Command command) {
        if (command instanceof ActivityDropCommand) {
            ActivityDropCommand cmd = (ActivityDropCommand)command;
            if (1 == cmd.getType()) {
                return this.createNestedCommandForCopy(cmd);
            }
            if (3 == cmd.getType()) {
                return this.createNestedCommandForDeepCopy(cmd);
            }
        } else if (command instanceof ProcessDeepCopyCommand) {
            ProcessDeepCopyCommand cmd = (ProcessDeepCopyCommand)command;
            Process deepCopy = null;
            Collection result = cmd.getResult();
            if (!result.isEmpty()) {
                deepCopy = (Process)result.iterator().next();
            }
            if (deepCopy != null) {
                ArrayList<Activity> deepCopies = new ArrayList<Activity>();
                deepCopies.add((Activity)deepCopy);
                return this.createNestedCommandForDeepCopy(deepCopies, cmd.getTargetProcess(), cmd.getCopyHelper(), cmd.getMethodConfiguration(), true);
            }
        }
        return null;
    }

    private Command createNestedCommandForCopy(ActivityDropCommand command) {
        Collection modifiedResources = command.getModifiedResources();
        if (modifiedResources != null && !modifiedResources.isEmpty()) {
            ResourceAwareCompoundCommand cmd;
            block5: {
                cmd = new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
                CopyCommand.Helper copiedHelper = command.getActivityHandler().getCopyHelper();
                Activity targetActivity = command.getActivity();
                Process targetProc = TngUtil.getOwningProcess((BreakdownElement)targetActivity);
                if (targetProc != null) {
                    try {
                        cmd.append((Command)new CopyDiagramCommand(copiedHelper.values(), copiedHelper, targetProc));
                    }
                    catch (Exception ex) {
                        CommonPlugin.getDefault().getLogger().logError((Throwable)ex);
                        if (!DEBUG) break block5;
                        ex.printStackTrace();
                    }
                }
            }
            if (!cmd.isEmpty()) {
                return cmd;
            }
        }
        return null;
    }

    private Command createNestedCommandForDeepCopy(ActivityDropCommand command) {
        ActivityHandler activityHandler = command.getActivityHandler();
        if (activityHandler != null && !activityHandler.getDeepCopies().isEmpty()) {
            return this.createNestedCommandForDeepCopy(activityHandler.getDeepCopies(), activityHandler.getTargetProcess(), activityHandler.getDeepCopyHelper(), activityHandler.getDeepCopyConfig(), false);
        }
        return null;
    }

    private Command createNestedCommandForDeepCopy(Collection<Activity> deepCopies, final Process targetProc, CopyHelper copyHelper, MethodConfiguration config, boolean saveDiagram) {
        ResourceAwareCompoundCommand cmd = saveDiagram ? new ResourceAwareCompoundCommand(Integer.MAX_VALUE){

            public void execute() {
                super.execute();
                if (DiagramManager.hasDiagramManager(targetProc)) {
                    DiagramManager mgr = DiagramManager.getInstance(targetProc, (Object)this);
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getPersisterFor((Resource)targetProc.eResource()).getFailSafePersister();
                    try {
                        try {
                            Resource resource = mgr.getResource();
                            persister.save(resource);
                            persister.commit();
                        }
                        catch (Exception e) {
                            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                            try {
                                persister.rollback();
                            }
                            catch (Exception ex) {
                                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
                            }
                            mgr.removeConsumer((Object)this);
                        }
                    }
                    finally {
                        mgr.removeConsumer((Object)this);
                    }
                }
            }
        } : new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
        for (Activity copyAct : deepCopies) {
            Activity origAct = (Activity)copyHelper.getOriginal((Object)copyAct);
            Process srcProc = TngUtil.getOwningProcess((BreakdownElement)origAct);
            HashMap<Activity, Activity> copyToOriginalMap = new HashMap<Activity, Activity>();
            AbstractTreeIterator<BreakdownElement> copyTree = new AbstractTreeIterator<BreakdownElement>((BreakdownElement)copyAct){

                protected Iterator<? extends BreakdownElement> getChildren(Object object) {
                    if (object instanceof Activity) {
                        return ((Activity)object).getBreakdownElements().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (copyTree.hasNext()) {
                BreakdownElement e = (BreakdownElement)copyTree.next();
                if (!(e instanceof Activity)) continue;
                Object orig = copyHelper.getOriginal((Object)e);
                if (orig == null) {
                    System.out.println("NestedCommandProvider.createNestedCommandForDeepCopy(): FATAL ERROR: could not find source activity of deep copy: " + e);
                    continue;
                }
                copyToOriginalMap.put((Activity)e, (Activity)orig);
            }
            cmd.append((Command)new CopyDiagramForDeepCopyCommand(copyToOriginalMap.keySet(), copyToOriginalMap, srcProc, targetProc, copyHelper, config));
        }
        return !cmd.isEmpty() ? cmd : null;
    }

    public Command createRelatedObjects(Collection createdElements, Command createCommand) {
        MethodElementAddCommand meCommand;
        Command addCommand;
        ResourceAwareCompoundCommand cmd = new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
        if (createCommand instanceof MethodElementAddCommand && (addCommand = (meCommand = (MethodElementAddCommand)createCommand).getCommand()) instanceof AddCommand) {
            EditingDomain ed = ((AddCommand)addCommand).getDomain();
            if (((AddCommand)addCommand).getOwner() instanceof ProcessPackage || ((AddCommand)addCommand).getOwner() instanceof MethodLibrary) {
                Map copyToOriginalMap;
                if (ed instanceof TraceableAdapterFactoryEditingDomain && !(copyToOriginalMap = ((TraceableAdapterFactoryEditingDomain)ed).getCopyToOriginalMap()).isEmpty()) {
                    Collection affects = meCommand.getAffectedObjects();
                    for (MethodElement element : affects) {
                        if (element instanceof MethodPlugin) {
                            for (Process proc : TngUtil.getAllProcesses((MethodPlugin)((MethodPlugin)element))) {
                                cmd.append((Command)new CopyDiagramCommand(copyToOriginalMap.keySet(), copyToOriginalMap, proc));
                            }
                        }
                        if (!(element instanceof ProcessComponent)) continue;
                        cmd.append((Command)new CopyDiagramCommand(copyToOriginalMap.keySet(), copyToOriginalMap, ((ProcessComponent)element).getProcess()));
                    }
                }
            } else if (ed instanceof TraceableAdapterFactoryEditingDomain) {
                Map originalToCopyMap = ((TraceableAdapterFactoryEditingDomain)ed).getOriginalToClipboardMap();
                HashMap<EObject, EObject> copyToOriginalMap = new HashMap<EObject, EObject>();
                EObject owner = ((AddCommand)addCommand).getOwner();
                Process targetProc = TngUtil.getOwningProcess((Object)owner);
                if (targetProc != null) {
                    for (Object key : originalToCopyMap.keySet()) {
                        Object val = originalToCopyMap.get(key);
                        copyToOriginalMap.put((EObject)val, (EObject)key);
                    }
                    cmd.append((Command)new CopyDiagramCommand(copyToOriginalMap.keySet(), copyToOriginalMap, targetProc));
                }
            }
        }
        if (!cmd.isEmpty()) {
            return cmd;
        }
        return null;
    }

    public Command removeRelatedObjects(Collection deletedElements, Command deleteCommand) {
        ResourceAwareCompoundCommand cmd = new ResourceAwareCompoundCommand(Integer.MAX_VALUE);
        if (deleteCommand instanceof DeleteMethodElementCommand) {
            EObject owner;
            Command removeCommand = ((DeleteMethodElementCommand)deleteCommand).getCommand();
            List<RemoveCommand> removeCommands = null;
            if (removeCommand instanceof RemoveCommand) {
                removeCommands = Collections.singletonList((RemoveCommand)removeCommand);
            } else if (removeCommand instanceof CompoundCommand) {
                removeCommands = new ArrayList<RemoveCommand>();
                for (Command command : ((CompoundCommand)removeCommand).getCommandList()) {
                    if (!(command instanceof RemoveCommand)) continue;
                    removeCommands.add((RemoveCommand)command);
                }
            }
            if (removeCommands != null && !removeCommands.isEmpty() && (owner = removeCommands.get(0).getOwner()) instanceof Activity) {
                Process process = TngUtil.getOwningProcess((BreakdownElement)((Activity)owner));
                HashSet<Activity> allElements = new HashSet<Activity>();
                for (Object element : deletedElements) {
                    if (!(element instanceof Activity)) continue;
                    AbstractTreeIterator<Object> iterator = new AbstractTreeIterator<Object>(element){
                        private static final long serialVersionUID = 1L;

                        protected Iterator<? extends Object> getChildren(Object object) {
                            if (object instanceof Activity) {
                                return ((Activity)object).getBreakdownElements().iterator();
                            }
                            return Collections.emptyList().iterator();
                        }
                    };
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof Activity)) continue;
                        allElements.add((Activity)e);
                    }
                }
                if (!allElements.isEmpty()) {
                    cmd.append((Command)new DeleteDiagramCommand(allElements, process));
                }
                for (RemoveCommand command : removeCommands) {
                    DeleteDiagramNodeCommand deleteDiagramNodeCommand;
                    if (!(command.getOwner() instanceof Activity) || !(deleteDiagramNodeCommand = new DeleteDiagramNodeCommand((Activity)command.getOwner(), command.getCollection())).canExecute()) continue;
                    cmd.append((Command)deleteDiagramNodeCommand);
                }
            }
        }
        if (!deletedElements.isEmpty()) {
            for (Object element : deletedElements) {
                this.closeDiagramEditors(element);
            }
        }
        if (!cmd.isEmpty()) {
            return cmd;
        }
        return null;
    }

    private void closeDiagramEditors(Object e) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage workbenchPage = activeWorkbenchWindow.getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorReference> editorsToClose = new ArrayList<IEditorReference>();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference editorRef = editorReferences[i];
            try {
                IEditorInput editorInput = editorRef.getEditorInput();
                if (editorInput instanceof DiagramEditorInputProxy) {
                    DiagramEditorInput input = ((DiagramEditorInputProxy)editorInput).getDiagramEditorInput();
                    BreakdownElementWrapperItemProvider wrapper = input.getWrapper();
                    Process owningProcess = null;
                    if (wrapper != null) {
                        if (wrapper instanceof BreakdownElementWrapperItemProvider) {
                            owningProcess = TngUtil.getOwningProcess((BreakdownElementWrapperItemProvider)wrapper);
                        }
                    } else {
                        wrapper = input.getMethodElement();
                        if (wrapper instanceof BreakdownElement) {
                            owningProcess = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)wrapper));
                        }
                    }
                    if (owningProcess != null) {
                        if (e == owningProcess) {
                            editorsToClose.add(editorRef);
                        }
                        if (owningProcess.eContainer() == null || UmaUtil.isContainedBy((EObject)owningProcess, (Object)e)) {
                            editorsToClose.add(editorRef);
                        }
                    }
                }
            }
            catch (PartInitException ex) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)ex);
            }
            ++i;
        }
        if (!editorsToClose.isEmpty()) {
            IEditorReference[] refs = new IEditorReference[editorsToClose.size()];
            editorsToClose.toArray(refs);
            workbenchPage.closeEditors(refs, false);
        }
    }
}

