/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.part;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.common.AbstractActivator;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.actions.AccessibilityMoveAction;
import org.eclipse.epf.diagram.core.actions.CreateElementAction;
import org.eclipse.epf.diagram.core.actions.DelegateAction;
import org.eclipse.epf.diagram.core.actions.DiagramActionsService;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.DiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.IDiagramEditorInputProvider;
import org.eclipse.epf.diagram.core.part.IDiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.providers.DiagramContextMenuProvider;
import org.eclipse.epf.diagram.core.providers.SharedResourceDiagramDocumentProvider;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.core.util.DiagramConstants;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.ui.IMethodElementProvider;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.ui.editors.IMethodEditor;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.SelectAllAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.editor.FileDiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiagramEditor
extends FileDiagramEditor
implements IGotoMarker,
IMethodEditor {
    private DiagramManager diagramMgr;
    private DiagramActionsService actionService = null;
    private long fModificationStamp;
    private org.eclipse.epf.uma.Activity activity;
    private AdapterImpl titleAdapter;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IDocumentProvider docProvider;
            if (event.getSource() == AbstractDiagramEditor.this.diagramMgr && (docProvider = AbstractDiagramEditor.this.getDocumentProvider()) instanceof SharedResourceDiagramDocumentProvider && !AbstractDiagramEditor.this.isDirty()) {
                ((SharedResourceDiagramDocumentProvider)docProvider).handleElementContentChanged(AbstractDiagramEditor.this.getEditorInput());
            }
        }
    };
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int option, Collection collection) {
            switch (option) {
                case 8: {
                    if (collection == null || !collection.contains(AbstractDiagramEditor.this.currentConfig)) break;
                    MethodConfiguration config = ProcessAuthoringConfigurator.INSTANCE.getMethodConfiguration();
                    try {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(AbstractDiagramEditor.this.currentConfig);
                        AbstractDiagramEditor.this.refresh();
                    }
                    finally {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(config);
                    }
                }
            }
        }
    };
    private ILibraryServiceListener libSvcListener = new LibraryServiceListener(){

        public void configurationSet(MethodConfiguration config) {
            AbstractDiagramEditor.this.configChanged();
        }
    };
    private MethodConfiguration currentConfig;
    private boolean needRefresh;
    private DiagramService diagramSvc;

    public AbstractDiagramEditor() {
        super(true);
    }

    public AbstractDiagramEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    protected String getEditingDomainID() {
        return "org.eclipse.epf.diagram.EditingDomain";
    }

    protected DiagramManager getDiagramManager() {
        if (this.diagramMgr == null) {
            Process proc = TngUtil.getOwningProcess((BreakdownElement)this.activity);
            this.diagramMgr = DiagramManager.getInstance(proc, (Object)this);
            this.diagramMgr.addResourceChangeListener(this.resourceChangeListener);
        }
        return this.diagramMgr;
    }

    protected DiagramService getDiagramService() {
        if (this.diagramSvc == null) {
            this.diagramSvc = new DiagramService();
        }
        return this.diagramSvc;
    }

    protected TransactionalEditingDomain createEditingDomain() {
        InternalTransactionalEditingDomain domain = this.getDiagramManager().getEditingDomain();
        domain.setID(this.getEditingDomainID());
        return domain;
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.setDocumentProvider((IDocumentProvider)new SharedResourceDiagramDocumentProvider(this.getDiagramManager()){

            protected void doSynchronize(Object element, IProgressMonitor monitor) throws CoreException {
                DiagramManager mgr = AbstractDiagramEditor.this.getDiagramManager();
                try {
                    try {
                        mgr.removeResourceChangeListener(AbstractDiagramEditor.this.resourceChangeListener);
                        mgr.reload();
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, DiagramCorePlugin.getPluginId(), 0, "Error reloading diagram", (Throwable)e));
                    }
                }
                finally {
                    mgr.addResourceChangeListener(AbstractDiagramEditor.this.resourceChangeListener);
                }
                super.doSynchronize(element, monitor);
            }
        });
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        this.activity = (org.eclipse.epf.uma.Activity)AbstractDiagramEditor.getMethodElement(input);
        DiagramEditorInputProxy inputProxy = null;
        if (input instanceof DiagramEditorInputProxy) {
            inputProxy = (DiagramEditorInputProxy)input;
            inputProxy.setTransactionalEditingDomain(this.createEditingDomain());
        }
        super.doSetInput(input, releaseEditorContents);
        if (this.isEditable() && inputProxy != null && !inputProxy.isNewDiagram()) {
            this.getDiagramManager().backupDiagram(this.activity, this.getDiagram());
        }
        this.initializeTitle(input);
    }

    private void initializeTitle(IEditorInput input) {
        DiagramFileEditorInputProxy fileInput;
        DiagramEditorInput diagramInput;
        MethodElement inputElement;
        String title = "";
        if (input != null && (inputElement = (diagramInput = (fileInput = (DiagramFileEditorInputProxy)input).getDiagramEditorInput()).getMethodElement()) != null) {
            title = String.valueOf(this.getPartNamePrefix()) + inputElement.getName() + "," + " " + diagramInput.getSuppression().getProcess().getName();
            Image titleImage = this.getPartImage();
            this.setTitleImage(titleImage);
        }
        this.setPartName(title);
        this.firePropertyChange(257);
    }

    protected void sanityCheckState(IEditorInput input) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        long stamp = p.getModificationStamp((Object)input);
        if (stamp != this.fModificationStamp) {
            this.fModificationStamp = stamp;
            if (!p.isSynchronized((Object)input)) {
                this.handleEditorInputChanged();
                if (!p.isSynchronized((Object)input) && p instanceof SharedResourceDiagramDocumentProvider) {
                    ((SharedResourceDiagramDocumentProvider)p).allowEditing(input);
                }
            }
        }
        this.updateState(this.getEditorInput());
    }

    public void dispose() {
        DiagramEditPart editPart;
        IEditorInput input;
        Activity act;
        ILibraryManager manager;
        Diagram diagram = this.getDiagram();
        if (this.isDirty()) {
            this.reverseToSaved();
        }
        if (this.titleAdapter != null) {
            MethodElement e = AbstractDiagramEditor.getMethodElement(this.getEditorInput());
            if (e != null) {
                e.eAdapters().remove((Object)this.titleAdapter);
            }
            this.titleAdapter = null;
        }
        if (this.diagramMgr != null) {
            if (this.activity != null && diagram != null) {
                this.diagramMgr.removeDiagramBackup(this.activity, diagram.getType());
            }
            this.diagramMgr.removeResourceChangeListener(this.resourceChangeListener);
            this.diagramMgr.removeConsumer((Object)this);
        }
        if (this.diagramSvc != null) {
            this.diagramSvc.dispose();
        }
        if ((manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.removeListener(this.libraryListener);
        }
        LibraryService.getInstance().removeListener(this.libSvcListener);
        if (this.getDiagram().getElement() instanceof Activity && (act = (Activity)this.getDiagram().getElement()) != null && this.getDiagramAdapter() != null) {
            act.eAdapters().remove((Object)this.getDiagramAdapter());
        }
        if ((input = this.getEditorInput()) instanceof IDisposable) {
            ((IDisposable)input).dispose();
        }
        if ((editPart = this.getDiagramEditPart()) != null) {
            editPart.setModel(null);
        }
        super.dispose();
    }

    private DiagramAdapter getDiagramAdapter() {
        View view = (View)this.getDiagramEditPart().getModel();
        return view != null ? (DiagramAdapter)BridgeHelper.getNodeAdapter(view.getElement()) : null;
    }

    private void reverseToSaved() {
        block9: {
            try {
                MethodElement me;
                boolean saveNeeded;
                DiagramAdapter adapter;
                IDocumentProvider p = this.getDocumentProvider();
                if (p instanceof SharedResourceDiagramDocumentProvider) {
                    ((SharedResourceDiagramDocumentProvider)p).reverseToSaved(this.getEditorInput());
                }
                if ((adapter = this.getDiagramAdapter()) == null) {
                    return;
                }
                IActionManager actionMgr = adapter.getActionManager();
                boolean dirty = actionMgr.isSaveNeeded();
                if (dirty) {
                    actionMgr.undoAll();
                }
                this.getActionManager().clear();
                boolean bl = saveNeeded = dirty && this.getLastModified() > adapter.getUmaLastModified();
                if (!saveNeeded || (me = this.getMethodElementFromInput()) == null) break block9;
                ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    persister.save(me.eResource());
                    persister.commit();
                }
                catch (Exception e) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                    try {
                        persister.rollback();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private Process getProcess() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IDiagramFileEditorInputProxy) {
            return ((IDiagramFileEditorInputProxy)input).getDiagramEditorInput().getSuppression().getProcess();
        }
        return null;
    }

    protected MethodElement getMethodElementFromInput() {
        return AbstractDiagramEditor.getMethodElement(this.getEditorInput());
    }

    private static MethodElement getMethodElement(IEditorInput input) {
        if (input instanceof DiagramFileEditorInputProxy) {
            return ((DiagramFileEditorInputProxy)input).getDiagramEditorInput().getMethodElement();
        }
        return null;
    }

    private long getLastModified() {
        Resource resource = this.getMethodElementFromInput().eResource();
        if (resource != null && resource.getURI().isFile()) {
            File file = new File(resource.getURI().toFileString());
            return file.lastModified();
        }
        return -1L;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IActionManager actionMgr;
        DiagramAdapter diagramAdapter = this.getDiagramAdapter();
        if (diagramAdapter != null && (actionMgr = this.getDiagramAdapter().getActionManager()) != null && actionMgr.isSaveNeeded()) {
            try {
                progressMonitor.beginTask(NLS.bind((String)DiagramCoreResources.Progress_Saving_message, (Object)""), -1);
                ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                Collection modifiedResources = actionMgr.getModifiedResources();
                IStatus status = Services.getAccessController().checkModify(modifiedResources.toArray(new Resource[0]), (Object)this.getSite().getShell());
                if (!status.isOK()) {
                    return;
                }
                try {
                    for (Resource resource : modifiedResources) {
                        progressMonitor.setTaskName(NLS.bind((String)DiagramCoreResources.Progress_Saving_message, (Object)(resource.getURI().isFile() ? resource.getURI().toFileString() : "")));
                        persister.save(resource);
                    }
                    persister.commit();
                    actionMgr.saveIsDone();
                }
                catch (Exception e) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                    try {
                        persister.rollback();
                    }
                    catch (Exception ex) {
                        CommonPlugin.getDefault().getLogger().logError((Throwable)ex);
                        progressMonitor.done();
                        return;
                    }
                    CommonPlugin.getDefault().getMsgCallback().displayWarning((AbstractActivator)CommonPlugin.getDefault(), DiagramCoreResources.Warning_Saving_Diagram, e.getMessage(), (Throwable)e);
                    progressMonitor.done();
                    return;
                }
            }
            finally {
                progressMonitor.done();
            }
        }
        this.cleanUp();
        super.doSave(progressMonitor);
        this.getDiagramManager().backupDiagram(this.activity, this.getDiagram());
    }

    protected void cleanUp() {
        Diagram diagram = this.getDiagram();
        EObject model = diagram.getElement();
        if (model != null) {
            final HashSet<EObject> orphans = new HashSet<EObject>();
            TreeIterator iter = model.eAllContents();
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                if (!this.isOrphan(object)) continue;
                orphans.add(object);
            }
            if (!orphans.isEmpty()) {
                try {
                    TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                        public void run() {
                            for (EObject orphan : orphans) {
                                EcoreUtil.remove((EObject)orphan);
                            }
                        }
                    });
                }
                catch (ExecutionException e) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    protected boolean isOrphan(EObject modelElement) {
        return false;
    }

    protected ScrollingGraphicalViewer createScrollingGraphicalViewer() {
        return new DiagramGraphicalViewerEx();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.currentConfig = LibraryService.getInstance().getCurrentMethodConfiguration();
        LibraryService.getInstance().addListener(this.libSvcListener);
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.addListener(this.libraryListener);
        }
        this.getGraphicalControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                AbstractDiagramEditor.this.handleDoubleClick(event);
            }
        });
        IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
        DiagramContextMenuProvider provider = new DiagramContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)this.getDiagramGraphicalViewer());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)viewer);
        if (this.actionService != null) {
            this.actionService.setGraphicalViewer((GraphicalViewer)viewer);
        }
        this.titleAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                switch (msg.getFeatureID(MethodElement.class)) {
                    case 0: {
                        AbstractDiagramEditor.this.initializeTitle(AbstractDiagramEditor.this.getEditorInput());
                    }
                }
            }
        };
        MethodElement e = AbstractDiagramEditor.getMethodElement(this.getEditorInput());
        if (e != null && this.titleAdapter != null) {
            e.eAdapters().add((Object)this.titleAdapter);
        }
    }

    private void configChanged() {
        MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (this.currentConfig != config) {
            MethodElement e;
            IEditorInput input;
            boolean refresh;
            IWorkbenchPart activePart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
            boolean bl = refresh = activePart == this;
            if (!refresh && activePart instanceof IEditorPart && (input = ((IEditorPart)activePart).getEditorInput()) instanceof IMethodElementProvider && (e = ((IMethodElementProvider)input).getMethodElement()) instanceof ProcessComponent) {
                boolean bl2 = refresh = e instanceof ProcessComponent && this.getProcess() == ((ProcessComponent)e).getProcess();
            }
            if (refresh) {
                this.currentConfig = config;
                this.refresh();
                this.needRefresh = false;
            } else {
                this.needRefresh = true;
            }
        }
    }

    public void refresh() {
        if (this.getDocumentProvider() instanceof SharedResourceDiagramDocumentProvider) {
            SharedResourceDiagramDocumentProvider docProvider = (SharedResourceDiagramDocumentProvider)this.getDocumentProvider();
            DiagramEditPart editPart = this.getDiagramEditPart();
            boolean wasDirty = this.isDirty();
            boolean wasBaseDirty = false;
            IEditorPart baseEditor = null;
            boolean isInherited = DiagramEditorUtil.isInherited((EditPart)editPart);
            if (isInherited) {
                MethodElement element = BridgeHelper.getMethodElement((View)editPart.getDiagramView());
                String type = editPart.getDiagramView().getType();
                IEditorReference[] editorRefs = this.getSite().getPage().getEditorReferences();
                int i = 0;
                while (i < editorRefs.length) {
                    IEditorReference ref = editorRefs[i];
                    try {
                        IEditorPart editor;
                        DiagramEditorInput input;
                        if (ref.getEditorInput() instanceof IDiagramFileEditorInputProxy && (input = ((IDiagramFileEditorInputProxy)ref.getEditorInput()).getDiagramEditorInput()).getWrapper() == null && input.getMethodElement() == element && DiagramManager.getDiagramType(type) == input.getDiagramType() && (editor = ref.getEditor(false)) != null) {
                            wasBaseDirty = editor.isDirty();
                            baseEditor = editor;
                            break;
                        }
                    }
                    catch (PartInitException e) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++i;
                }
            }
            docProvider.setContent(this.getEditorInput());
            if (wasDirty) {
                docProvider.setCanSaveDocument(this.getEditorInput());
            } else if (this.isDirty()) {
                ((SharedResourceDiagramDocumentProvider)this.getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)this.getEditorInput());
            }
            if (baseEditor != null && !wasBaseDirty) {
                ((SharedResourceDiagramDocumentProvider)((DiagramDocumentEditor)baseEditor).getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)baseEditor.getEditorInput());
            }
            this.updateState(this.getEditorInput());
        }
    }

    protected void handleDoubleClick(Event event) {
    }

    public boolean isDirty() {
        if (!DiagramEditorUtil.isModifiable(this.getEditorInput())) {
            return false;
        }
        return super.isDirty();
    }

    public boolean isEditable() {
        if (this.getDocumentProvider() instanceof SharedResourceDiagramDocumentProvider) {
            return !((SharedResourceDiagramDocumentProvider)this.getDocumentProvider()).getLockedState();
        }
        return true;
    }

    protected KeyHandler getKeyHandler() {
        KeyHandler keyHandler = super.getKeyHandler();
        if (keyHandler != null) {
            ActionRegistry registry = this.getActionRegistry();
            Object action = registry.getAction((Object)ActionFactory.DELETE.getId());
            if (action != null && !(action instanceof DelegateAction)) {
                this.getActionRegistry().removeAction(action);
                this.getSelectionActions().remove(action);
                action = new DelegateAction((IWorkbenchPart)this, ActionFactory.DELETE.getId());
                action.setId(ActionFactory.DELETE.getId());
                this.getActionRegistry().registerAction(action);
                this.getSelectionActions().add(action.getId());
            }
            keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            keyHandler.put(KeyStroke.getPressed((char)'\b', (int)8, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            keyHandler.put(KeyStroke.getPressed((char)'\u0004', (int)100, (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 4));
            AccessibilityMoveAction moveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_down_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000002, (int)262144), (IAction)moveAction);
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 1));
            moveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_up_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000001, (int)262144), (IAction)moveAction);
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 8));
            moveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_left_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000003, (int)262144), (IAction)moveAction);
            this.getActionRegistry().registerAction((IAction)new AccessibilityMoveAction((IWorkbenchPart)this, 16));
            moveAction = (AccessibilityMoveAction)this.getActionRegistry().getAction((Object)"move_right_action");
            keyHandler.put(KeyStroke.getPressed((int)0x1000004, (int)262144), (IAction)moveAction);
            action = SelectAllAction.createSelectAllAction((IWorkbenchPage)this.getEditorSite().getWorkbenchWindow().getActivePage());
            this.getActionRegistry().registerAction(action);
            this.getSelectionActions().add(action.getId());
            keyHandler.put(KeyStroke.getReleased((char)'\u0001', (int)97, (int)262144), action);
            keyHandler.put(KeyStroke.getReleased((char)'\u0001', (int)97, (int)262144), action);
        }
        return keyHandler;
    }

    protected void createActions() {
        super.createActions();
        this.createControlFlowAction();
        this.actionService = new DiagramActionsService(this.getDiagramManager().getEditingDomain(), this.getGraphicalViewer(), this.getEditDomain(), this.getActionRegistry());
        this.actionService.registerHorizontalAlignAverageAction();
        this.actionService.registerHorizontalAlignFirstSelectedAction();
        this.actionService.registerVerticalAlignAverageAction();
        this.actionService.registerVerticalAlignFirstSelectedAction();
    }

    protected IAction createAnAction(String actionName, List<IElementType> elementType, String actionId, String tooltipString, ImageDescriptor imagedesc) {
        CreateElementAction action = new CreateElementAction((IWorkbenchPart)this, actionName);
        action.setElementTypes(elementType);
        action.setPreferenceHint(this.getPreferencesHint());
        action.setImageDescriptor(imagedesc);
        action.setToolTipText(tooltipString);
        action.setId(actionId);
        return action;
    }

    public void contributeToContextMenu(IMenuManager menu) {
        if (this.actionService != null) {
            this.actionService.createAlignMenu(menu, this.isEditable());
        }
        this.addToMenu(menu, "create_diagram_link", "additions", true, true);
    }

    protected void addToMenu(IMenuManager menu, String id, String groupName, boolean separator, boolean append) {
        boolean canModify = this.isEditable();
        if (id != null) {
            IAction action = this.getActionRegistry().getAction((Object)id);
            if (action != null && action.isEnabled() && canModify) {
                if (append) {
                    menu.appendToGroup(groupName, action);
                } else {
                    menu.prependToGroup(groupName, action);
                }
                if (separator) {
                    menu.insertAfter(id, (IContributionItem)new Separator());
                }
            }
        } else if (separator && canModify) {
            if (append) {
                menu.appendToGroup(groupName, (IContributionItem)new Separator());
            } else {
                menu.prependToGroup(groupName, (IContributionItem)new Separator());
            }
        }
    }

    public void resetLayout() {
    }

    public void refreshDiagram() {
        this.refresh();
    }

    protected abstract String getPartNamePrefix();

    protected abstract Image getPartImage();

    private void createControlFlowAction() {
        Action linkAction = new Action(DiagramCoreResources.ActivityDiagram_Palette_control_flow_create_text){

            public void run() {
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (editParts.size() == 2) {
                    EditPart sourceEditPart = (EditPart)editParts.get(0);
                    EditPart targetEditPart = (EditPart)editParts.get(1);
                    View sourceModel = (View)sourceEditPart.getModel();
                    View targetModel = (View)targetEditPart.getModel();
                    if (BridgeHelper.isReadOnly(sourceModel) || BridgeHelper.isReadOnly(targetModel)) {
                        return;
                    }
                    CreateUnspecifiedTypeConnectionRequest connectionRequest = AbstractDiagramEditor.this.getCreateControlFlowRequest();
                    if (connectionRequest != null) {
                        Command cmd;
                        connectionRequest.setSourceEditPart(null);
                        connectionRequest.setTargetEditPart(targetEditPart);
                        connectionRequest.setType((Object)"connection start");
                        connectionRequest.setLocation(new Point(0, 0));
                        sourceEditPart.getCommand((Request)connectionRequest);
                        connectionRequest.setSourceEditPart(sourceEditPart);
                        connectionRequest.setTargetEditPart(targetEditPart);
                        connectionRequest.setType((Object)"connection end");
                        connectionRequest.setLocation(new Point(0, 0));
                        DiagramEditPart diagramEditPart = AbstractDiagramEditor.this.getDiagramEditPart();
                        if (diagramEditPart.isEditModeEnabled() && (cmd = targetEditPart.getCommand((Request)connectionRequest)) != null && cmd.canExecute()) {
                            cmd.execute();
                        }
                    }
                }
            }

            public boolean isEnabled() {
                if (AbstractDiagramEditor.this.getCreateControlFlowRequest() == null) {
                    return false;
                }
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (editParts.size() == 2) {
                    EditPart sourceEditPart = (EditPart)editParts.get(0);
                    EditPart targetEditPart = (EditPart)editParts.get(1);
                    View sourceModel = (View)sourceEditPart.getModel();
                    View targetModel = (View)targetEditPart.getModel();
                    if (BridgeHelper.isReadOnly(sourceModel) || BridgeHelper.isReadOnly(targetModel)) {
                        return false;
                    }
                    for (Edge edge : AbstractDiagramEditor.this.getDiagram().getEdges()) {
                        if (edge.getSource() != sourceModel || edge.getTarget() != targetModel) continue;
                        return false;
                    }
                    if (sourceModel.getElement() instanceof ActivityNode | sourceModel.getElement() instanceof NamedNode || targetModel.getElement() instanceof ActivityNode || targetModel.getElement() instanceof NamedNode) {
                        return true;
                    }
                }
                return false;
            }

            public String getId() {
                return "create_diagram_link";
            }

            public ImageDescriptor getImageDescriptor() {
                return DiagramConstants.CONTROL_FLOW_IMAGE_DESCRIPTOR;
            }
        };
        this.getActionRegistry().registerAction((IAction)linkAction);
    }

    protected CreateUnspecifiedTypeConnectionRequest getCreateControlFlowRequest() {
        return null;
    }

    protected Diagram getDiagram(org.eclipse.epf.uma.Activity activity, int type) {
        return this.getDiagramService().getDiagram(activity, type);
    }

    private class DiagramGraphicalViewerEx
    extends DiagramGraphicalViewer
    implements IDiagramEditorInputProvider {
        private DiagramGraphicalViewerEx() {
        }

        public DiagramEditorInput getDiagramEditorInput() {
            return ((IDiagramFileEditorInputProxy)AbstractDiagramEditor.this.getEditorInput()).getDiagramEditorInput();
        }

        public IEditorPart getEditor() {
            return AbstractDiagramEditor.this;
        }
    }
}

