/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.RoleNode;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.JoinNode;

public class DiagramCoreValidation {
    private static final String errMsg_CanNotConnect = DiagramCoreResources.DiagramValidation_err_cannot_connect_text;
    private static final String errMsg_SamePredAndSucc = DiagramCoreResources.DiagramValidation_err_samepredandsuc_text;
    private static final String errMsg_CanNotDelete = DiagramCoreResources.DiagramValidation_err_cannot_delete_text;

    public static boolean isConnectionToReadOnlyTargetAllowed() {
        return true;
    }

    public static String isTargetReadonly(EditPart part) {
        View view = (View)part.getModel();
        if (BridgeHelper.isReadOnly(view)) {
            return errMsg_CanNotConnect;
        }
        return null;
    }

    public static String canConnect(EditPart targetEditPart, EObject sourceElement, EObject targetElement) {
        if (targetEditPart == null) {
            return errMsg_CanNotConnect;
        }
        EditPart part = targetEditPart.getParent();
        Diagram diagram = null;
        while (part != null && !(part instanceof DiagramEditPart)) {
            part = part.getParent();
        }
        if (part instanceof DiagramEditPart) {
            diagram = (Diagram)((DiagramEditPart)part).getModel();
        }
        if (diagram == null) {
            return errMsg_CanNotConnect;
        }
        return DiagramCoreValidation.checkConnect(diagram, sourceElement, targetElement);
    }

    public static String checkConnect(Diagram diagram, EObject sourceElement, EObject targetElement) {
        switch (DiagramHelper.getDiagramType(diagram)) {
            case 0: {
                if (DiagramCoreValidation.alwaysAllowed(sourceElement, targetElement)) {
                    return null;
                }
                if (BridgeHelper.isReadOnly((View)diagram)) {
                    return errMsg_CanNotConnect;
                }
                NodeAdapter sourceAdapter = BridgeHelper.getNodeAdapter(sourceElement);
                NodeAdapter targetAdapter = BridgeHelper.getNodeAdapter(targetElement);
                if (sourceAdapter == null || targetAdapter == null) {
                    return errMsg_CanNotConnect;
                }
                Diagram sourceDiagram = sourceAdapter.getView().getDiagram();
                if (!diagram.equals(sourceDiagram)) {
                    return errMsg_CanNotConnect;
                }
                ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
                Adapter adapter = adapterFactory.adapt((Notifier)BridgeHelper.getMethodElement((View)sourceDiagram), ITreeItemContentProvider.class);
                Object proc = null;
                if (adapter instanceof IBSItemProvider) {
                    proc = ((IBSItemProvider)adapter).getTopItem();
                }
                ArrayList<Object> allElements = new ArrayList<Object>();
                AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator((AdapterFactory)adapterFactory, proc);
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    allElements.add(TngUtil.unwrap(obj));
                }
                if (proc == null) break;
                MethodElement source = sourceAdapter.getElement();
                MethodElement target = null;
                if (targetAdapter != null) {
                    target = targetAdapter.getElement();
                }
                if (source instanceof WorkBreakdownElement) {
                    if (target instanceof WorkBreakdownElement) {
                        if (ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)target), (WorkBreakdownElement)((WorkBreakdownElement)source), allElements)) {
                            return errMsg_SamePredAndSucc;
                        }
                        if (DiagramCoreValidation.isConnectionToReadOnlyTargetAllowed() || !targetAdapter.isTargetReadOnly()) break;
                        return errMsg_CanNotConnect;
                    }
                    ArrayList<ActivityNode> actNodes = new ArrayList<ActivityNode>();
                    BridgeHelper.getSuccessorNodes(actNodes, (ActivityNode)targetElement);
                    for (ActivityNode node : actNodes) {
                        if (BridgeHelper.getNodeAdapter((EObject)node).isTargetReadOnly() && !DiagramCoreValidation.isConnectionToReadOnlyTargetAllowed()) {
                            return errMsg_CanNotConnect;
                        }
                        if (!ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)node)), (WorkBreakdownElement)((WorkBreakdownElement)source), allElements)) continue;
                        return errMsg_SamePredAndSucc;
                    }
                } else if (target instanceof WorkBreakdownElement) {
                    ArrayList<ActivityNode> srcNodes = new ArrayList<ActivityNode>();
                    BridgeHelper.getPredecessorNodes(srcNodes, (ActivityNode)sourceElement);
                    if (srcNodes.isEmpty()) break;
                    if (targetAdapter.isTargetReadOnly() && !DiagramCoreValidation.isConnectionToReadOnlyTargetAllowed()) {
                        return errMsg_CanNotConnect;
                    }
                    for (ActivityNode predNode : srcNodes) {
                        MethodElement pred = BridgeHelper.getMethodElement((EModelElement)predNode);
                        if (!ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)target), (WorkBreakdownElement)((WorkBreakdownElement)pred), allElements)) continue;
                        return errMsg_SamePredAndSucc;
                    }
                } else {
                    if (DiagramCoreValidation.checkSyncBarCircularLooop((ActivityNode)sourceElement, (ActivityNode)targetElement) != null) {
                        return errMsg_CanNotConnect;
                    }
                    if (targetElement instanceof InitialNode) {
                        return errMsg_CanNotConnect;
                    }
                    ArrayList<ActivityNode> srcNodes = new ArrayList<ActivityNode>();
                    BridgeHelper.getPredecessorNodes(srcNodes, (ActivityNode)sourceElement);
                    if (srcNodes.isEmpty()) break;
                    ArrayList<ActivityNode> targetNodes = new ArrayList<ActivityNode>();
                    BridgeHelper.getSuccessorNodes(targetNodes, (ActivityNode)target);
                    for (ActivityNode node : targetNodes) {
                        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                        if (nodeAdapter.isTargetReadOnly() && !DiagramCoreValidation.isConnectionToReadOnlyTargetAllowed()) {
                            return errMsg_CanNotConnect;
                        }
                        WorkBreakdownElement succ = (WorkBreakdownElement)nodeAdapter.getElement();
                        for (ActivityNode prednode : srcNodes) {
                            NodeAdapter predAdapter = BridgeHelper.getNodeAdapter((EObject)prednode);
                            WorkBreakdownElement pred = (WorkBreakdownElement)predAdapter.getElement();
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)succ, (WorkBreakdownElement)pred, allElements)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                }
                break;
            }
        }
        return null;
    }

    public static String checkSyncBarCircularLooop(ActivityNode sNode, ActivityNode tNode) {
        EList list = tNode.getOutgoings();
        if (!list.isEmpty() && list.size() > 0) {
            for (ActivityEdge link : list) {
                ActivityNode typednode = link.getTarget();
                if (sNode.equals(typednode)) {
                    return errMsg_CanNotConnect;
                }
                if (!(typednode instanceof ControlNode)) continue;
                return DiagramCoreValidation.checkSyncBarCircularLooop(sNode, (ActivityNode)((ControlNode)typednode));
            }
        }
        return null;
    }

    public static String checkSyncBarIncomingLinks(ActivityNode typedNode) {
        for (ActivityEdge link : typedNode.getIncomings()) {
            ActivityNode source = link.getSource();
            NodeAdapter adapter = BridgeHelper.getNodeAdapter((EObject)source);
            if (adapter == null || !(adapter.getElement() instanceof WorkBreakdownElement ? adapter.isTargetReadOnly() : source instanceof ControlNode && (source instanceof ForkNode || source instanceof JoinNode) && DiagramCoreValidation.checkSyncBarIncomingLinks(source) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkSyncBarOutgoingLinks(ActivityNode typedNode) {
        for (ActivityEdge link : typedNode.getOutgoings()) {
            ActivityNode target = link.getTarget();
            NodeAdapter adapter = BridgeHelper.getNodeAdapter((EObject)target);
            if (adapter == null || !(adapter.getElement() instanceof WorkBreakdownElement ? adapter.isTargetReadOnly() : target instanceof ControlNode && (target instanceof ForkNode || target instanceof JoinNode) && DiagramCoreValidation.checkSyncBarOutgoingLinks(target) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkDelete(Node node) {
        if (BridgeHelper.isReadOnly((View)node)) {
            return errMsg_CanNotDelete;
        }
        Diagram diagram = node.getDiagram();
        if (diagram instanceof ActivityDiagram) {
            if (node.getElement() instanceof ControlNode) {
                ArrayList<ActivityNode> targetNodes = new ArrayList<ActivityNode>();
                BridgeHelper.getSuccessorNodes(targetNodes, (ActivityNode)node.getElement());
                for (ActivityNode targetNode : targetNodes) {
                    NodeAdapter adapter = BridgeHelper.getNodeAdapter((EObject)targetNode);
                    if (adapter == null || !adapter.isTargetReadOnly()) continue;
                    return errMsg_CanNotDelete;
                }
            }
        } else if (diagram instanceof ActivityDetailDiagram && node.getElement() instanceof RoleNode) {
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkReconnect(Node source, Node target, Edge link) {
        if (source.getDiagram() instanceof ActivityDiagram && link.getTarget() != null) {
            if (BridgeHelper.isReadOnly(link.getTarget())) {
                return errMsg_CanNotConnect;
            }
            if (link.getTarget() instanceof TypedNode) {
                Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)link.getTarget()), WorkBreakdownElementNode.class);
                for (Node node : targetNodes) {
                    if (!BridgeHelper.isReadOnly((View)node)) continue;
                    return errMsg_CanNotConnect;
                }
            }
        }
        return DiagramCoreValidation.checkConnect(source, target, link);
    }

    public static String checkConnect(Node source, Node target, Edge link) {
        if (source == target && !(BridgeHelper.getMethodElement((View)source) instanceof org.eclipse.epf.uma.Activity)) {
            return errMsg_CanNotConnect;
        }
        EList links = source.getTargetEdges();
        if (links != null) {
            if (links.contains(link) && link.getTarget().equals(target)) {
                return null;
            }
            for (Link linkx : links) {
                org.eclipse.epf.diagram.model.Node linkxtarget = linkx.getTarget();
                if (linkxtarget == null || !linkxtarget.equals(target)) continue;
                return errMsg_CanNotConnect;
            }
        }
        return DiagramCoreValidation.checkConnect(source.getDiagram(), source.getElement(), target.getElement());
    }

    private static boolean alwaysAllowed(Object sourceElement, Object targetElement) {
        return sourceElement instanceof InitialNode || targetElement instanceof FinalNode || sourceElement instanceof ControlNode && !BridgeHelper.isSynchBar((ActivityNode)((ControlNode)sourceElement)) || targetElement instanceof ControlNode && !BridgeHelper.isSynchBar((ActivityNode)((ControlNode)targetElement));
    }

    private static boolean isRegularEdge(Edge edge) {
        MethodElement workOrder = BridgeHelper.getMethodElement((View)edge);
        return workOrder == null || MethodElementPropertyHelper.getProperty((MethodElement)workOrder, (String)"successor") == null;
    }

    public static String checkDelete(Edge edge) {
        View source = edge.getSource();
        View target = edge.getTarget();
        if (target != null) {
            Diagram diagram = target.getDiagram();
            switch (DiagramHelper.getDiagramType(diagram)) {
                case 0: {
                    EObject sourceElement = source.getElement();
                    EObject targetElement = target.getElement();
                    if (DiagramCoreValidation.alwaysAllowed(sourceElement, targetElement)) {
                        return null;
                    }
                    if (BridgeHelper.isInherited((EModelElement)edge)) {
                        return errMsg_CanNotDelete;
                    }
                    if (BridgeHelper.isReadOnly(source) && BridgeHelper.isReadOnly(target)) {
                        MethodElement me = BridgeHelper.getMethodElement((View)edge);
                        if (me instanceof WorkOrder && ProcessUtil.isCustomWorkOrder((WorkOrder)((WorkOrder)me))) {
                            return null;
                        }
                        return errMsg_CanNotDelete;
                    }
                    return null;
                }
                case 2: {
                    return errMsg_CanNotDelete;
                }
                case 1: {
                    if (BridgeHelper.isReadOnly(target)) {
                        return errMsg_CanNotDelete;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean isReadOnly(Edge edge) {
        View target = edge.getTarget();
        View source = edge.getSource();
        if (target != null && target.getDiagram().getElement() instanceof ActivityDetailDiagram) {
            EObject targetElement;
            EObject sourceElement;
            if (source != null && (sourceElement = source.getElement()) != null && sourceElement instanceof TaskNode && ((TaskNode)sourceElement).isReadOnly()) {
                return true;
            }
            return target != null && (targetElement = target.getElement()) != null && targetElement instanceof TaskNode && ((TaskNode)targetElement).isReadOnly();
        }
        return DiagramCoreValidation.checkDelete(edge) != null;
    }

    public static boolean isDuplicateRelationship(EObject source, EObject target) {
        EObject container = source.eContainer();
        if (container instanceof Activity) {
            Activity activity = (Activity)container;
            EList list = activity.getEdges();
            for (ActivityEdge element : list) {
                if (element.getSource() != source || element.getTarget() != target) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasVisibleTarget(ActivityNode source) {
        EList list = source.getOutgoings();
        if (list != null && list.size() >= 1) {
            for (ActivityEdge edge : list) {
                View view;
                ActivityNode node = edge.getTarget();
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                if (nodeAdapter == null || (view = nodeAdapter.getView()) == null || !view.isVisible()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasVisibleSource(ActivityNode target) {
        EList list = target.getIncomings();
        if (list != null && list.size() >= 1) {
            for (ActivityEdge conn : list) {
                View view;
                ActivityNode node = conn.getSource();
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                if (nodeAdapter == null || (view = nodeAdapter.getView()) == null || !view.isVisible()) continue;
                return true;
            }
        }
        return false;
    }
}

