/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.util;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.ActivityNode;

public abstract class ValidatingTextDirectEditManager
extends TextDirectEditManager {
    public ValidatingTextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
    }

    protected void commit() {
        String msg = this.validate((String)this.getCellEditor().getValue());
        if (msg != null) {
            this.bringDown(false);
            Display.getCurrent().asyncExec((Runnable)new PromptEdit(this, msg));
            return;
        }
        super.commit();
    }

    protected void bringDown() {
        this.bringDown(true);
    }

    protected void bringDown(boolean check) {
        super.bringDown();
        if (check) {
            Node node = (Node)this.getEditPart().getModel();
            EObject aNode = node.getElement();
            String name = null;
            if (aNode instanceof ActivityNode) {
                name = ((ActivityNode)aNode).getName();
                MethodElement wbelement = BridgeHelper.getMethodElement((EModelElement)aNode);
                if (wbelement instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)wbelement))) {
                    name = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)wbelement));
                }
            } else if (aNode instanceof NamedNode) {
                Object wbelement;
                NamedNode nameNode = (NamedNode)aNode;
                name = nameNode.getName();
                if (node instanceof WorkBreakdownElementNode && (wbelement = nameNode.getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)wbelement))) {
                    name = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)wbelement));
                }
            }
            if (name == null || name.trim().length() == 0) {
                Display.getCurrent().asyncExec((Runnable)new PromptEdit(this, DiagramCoreResources.err_name_empty));
            }
        }
    }

    protected abstract String validate(String var1);

    protected abstract void performDirectEdit();

    static class PromptEdit
    implements Runnable {
        private ValidatingTextDirectEditManager manager;
        private String msg;

        PromptEdit(ValidatingTextDirectEditManager manager, String msg) {
            this.manager = manager;
            this.msg = msg;
        }

        public void run() {
            String title = DiagramCoreResources.diagram_errorDialog_title;
            MsgDialog dialog = DiagramCorePlugin.getDefault().getMsgDialog();
            dialog.displayError(title, this.msg);
            this.manager.performDirectEdit();
        }
    }
}

