/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.DiagramResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.impl.NodeContainerImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.model.util.IDiagramChangeListener;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.SimpleSemanticModelElement;

public class DiagramImpl
extends NodeContainerImpl
implements Diagram {
    private boolean newDiagram;
    protected IDiagramChangeListener diagramChangeListener;
    private Activity baseAct;
    private Object diagramAdapter = new AdapterImpl(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification msg) {
            if (!DiagramImpl.this.notificationEnabled) {
                return;
            }
            DiagramImpl.this.notificationEnabled = false;
            try {
                switch (msg.getFeatureID(Diagram.class)) {
                    case 7: {
                        switch (msg.getEventType()) {
                            case 3: {
                                DiagramImpl.this.nodeAdded(msg.getPosition(), (Node)msg.getNewValue());
                                return;
                            }
                            case 4: {
                                DiagramImpl.this.nodeRemoved((Node)msg.getOldValue());
                                return;
                            }
                            case 5: {
                                Collection collection = (Collection)msg.getNewValue();
                                for (Node node : collection) {
                                    DiagramImpl.this.nodeAdded(msg.getPosition(), node);
                                }
                                return;
                            }
                            case 6: {
                                Collection collection = (Collection)msg.getOldValue();
                                Iterator iter = collection.iterator();
                                while (iter.hasNext()) {
                                    DiagramImpl.this.nodeRemoved((Node)iter.next());
                                }
                                return;
                            }
                        }
                    }
                }
                return;
            }
            finally {
                DiagramImpl.this.notificationEnabled = true;
            }
        }
    };
    private Suppression suppression;
    protected BreakdownElementWrapperItemProvider wrapper;
    protected IFilter filter;
    private boolean graphicalDataRequired = true;

    protected DiagramImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.DIAGRAM;
    }

    protected Node addNode(Object obj) {
        Node node = this.addNode((Collection)this.getNodes(), obj);
        if (node == null) {
            return node;
        }
        this.populateLinks(node, true);
        return node;
    }

    protected Node addNode(Collection nodes, Object obj) {
        Node node;
        if (TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)obj) && (node = this.toNode((MethodElement)obj)) != null) {
            nodes.add(node);
            return node;
        }
        return null;
    }

    protected Collection addNodes(Collection collection) {
        ArrayList nodes = new ArrayList();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.addNode(nodes, iter.next());
        }
        this.getNodes().addAll(nodes);
        return nodes;
    }

    protected boolean removeNode(Object obj) {
        if (!TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)obj)) {
            return false;
        }
        Node node = GraphicalDataHelper.findNode(this, obj);
        if (node == null) {
            return false;
        }
        for (Link link : node.getOutgoingConnections()) {
            link.setTarget(null);
        }
        for (Link link : node.getIncomingConnections()) {
            link.setSource(null);
        }
        node.getOutgoingConnections().clear();
        node.getIncomingConnections().clear();
        this.getNodes().remove((Object)node);
        return true;
    }

    protected void removeNodes(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.removeNode(iter.next());
        }
    }

    public org.eclipse.epf.uma.Diagram getUMADiagram() {
        return (org.eclipse.epf.uma.Diagram)this.getGraphNode();
    }

    protected Class getDiagramChangeListenerType() {
        return IDiagramChangeListener.class;
    }

    protected List getBreakdownElementTypes() {
        return Collections.singletonList(BreakdownElement.class);
    }

    protected int getType() {
        return -1;
    }

    protected void nodeAdded(int index, Node node) {
        this.addToUmaModel(index, node);
        node.addConsumer(this);
    }

    protected void nodeRemoved(Node node) {
        this.removeFromUmaModel(node);
        node.removeConsumer(this);
    }

    public boolean isNew() {
        return this.newDiagram;
    }

    public void setNew(boolean n) {
        this.newDiagram = n;
    }

    public void setObject(Object newObject) {
        if (newObject instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)newObject).isReadOnly()) {
            this.wrapper = (BreakdownElementWrapperItemProvider)newObject;
            this.setReadOnly(true);
        }
        this.object = newObject = TngUtil.unwrap((Object)newObject);
        Activity e = (Activity)newObject;
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)e)) {
            this.baseAct = (Activity)e.getVariabilityBasedOnElement();
        }
        this.baseAct = null;
        if (newObject == null) {
            return;
        }
        if (this.isGraphicalDataRequired()) {
            this.graphNode = GraphicalDataManager.getInstance().getUMADiagram(e, this.getType(), false);
            if (this.graphNode == null) {
                this.graphNode = GraphicalDataManager.getInstance().getUMADiagram(e, this.getType(), true);
                this.setNew(true);
            }
        }
        if (!e.eAdapters().contains((Object)this.diagramChangeListener)) {
            e.eAdapters().add((Object)this.diagramChangeListener);
        }
        if (this.baseAct != null && !this.baseAct.eAdapters().contains((Object)this.diagramChangeListener)) {
            this.baseAct.eAdapters().add((Object)this.diagramChangeListener);
        }
        this.populateDiagram();
        if (!this.eAdapters().contains(this.diagramAdapter)) {
            this.eAdapters().add((Object)((Adapter)this.diagramAdapter));
        }
    }

    protected void populateDiagram() {
        this.populateNodes();
        this.populateLinks();
        for (NodeImpl node : this.getNodes()) {
            node.addConsumer(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void populateLinks(Node node, boolean disableNotification) {
        block7: {
            size = 0;
            notifies = null;
            try {
                if (disableNotification) {
                    size = this.getNodes().size();
                    notifies = new boolean[size];
                    i = 0;
                    while (i < size) {
                        child = (Node)this.getNodes().get(i);
                        notifies[i] = child.eDeliver();
                        child.eSetDeliver(false);
                        ++i;
                    }
                }
                if ((graphNode = node.getGraphNode()) != null) {
                    GraphicalDataHelper.fillConnections(node, graphNode);
                }
            }
            finally {
                if (!disableNotification) break block7;
                i = 0;
                if (true) ** GOTO lbl27
            }
            {
            }
            do {
                ((EObject)this.getNodes().get(i)).eSetDeliver(notifies[i]);
                ++i;
lbl27:
                // 2 sources

            } while (i < size);
        }
    }

    protected void populateNodes() {
        org.eclipse.epf.uma.Diagram diagram = this.getUMADiagram();
        if (diagram != null) {
            ArrayList<TypedNode> typedNodes = new ArrayList<TypedNode>();
            for (Object element : diagram.getContained()) {
                int type = DiagramImpl.getType(element);
                if (type <= 0) continue;
                TypedNode node = ModelFactory.eINSTANCE.createTypedNode();
                node.setType(type);
                node.setObject(element);
                typedNodes.add(node);
            }
            this.getNodes().addAll(typedNodes);
        }
    }

    private static int getType(Object obj) {
        GraphNode node;
        SemanticModelBridge modelBridge;
        if (obj instanceof GraphNode && (modelBridge = (node = (GraphNode)obj).getSemanticModel()) instanceof SimpleSemanticModelElement) {
            String type = ((SimpleSemanticModelElement)modelBridge).getTypeInfo();
            if ("synchnonization bar".equals(type)) {
                return 1;
            }
            if ("decision node".equals(type)) {
                return 2;
            }
            if ("end node".equals(type)) {
                return 4;
            }
            if ("start node".equals(type)) {
                return 3;
            }
            if ("free text".equals(type)) {
                return 6;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    protected void populateLinks() {
        size = this.getNodes().size();
        notifies = new boolean[size];
        try {
            i = 0;
            while (i < size) {
                node = (Node)this.getNodes().get(i);
                notifies[i] = node.eDeliver();
                node.eSetDeliver(false);
                ++i;
            }
            for (Node node : this.getNodes()) {
                this.populateLinks(node, false);
            }
        }
        finally {
            i = 0;
            ** while (i < size)
        }
lbl-1000:
        // 1 sources

        {
            ((EObject)this.getNodes().get(i)).eSetDeliver(notifies[i]);
            ++i;
            continue;
        }
lbl21:
        // 1 sources

    }

    protected void removeFromUmaModel(Node removedNode) {
        Activity act = (Activity)this.getObject();
        if (removedNode.getObject() instanceof BreakdownElement) {
            act.getBreakdownElements().remove(removedNode.getObject());
        }
        if (this.getUMADiagram() != null) {
            this.getUMADiagram().getContained().remove(removedNode.getGraphNode());
        }
    }

    protected void addToUmaModel(int position, Node addedNode) {
        if (addedNode.getGraphNode() == null) {
            ((NodeImpl)addedNode).basicSetObject(addedNode.getObject());
        }
        if (this.getUMADiagram() != null) {
            this.getUMADiagram().getContained().add(addedNode.getGraphNode());
        }
    }

    protected Node toNode(MethodElement e) {
        Node node = this.newNode();
        if (node == null) {
            return null;
        }
        node.setUMADiagram(this.getUMADiagram());
        node.setDiagram(this);
        node.setObject(e);
        return node;
    }

    protected Node newNode() {
        return null;
    }

    public Class getMethodElementAdapterType() {
        return this.getDiagramChangeListenerType();
    }

    protected void dispose() {
        if (this.diagramChangeListener != null) {
            Activity e = (Activity)this.getObject();
            if (this.baseAct != null) {
                this.baseAct.eAdapters().remove((Object)this.diagramChangeListener);
            }
            if (e != null) {
                e.eAdapters().remove((Object)this.diagramChangeListener);
            }
        }
        super.dispose();
    }

    public void setDefaultName(NamedNode newNode) {
        MethodElement obj = (MethodElement)newNode.getObject();
        int classID = obj.eClass().getClassifierID();
        Activity act = (Activity)this.getObject();
        ArrayList<BreakdownElement> siblings = new ArrayList<BreakdownElement>();
        for (BreakdownElement e : act.getBreakdownElements()) {
            if (e.eClass().getClassifierID() != classID) continue;
            siblings.add(e);
        }
        String baseName = MessageFormat.format(DiagramResources.defaultBaseName, TngUtil.getTypeText((String)obj.eClass().getName()));
        TngUtil.setDefaultName(siblings, (MethodElement)obj, (String)baseName);
        newNode.setName(obj.getName());
    }

    protected void extractChildren(ITreeItemContentProvider adapter, Object object, Collection children, boolean filterSuppressed) {
        BSActivityItemProvider itemProvider;
        boolean oldRolledUp = false;
        if (adapter instanceof BSActivityItemProvider) {
            itemProvider = (BSActivityItemProvider)adapter;
            oldRolledUp = itemProvider.isRolledUp();
            itemProvider.basicSetRolledUp(false);
        } else if (adapter instanceof IBSItemProvider) {
            itemProvider = (IBSItemProvider)adapter;
            oldRolledUp = itemProvider.isRolledUp();
            itemProvider.setRolledUp(false);
        }
        try {
            if (adapter != null) {
                if (filterSuppressed) {
                    for (Object child : adapter.getChildren(object)) {
                        if (this.getSuppression().isSuppressed(child)) continue;
                        children.add(child);
                    }
                } else {
                    children.addAll(adapter.getChildren(object));
                }
            }
        }
        finally {
            if (adapter instanceof IBSItemProvider) {
                ((IBSItemProvider)adapter).setRolledUp(oldRolledUp);
            }
        }
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    public void setSuppression(Suppression suppression) {
        this.suppression = suppression;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public void moveNode(Object movedObject, int position, Object oldPosition) {
    }

    public boolean isGraphicalDataRequired() {
        return this.graphicalDataRequired;
    }

    public void setGraphicalDataRequired(boolean graphicalDataRequired) {
        this.graphicalDataRequired = graphicalDataRequired;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setWrapper(BreakdownElementWrapperItemProvider wrapper) {
        this.wrapper = wrapper;
    }

    public Collection getChildren() {
        return Collections.EMPTY_LIST;
    }

    protected class ActivityAdapter
    extends NodeImpl.TransactionalNodeLink
    implements IDiagramChangeListener {
        protected ActivityAdapter() {
            super(DiagramImpl.this);
        }

        public Diagram getDiagram() {
            return DiagramImpl.this;
        }

        protected void handleNotification(Notification msg) {
            block13: {
                block0 : switch (msg.getFeatureID(Activity.class)) {
                    case 40: {
                        switch (msg.getEventType()) {
                            case 3: {
                                Node node = DiagramImpl.this.addNode(msg.getNewValue());
                                if (node != null && msg.getNotifier() == DiagramImpl.this.baseAct) {
                                    node.setReadOnly(true);
                                    break block0;
                                }
                                break block13;
                            }
                            case 4: {
                                DiagramImpl.this.removeNode(msg.getOldValue());
                                break block0;
                            }
                            case 5: {
                                Collection nodes = DiagramImpl.this.addNodes((Collection)msg.getNewValue());
                                if (msg.getNotifier() == DiagramImpl.this.baseAct) {
                                    for (NodeImpl node : nodes) {
                                        node.setReadOnly(true);
                                    }
                                }
                                break block13;
                            }
                            case 6: {
                                DiagramImpl.this.removeNodes((Collection)msg.getOldValue());
                                break block0;
                            }
                            case 7: {
                                DiagramImpl.this.moveNode(msg.getNewValue(), msg.getPosition(), msg.getOldValue());
                            }
                        }
                    }
                }
            }
        }
    }
}

