/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IActivityDetailDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IActivityDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IWPDDiagramChangeListener;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.process.command.VaryActivityCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.GraphConnector;
import org.eclipse.epf.uma.GraphEdge;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Point;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphicalDataManager {
    private static final String[] diagramPresentations = new String[]{"Workflow", "Work Product Dependency", "Activity Detail"};
    private static final Class[] childTypes = new Class[]{Activity.class, WorkProductDescriptor.class, Descriptor.class};
    private static final Class[] diagramChangeListenerClasses = new Class[]{IActivityDiagramChangeListener.class, IWPDDiagramChangeListener.class, IActivityDetailDiagramChangeListener.class};
    private static GraphicalDataManager instance = null;
    private List<ICommandListener> commandListeners;

    private GraphicalDataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GraphicalDataManager getInstance() {
        if (instance != null) return instance;
        Class<GraphicalDataManager> clazz = GraphicalDataManager.class;
        synchronized (GraphicalDataManager.class) {
            if (instance != null) return instance;
            instance = new GraphicalDataManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public GraphNode getGraphNode(org.eclipse.epf.uma.Diagram diagram, MethodElement methodElement) {
        if (diagram == null) {
            return this.createGraphNode(methodElement);
        }
        GraphNode node = GraphicalDataManager.findGraphNode(diagram, methodElement);
        if (node == null) {
            node = this.createGraphNode(methodElement);
            this.createGraphConnectors(node, diagram);
            diagram.getContained().add(node);
        }
        return node;
    }

    public static GraphNode findGraphNode(org.eclipse.epf.uma.Diagram diagram, Object methodElement) {
        for (GraphNode element : diagram.getContained()) {
            if (!(element.getSemanticModel() instanceof UMASemanticModelBridge) || methodElement != ((UMASemanticModelBridge)element.getSemanticModel()).getElement()) continue;
            return element;
        }
        return null;
    }

    private org.eclipse.epf.uma.Diagram createDiagram(Activity act, int diagramType) {
        org.eclipse.epf.uma.Diagram baseDiagram;
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)act) && (baseDiagram = this.getUMADiagram((Activity)act.getVariabilityBasedOnElement(), diagramType, false)) != null) {
            org.eclipse.epf.uma.Diagram copy = GraphicalDataHelper.copyDiagram(baseDiagram);
            UMASemanticModelBridge modelBridge = (UMASemanticModelBridge)copy.getSemanticModel();
            modelBridge.setElement((MethodElement)act);
            return copy;
        }
        org.eclipse.epf.uma.Diagram diagram = UmaFactory.eINSTANCE.createDiagram();
        UMASemanticModelBridge modelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        modelBridge.setElement((MethodElement)act);
        modelBridge.setPresentation(diagramPresentations[diagramType]);
        diagram.setSemanticModel((SemanticModelBridge)modelBridge);
        this.populateDiagram(diagram, act, diagramType);
        return diagram;
    }

    private void populateDiagram(org.eclipse.epf.uma.Diagram diagram, Activity act, int diagramType) {
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        for (Object element : act.getBreakdownElements()) {
            if (!childTypes[diagramType].isInstance(element)) continue;
            GraphNode node = this.createGraphNode((MethodElement)element);
            diagram.getContained().add(node);
            nodes.add(node);
        }
        for (GraphNode node : nodes) {
            this.createGraphConnectors(node, diagram, diagramType);
        }
    }

    public IDiagramChangeListener getDiagramChangeListener(Activity act, int diagramType) {
        for (Object element : act.eAdapters()) {
            if (!diagramChangeListenerClasses[diagramType].isInstance(element)) continue;
            return (IDiagramChangeListener)element;
        }
        return null;
    }

    public GraphNode createGraphNode(MethodElement element) {
        GraphNode graphNode = UmaFactory.eINSTANCE.createGraphNode();
        UMASemanticModelBridge modelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        modelBridge.setElement(element);
        graphNode.setSemanticModel((SemanticModelBridge)modelBridge);
        Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(-1.0));
        point.setY(new Double(-1.0));
        graphNode.setPosition(point);
        Dimension dim = UmaFactory.eINSTANCE.createDimension();
        dim.setWidth(new Double(-1.0));
        dim.setHeight(new Double(-1.0));
        graphNode.setSize(dim);
        return graphNode;
    }

    public GraphEdge addGraphConnectorPair(org.eclipse.epf.uma.Diagram diagram, GraphNode graphNode, WorkOrder element) {
        GraphConnector srcConnector = UmaFactory.eINSTANCE.createGraphConnector();
        graphNode.getAnchorage().add(srcConnector);
        GraphEdge edge = UmaFactory.eINSTANCE.createGraphEdge();
        UMASemanticModelBridge bridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        bridge.setElement((MethodElement)element);
        edge.setSemanticModel((SemanticModelBridge)bridge);
        graphNode.getContained().add(edge);
        edge.getAnchor().add(srcConnector);
        GraphNode succNode = this.getGraphNode(diagram, (MethodElement)UmaUtil.getOwningActivity((WorkOrder)element));
        GraphConnector targetConnector = UmaFactory.eINSTANCE.createGraphConnector();
        succNode.getAnchorage().add(targetConnector);
        edge.getAnchor().add(targetConnector);
        return edge;
    }

    public GraphEdge addGraphConnectorPair(GraphNode srcNode, GraphNode targetNode) {
        GraphConnector srcConnector = UmaFactory.eINSTANCE.createGraphConnector();
        srcNode.getAnchorage().add(srcConnector);
        GraphEdge edge = UmaFactory.eINSTANCE.createGraphEdge();
        srcNode.getContained().add(edge);
        edge.getAnchor().add(srcConnector);
        GraphConnector targetConnector = UmaFactory.eINSTANCE.createGraphConnector();
        targetNode.getAnchorage().add(targetConnector);
        edge.getAnchor().add(targetConnector);
        return edge;
    }

    public void removeGraphEdge(GraphEdge edge) {
        EcoreUtil.remove((EObject)edge);
        for (GraphConnector conn : edge.getAnchor()) {
            EcoreUtil.remove((EObject)conn);
        }
    }

    public void removeGraphConnectionPair(GraphNode graphNode, WorkOrder workOrder) {
        Iterator iter = graphNode.getAnchorage().iterator();
        while (iter.hasNext()) {
            GraphConnector conn2;
            SemanticModelBridge bridge;
            GraphConnector conn = (GraphConnector)iter.next();
            GraphEdge edge = (GraphEdge)conn.getGraphEdge().get(0);
            if (edge.eContainer() != graphNode || !((bridge = (conn2 = (GraphConnector)edge.getAnchor().get(1)).getGraphElement().getSemanticModel()) instanceof UMASemanticModelBridge) || ((UMASemanticModelBridge)bridge).getElement() != UmaUtil.getOwningActivity((WorkOrder)workOrder)) continue;
            conn2.getGraphElement().getAnchorage().remove(conn2);
            iter.remove();
            graphNode.getContained().remove(edge);
            return;
        }
    }

    private void createGraphConnectors(GraphNode graphNode, org.eclipse.epf.uma.Diagram diagram) {
        this.createGraphConnectors(graphNode, diagram, this.getDiagramType(diagram));
    }

    int getDiagramType(org.eclipse.epf.uma.Diagram diagram) {
        String typeStr = diagram.getSemanticModel().getPresentation();
        int i = 0;
        while (i < diagramPresentations.length) {
            if (diagramPresentations[i].equals(typeStr)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createGraphConnectors(GraphNode graphNode, org.eclipse.epf.uma.Diagram diagram, int diagramType) {
        MethodElement e = ((UMASemanticModelBridge)graphNode.getSemanticModel()).getElement();
        switch (diagramType) {
            case 0: {
                if (!(e instanceof Activity)) break;
                Activity act = (Activity)e;
                for (WorkOrder workOrder : act.getLinkToPredecessor()) {
                    GraphNode srcNode = GraphicalDataManager.findGraphNode(diagram, workOrder.getPred());
                    if (srcNode == null) continue;
                    this.addGraphConnectorPair(srcNode, graphNode);
                }
                break;
            }
            case 1: {
                if (!(e instanceof WorkProductDescriptor)) break;
                WorkProductDescriptor descriptor = (WorkProductDescriptor)e;
                for (WorkProductDescriptor impactedDescriptor : descriptor.getImpacts()) {
                    GraphNode targetNode = GraphicalDataManager.findGraphNode(diagram, impactedDescriptor);
                    if (targetNode == null) continue;
                    this.addGraphConnectorPair(graphNode, targetNode);
                }
                break;
            }
        }
    }

    public org.eclipse.epf.uma.Diagram getUMADiagram(Activity e, int diagramType, boolean create) {
        org.eclipse.epf.uma.Diagram diagram2 = null;
        EObject container = e.eContainer();
        if (container != null) {
            ProcessPackage pkg = (ProcessPackage)container;
            for (org.eclipse.epf.uma.Diagram diagram2 : pkg.getDiagrams()) {
                SemanticModelBridge modelBridge = diagram2.getSemanticModel();
                if (modelBridge == null || !(modelBridge instanceof UMASemanticModelBridge) || e != ((UMASemanticModelBridge)modelBridge).getElement() || !diagramPresentations[diagramType].equals(((UMASemanticModelBridge)modelBridge).getPresentation())) continue;
                return diagram2;
            }
        }
        if (create) {
            diagram2 = this.createDiagram(e, diagramType);
            if (container != null) {
                ((ProcessPackage)container).getDiagrams().add(diagram2);
            }
            return diagram2;
        }
        return null;
    }

    public Diagram getDiagram(Activity act, int diagramType) {
        IDiagramChangeListener listener = this.getDiagramChangeListener(act, diagramType);
        return listener == null ? null : listener.getDiagram();
    }

    public List<ICommandListener> getCommandListeners() {
        if (this.commandListeners == null) {
            this.commandListeners = new ArrayList<ICommandListener>();
        }
        this.commandListeners.add(new ICommandListener(){

            public void notifyExecuted(Command command) {
                Activity act = (Activity)command.getResult().iterator().next();
                Activity base = (Activity)act.getVariabilityBasedOnElement();
                if (base != null) {
                    UMASemanticModelBridge bridge;
                    GraphNode graphNode;
                    Activity parentAct = act.getSuperActivities();
                    org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.this.getUMADiagram(parentAct, 0, false);
                    if (diagram != null && (graphNode = GraphicalDataManager.findGraphNode(diagram, base)) != null && (bridge = (UMASemanticModelBridge)graphNode.getSemanticModel()).getElement() != act) {
                        bridge.setElement((MethodElement)act);
                    }
                    if (act.getVariabilityType() == VariabilityType.LOCAL_CONTRIBUTION) {
                        int i = 0;
                        while (i < GraphicalDataHelper.DIAGRAM_TYPES.length) {
                            int diagramType = GraphicalDataHelper.DIAGRAM_TYPES[i];
                            diagram = GraphicalDataManager.this.getUMADiagram(base, diagramType, false);
                            if (diagram != null) {
                                org.eclipse.epf.uma.Diagram copy = GraphicalDataManager.this.getUMADiagram(act, diagramType, true);
                                copy.setSuppressed(diagram.getSuppressed());
                            }
                            ++i;
                        }
                    }
                }
            }

            public Class getCommandType() {
                return VaryActivityCommand.class;
            }

            public void preUndo(Command command) {
                UMASemanticModelBridge bridge;
                GraphNode graphNode;
                Activity parentAct;
                org.eclipse.epf.uma.Diagram diagram;
                Activity act = (Activity)command.getResult().iterator().next();
                VariabilityElement baseAct = act.getVariabilityBasedOnElement();
                if (baseAct != null && (diagram = GraphicalDataManager.this.getUMADiagram(parentAct = act.getSuperActivities(), 0, false)) != null && (graphNode = GraphicalDataManager.findGraphNode(diagram, act)) != null && (bridge = (UMASemanticModelBridge)graphNode.getSemanticModel()).getElement() != baseAct) {
                    bridge.setElement((MethodElement)baseAct);
                }
            }

            public void preExecute(Command command) {
            }

            public void postUndo(Command command) {
            }
        });
        return this.commandListeners;
    }
}

