/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.service;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.ui.service.IDiagramImageService;
import org.eclipse.epf.diagram.ui.utils.ImageUtils;
import org.eclipse.epf.diagram.ui.viewer.AbstractDiagramGraphicalViewer;
import org.eclipse.epf.diagram.ui.viewer.NewActivityDetailDiagramViewer;
import org.eclipse.epf.diagram.ui.viewer.NewActivityDiagramViewer;
import org.eclipse.epf.diagram.ui.viewer.NewWPDependencyDiagramViewer;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IMethodConfigurationProvider;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.DiagramOptions;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ProcessAdapterFactoryFilter;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiagramImageService
implements IDiagramImageService {
    static boolean debug = DiagramUIPlugin.getDefault().isDebugging();
    private Composite parent = null;
    private Composite holder = null;
    private File pubDir;
    private boolean forXMLExport = false;
    private static Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo = null;
    private boolean publishUncreatedADD = true;
    private boolean publishADForActivityExtension = true;
    private boolean exist = true;
    private MethodConfiguration config = null;
    Shell shell = null;
    private Set<DiagramManager> diagramManagers = new HashSet<DiagramManager>();

    static {
        typeMap.put("Activity", new Integer(0));
        typeMap.put("ActivityDetail", new Integer(2));
        typeMap.put("WPDependency", new Integer(1));
    }

    public static int getIntType(String diagramType) {
        Integer type = typeMap.get(diagramType);
        if (type != null) {
            return type;
        }
        return -1;
    }

    public static PreferencesHint getPreferenceHint(String diagramType) {
        int type = DiagramImageService.getIntType(diagramType);
        switch (type) {
            case 0: {
                return ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 2: {
                return ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 1: {
                return WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
        }
        return null;
    }

    public static String getStringType(int type) {
        switch (type) {
            case 0: {
                return "Activity";
            }
            case 2: {
                return "ActivityDetail";
            }
            case 1: {
                return "WPDependency";
            }
        }
        return null;
    }

    public DiagramImageService(File pubDir) {
        this(null, pubDir);
    }

    public DiagramImageService(Composite parent, File pubDir) {
        this.parent = parent;
        this.pubDir = pubDir;
    }

    private AbstractDiagramGraphicalViewer getDiagramViewer(int diagramType, Object wrapper) {
        if (this.shell != null && this.shell.isDisposed()) {
            this.parent = null;
            this.shell = null;
        }
        this.getViewerHolder(this.parent);
        switch (diagramType) {
            case 0: {
                return new NewActivityDiagramViewer(this.holder, wrapper);
            }
            case 2: {
                return new NewActivityDetailDiagramViewer(this.holder, wrapper);
            }
            case 1: {
                return new NewWPDependencyDiagramViewer(this.holder, wrapper);
            }
        }
        return null;
    }

    private void getViewerHolder(Composite parent) {
        if (parent == null) {
            if (this.shell == null || this.shell.isDisposed()) {
                this.shell = this.createShell();
            }
            this.shell.open();
            parent = this.shell;
        }
        if (this.holder != null) {
            this.holder.dispose();
        }
        this.holder = new Composite(parent, 0);
        this.holder.setLayoutData((Object)new GridData(1, 1));
        this.holder.setLayout((Layout)new GridLayout());
        this.holder.setVisible(false);
    }

    private Shell createShell() {
        Shell shell = null;
        Display d = Display.getDefault();
        shell = new Shell(d);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shell.setLayout((Layout)layout);
        shell.setBounds(0, 0, 0, 0);
        shell.setVisible(false);
        return shell;
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
        }
        for (DiagramManager mgr : this.diagramManagers) {
            mgr.removeConsumer((Object)this);
        }
    }

    public org.eclipse.epf.library.layout.diagram.DiagramInfo saveDiagram(final Object wrapper, final String imgPath, final String diagramType, final IFilter filter, final Suppression sup) {
        this.diagramInfo = null;
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                DiagramImageService.this.__internal_saveDiagram(wrapper, imgPath, diagramType, filter, sup);
            }
        });
        return this.diagramInfo;
    }

    private boolean hasUserDefinedDiagram(Activity e, String imgPath, int type) throws Exception {
        DiagramInfo info = new DiagramInfo(e);
        switch (type) {
            case 0: {
                if (!info.canPublishADImage()) break;
                return info.getActivityDiagram() != null && info.canPublishADImage();
            }
            case 2: {
                if (!info.canPublishADDImage()) break;
                return info.getActivityDetailDiagram() != null && info.canPublishADDImage();
            }
            case 1: {
                if (!info.canPublishWPDImage()) break;
                return info.getWPDDiagram() != null && info.canPublishWPDImage();
            }
        }
        return false;
    }

    private void __internal_saveDiagram(Object wrapper, String imgPath, String diagramType, IFilter filter, Suppression sup) {
        if (sup.isSuppressed(wrapper)) {
            return;
        }
        int type = DiagramImageService.getIntType(diagramType);
        if (type < 0) {
            return;
        }
        this._internal_generateImage(wrapper, imgPath, type, filter, sup, true, true);
    }

    public String generateDiagramImage(final Object wrapper, final String imgPath, final int diagramType, final IFilter filter, final Suppression sup, final boolean realizedDiagram) {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                DiagramImageService.this._internal_generateImage(wrapper, imgPath, diagramType, filter, sup, false, realizedDiagram);
            }
        });
        return imgPath;
    }

    /*
     * Loose catch block
     */
    private void _internal_generateImage(Object wrapper, String imgPath, int type, IFilter filter, Suppression sup, boolean calculateDiagramInfo, boolean realizedDiagram) {
        boolean dirtyFlag;
        AbstractDiagramGraphicalViewer viewer;
        Activity e;
        Image image;
        block47: {
            EditPart diagramEditPart;
            block45: {
                block46: {
                    Object object;
                    block44: {
                        this.exist = true;
                        image = null;
                        Object o = TngUtil.unwrap((Object)wrapper);
                        if (!(o instanceof Activity)) {
                            return;
                        }
                        e = (Activity)o;
                        viewer = null;
                        dirtyFlag = e.eResource().isModified();
                        object = this.canCreateImage(wrapper, imgPath, type, filter, sup);
                        if (!realizedDiagram || object != null) break block44;
                        try {
                            e.eResource().setModified(dirtyFlag);
                            if (viewer != null) {
                                viewer.dispose();
                            }
                            if (image != null) {
                                image.dispose();
                            }
                        }
                        catch (RuntimeException e1) {
                            e1.printStackTrace();
                        }
                        return;
                    }
                    wrapper = object;
                    viewer = this.getDiagramViewer(type, wrapper);
                    if (this.config != null) {
                        viewer.setMethodConfiguration(this.config);
                    }
                    if ((diagramEditPart = viewer.loadDiagram(wrapper, !this.exist, filter, sup)) != null) break block45;
                    if (!debug) break block46;
                    DiagramUIPlugin.getDefault().getLogger().logError("Publishing: DiagramImageService viewer EditPart is null: " + wrapper);
                }
                try {
                    e.eResource().setModified(dirtyFlag);
                    if (viewer != null) {
                        viewer.dispose();
                    }
                    if (image != null) {
                        image.dispose();
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            if (!diagramEditPart.getChildren().isEmpty()) break block47;
            try {
                e.eResource().setModified(dirtyFlag);
                if (viewer != null) {
                    viewer.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
            catch (RuntimeException e1) {
                e1.printStackTrace();
            }
            return;
        }
        try {
            try {
                Diagram d;
                if (calculateDiagramInfo) {
                    this.diagramInfo = viewer.getDiagramInfo();
                }
                if ((image = viewer.createDiagramImage()) != null) {
                    String osName;
                    File f = new File(this.pubDir, imgPath);
                    File parent = f.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    if ((osName = System.getProperty("os.name").toLowerCase()).contains("2008")) {
                        FileOutputStream os = new FileOutputStream(f);
                        ImageLoader loader = new ImageLoader();
                        loader.data = new ImageData[]{image.getImageData()};
                        loader.save((OutputStream)os, 1);
                    } else {
                        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                        ImageWriter writer = iter.next();
                        ImageWriteParam iwp = writer.getDefaultWriteParam();
                        iwp.setCompressionMode(2);
                        iwp.setCompressionQuality(1.0f);
                        FileImageOutputStream output = new FileImageOutputStream(f);
                        writer.setOutput(output);
                        BufferedImage bufferedImage = ImageUtils.convertToAWT(image.getImageData());
                        IIOImage iioImage = new IIOImage(bufferedImage, null, null);
                        writer.write(null, iioImage, iwp);
                        writer.dispose();
                    }
                } else {
                    DiagramUIPlugin.getDefault().getLogger().logError("Failed to create diagram image for" + e);
                }
                if (calculateDiagramInfo && this.diagramInfo != null && !this.diagramInfo.isEmpty()) {
                    this.diagramInfo.setImageFilePath(imgPath);
                }
                {
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!this.exist && (d = this.getDiagram(e, type)) != null) {
                    DiagramHelper.deleteDiagram((Diagram)d, (boolean)false);
                }
            }
            catch (Exception exception) {
                DiagramUIPlugin.getDefault().getLogger().logError("Exception" + e);
                try {
                    e.eResource().setModified(dirtyFlag);
                    if (viewer != null) {
                        viewer.dispose();
                    }
                    if (image != null) {
                        image.dispose();
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                e.eResource().setModified(dirtyFlag);
                if (viewer != null) {
                    viewer.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
            catch (RuntimeException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object canCreateImage(Object wrapper, String imgPath, int type, IFilter filter, Suppression suppression) {
        Object o = TngUtil.unwrap((Object)wrapper);
        if (!(o instanceof Activity)) {
            return null;
        }
        try {
            Iterator iterator;
            Activity e = (Activity)o;
            if (this.hasUserDefinedDiagram(e, imgPath, type)) {
                return null;
            }
            Diagram d = this.getDiagram(e, type);
            boolean bl = this.exist = d != null;
            if (this.isForXMLExport()) {
                if (!this.exist || !this.canPublishDiagram(d, e)) return null;
                return e;
            }
            if (this.exist) {
                if (!this.canPublishDiagram(d, e)) {
                    return null;
                }
                if (type == 0) {
                    if (this.isBreakdownElementsReplaced(e, filter)) {
                        return null;
                    }
                    if (e == wrapper || this.publishADForActivityExtension) return wrapper;
                    return null;
                } else {
                    if (type != 2 || e == wrapper || this.publishUncreatedADD) return wrapper;
                    return null;
                }
            }
            if (type == 1) {
                return null;
            }
            if (type == 0) {
                if (!this.publishADForActivityExtension) {
                    return null;
                }
                if (!e.getBreakdownElements().isEmpty()) {
                    return null;
                }
                if (this.anyChildrenSuppressed(wrapper, filter, suppression)) {
                    return null;
                }
                VariabilityElement calculatedBase = this.checkVariability((VariabilityElement)e, filter, type);
                if (calculatedBase == null) {
                    return null;
                }
                wrapper = calculatedBase;
                e = (Activity)calculatedBase;
                this.exist = true;
            }
            if (this.publishUncreatedADD || type != 2) return wrapper;
            boolean contributorexist = false;
            MethodConfiguration config = null;
            if (filter instanceof ProcessAdapterFactoryFilter) {
                config = ((ProcessAdapterFactoryFilter)filter).getMethodConfiguration();
            }
            if (config == null) {
                return null;
            }
            List list = ConfigurationHelper.getContributors((VariabilityElement)e, (MethodConfiguration)config);
            if (e instanceof Activity && (iterator = list.iterator()) != null) {
                while (iterator.hasNext()) {
                    Diagram dx;
                    Object act = iterator.next();
                    if (act == null || (dx = this.getDiagram((Activity)act, type)) == null) continue;
                    contributorexist = true;
                    break;
                }
            }
            if (contributorexist) return wrapper;
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean canPublishDiagram(Diagram diagram, Activity activity) {
        switch (DiagramHelper.getDiagramType((Diagram)diagram)) {
            case 0: {
                if (!DiagramOptions.isPublishAD((Activity)activity)) break;
                return true;
            }
            case 2: {
                if (!DiagramOptions.isPublishADD((Activity)activity)) break;
                return true;
            }
            case 1: {
                if (!DiagramOptions.isPublishWPDD((Activity)activity)) break;
                return true;
            }
        }
        return false;
    }

    private boolean anyChildrenSuppressed(Object wrapper, IFilter filter, Suppression suppression) {
        BSActivityItemProvider itemProvider;
        ITreeItemContentProvider adapter = this.getAdapter(wrapper, filter);
        boolean oldRolledUp = false;
        if (adapter instanceof BSActivityItemProvider) {
            itemProvider = (BSActivityItemProvider)adapter;
            oldRolledUp = itemProvider.isRolledUp();
            itemProvider.basicSetRolledUp(false);
        } else if (adapter instanceof IBSItemProvider) {
            itemProvider = (IBSItemProvider)adapter;
            oldRolledUp = itemProvider.isRolledUp();
            itemProvider.setRolledUp(false);
        }
        try {
            Object element = TngUtil.unwrap((Object)wrapper);
            for (Object child : adapter.getChildren(element)) {
                if (!suppression.isSuppressed(child)) continue;
                return true;
            }
        }
        finally {
            if (adapter instanceof IBSItemProvider) {
                ((IBSItemProvider)adapter).setRolledUp(oldRolledUp);
            }
        }
        return false;
    }

    private ITreeItemContentProvider getAdapter(Object wrapper, IFilter filter) {
        Object adapter = null;
        adapter = wrapper instanceof BreakdownElementWrapperItemProvider ? (BreakdownElementWrapperItemProvider)wrapper : (ITreeItemContentProvider)this.getAdapterFactory(filter).adapt(wrapper, ITreeItemContentProvider.class);
        return adapter;
    }

    AdapterFactory getAdapterFactory(IFilter filter) {
        ComposedAdapterFactory adapterFactory = null;
        if (filter == null) {
            adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (filter instanceof IAdapterFactoryFilter) {
            adapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)filter).getWBSAdapterFactory();
        }
        return adapterFactory;
    }

    private VariabilityElement checkVariability(VariabilityElement e, IFilter filter, int type) {
        MethodConfiguration config = null;
        if (filter instanceof ProcessAdapterFactoryFilter) {
            config = ((ProcessAdapterFactoryFilter)filter).getMethodConfiguration();
        }
        if (config == null) {
            return null;
        }
        List list = ConfigurationHelper.getContributors((VariabilityElement)e, (MethodConfiguration)config);
        for (Object next : list) {
            if (!(next instanceof Activity) || ((Activity)next).getBreakdownElements().isEmpty()) continue;
            return null;
        }
        VariabilityInfo eInfo = ((ProcessAdapterFactoryFilter)filter).getVariabilityInfo(e);
        List contributors = eInfo.getContributors();
        VariabilityElement ve = e.getVariabilityBasedOnElement();
        if (ve == null) {
            return null;
        }
        Activity replacer = (Activity)ConfigurationHelper.getReplacer((VariabilityElement)ve, (MethodConfiguration)config);
        if (replacer != null) {
            ve = replacer;
            Diagram replacerDiagram = this.getDiagram(replacer, type);
            if (replacerDiagram != null) {
                return replacer;
            }
            return null;
        }
        Diagram baseDiagram = this.getDiagram((Activity)ve, type);
        if (baseDiagram != null) {
            if (BridgeHelper.isSuppressed((View)baseDiagram)) {
                return null;
            }
            VariabilityInfo veInfo = ((ProcessAdapterFactoryFilter)filter).getVariabilityInfo(ve);
            List veContributors = veInfo.getContributors();
            if (contributors.size() != veContributors.size()) {
                for (Object next : contributors) {
                    if (veContributors.contains(next) || ((Activity)next).getBreakdownElements().isEmpty()) continue;
                    return null;
                }
            }
            return ve;
        }
        return this.checkVariability(ve, filter, type);
    }

    public VariabilityElement checkVariability(VariabilityElement e, IFilter filter, int type, boolean checkUDD) {
        MethodConfiguration config = null;
        DiagramInfo uddInfo = null;
        if (filter instanceof ProcessAdapterFactoryFilter) {
            config = ((ProcessAdapterFactoryFilter)filter).getMethodConfiguration();
        }
        if (config == null) {
            return null;
        }
        List list = ConfigurationHelper.getContributors((VariabilityElement)e, (MethodConfiguration)config);
        for (Object next : list) {
            if (!(next instanceof Activity) || ((Activity)next).getBreakdownElements().isEmpty()) continue;
            return null;
        }
        VariabilityInfo eInfo = ((ProcessAdapterFactoryFilter)filter).getVariabilityInfo(e);
        List contributors = eInfo.getContributors();
        VariabilityElement ve = e.getVariabilityBasedOnElement();
        if (ve == null) {
            return null;
        }
        Activity replacer = (Activity)ConfigurationHelper.getReplacer((VariabilityElement)ve, (MethodConfiguration)config);
        if (replacer != null) {
            ve = replacer;
            Diagram replacerDiagram = this.getDiagram(replacer, type);
            if (checkUDD ? (uddInfo = new DiagramInfo(replacer)).canPublishADImage() && uddInfo.getActivityDiagram() != null : replacerDiagram != null) {
                return replacer;
            }
            return null;
        }
        Diagram baseDiagram = null;
        if (checkUDD) {
            uddInfo = new DiagramInfo((Activity)ve);
        } else {
            baseDiagram = this.getDiagram((Activity)ve, type);
        }
        if (baseDiagram != null || uddInfo != null && uddInfo.canPublishADImage() && uddInfo.getActivityDiagram() != null) {
            VariabilityInfo veInfo = ((ProcessAdapterFactoryFilter)filter).getVariabilityInfo(ve);
            List veContributors = veInfo.getContributors();
            if (contributors.size() != veContributors.size()) {
                for (Object next : contributors) {
                    if (veContributors.contains(next) || ((Activity)next).getBreakdownElements().isEmpty()) continue;
                    return null;
                }
            }
            return ve;
        }
        return this.checkVariability(ve, filter, type);
    }

    public void setPublishedUnCreatedADD(boolean flag) {
        this.publishUncreatedADD = flag;
    }

    public void setPublishADForActivityExtension(boolean flag) {
        this.publishADForActivityExtension = flag;
    }

    public Diagram getDiagram(Activity e, int type) {
        DiagramManager dMgr = this.getDiagramManager(e);
        Diagram diagram = null;
        if (dMgr != null) {
            try {
                List list = dMgr.getDiagrams(e, type);
                if (!list.isEmpty()) {
                    diagram = (Diagram)list.get(0);
                }
            }
            catch (Exception ex) {
                DiagramUIPlugin.getDefault().getLogger().logError("Error in getDiagram()" + ex.getMessage());
            }
        }
        return diagram;
    }

    private DiagramManager getDiagramManager(Activity e) {
        DiagramManager mgr = DiagramManager.getInstance((Process)TngUtil.getOwningProcess((BreakdownElement)e), (Object)this);
        this.diagramManagers.add(mgr);
        return mgr;
    }

    public MethodConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(MethodConfiguration config) {
        this.config = config;
    }

    private boolean isBreakdownElementsReplaced(Activity activity, IFilter filter) {
        MethodConfiguration config = null;
        if (filter instanceof IMethodConfigurationProvider) {
            config = ((IMethodConfigurationProvider)filter).getMethodConfiguration();
        }
        if (config == null) {
            return true;
        }
        for (BreakdownElement element : activity.getBreakdownElements()) {
            if (!(element instanceof Activity) || ConfigurationHelper.getReplacer((VariabilityElement)((Activity)element), (MethodConfiguration)config) == null) continue;
            return true;
        }
        return false;
    }

    public AbstractDiagramGraphicalViewer getDiagramViewer(Object wrapper, int type, IFilter filter, Suppression sup) {
        Object o = TngUtil.unwrap((Object)wrapper);
        if (!(o instanceof Activity)) {
            return null;
        }
        Activity cfr_ignored_0 = (Activity)o;
        AbstractDiagramGraphicalViewer viewer = null;
        if (type < 0) {
            return null;
        }
        viewer = this.getDiagramViewer(type, wrapper);
        return viewer;
    }

    public Activity getRealizedForUnmodified(Object wrapper, IFilter filter, Suppression suppression) {
        Activity activity = (Activity)TngUtil.unwrap((Object)wrapper);
        if (activity == null) {
            return null;
        }
        if (!this.publishADForActivityExtension) {
            return null;
        }
        if (!activity.getBreakdownElements().isEmpty()) {
            return null;
        }
        if (this.anyChildrenSuppressed(activity, filter, suppression)) {
            return null;
        }
        VariabilityElement calculatedBase = this.checkVariability((VariabilityElement)activity, filter, 0, true);
        if (calculatedBase == null) {
            return null;
        }
        wrapper = calculatedBase;
        return (Activity)wrapper;
    }

    public void setPubDir(File pubDir) {
        this.pubDir = pubDir;
    }

    private boolean isForXMLExport() {
        return this.forXMLExport;
    }

    public void setForXMLExport(boolean forXMLExport) {
        this.forXMLExport = forXMLExport;
    }
}

