/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ImageUtils {
    public static ImageData applyBlendingSWT(BufferedImage image, Composite compositeToUse, int red, int green, int blue) {
        BufferedImage finalImage = ImageUtils.applyBlending(image, compositeToUse, red, green, blue);
        return ImageUtils.convertToSWT(finalImage);
    }

    public static BufferedImage applyBlending(BufferedImage image, Composite compositeToUse, int red, int green, int blue) {
        if (image == null) {
            return null;
        }
        BufferedImage finalImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = finalImage.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.setColor(new Color(red, green, blue));
        g2d.setComposite(compositeToUse);
        g2d.fillRect(0, 0, finalImage.getWidth(), finalImage.getHeight());
        g2d.dispose();
        return finalImage;
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static final ImageData convertToSWT(BufferedImage awt) {
        int width = awt.getWidth();
        int height = awt.getHeight();
        PixelGrabber grabber = new PixelGrabber(awt, 0, 0, width, height, true);
        ImageData imgdata = null;
        try {
            if (grabber.grabPixels()) {
                DirectColorModel cm = (DirectColorModel)ColorModel.getRGBdefault();
                int[] pixels = (int[])grabber.getPixels();
                PaletteData palette = new PaletteData(cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
                imgdata = new ImageData(width, height, cm.getPixelSize(), palette);
                imgdata.setPixels(0, 0, width * height, pixels, 0);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return imgdata;
    }

    public static double getResizingRatio(BufferedImage image, int desiredWidth, int desiredHeight) {
        double imageWidth = image.getWidth();
        double imageHeight = image.getHeight();
        return ImageUtils.getResizingRatio(imageWidth, imageHeight, desiredWidth, desiredHeight);
    }

    public static double getResizingRatio(double imageWidth, double imageHeight, int desiredWidth, int desiredHeight) {
        double ratio = (double)desiredWidth / imageWidth;
        double newHeight = imageHeight * ratio;
        if (newHeight > (double)desiredHeight) {
            ratio = (double)desiredHeight / imageHeight;
        }
        return ratio;
    }

    public static BufferedImage createSoftClipping(BufferedImage sourceImage, Shape clippingShape) {
        BufferedImage clippedImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        Graphics2D g2d = clippedImage.createGraphics();
        g2d.setComposite(AlphaComposite.Src);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.WHITE);
        g2d.fill(clippingShape);
        g2d.setComposite(AlphaComposite.SrcAtop);
        g2d.drawImage((Image)sourceImage, 0, 0, null);
        g2d.dispose();
        return clippedImage;
    }
}

