/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.viewer;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.ad.edit.parts.ActivityEditPart;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.IDiagramEditorInputProvider;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.diagram.ui.viewer.AbstractDiagramGraphicalViewer;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractDiagramGraphicalViewerEx
extends AbstractDiagramGraphicalViewer {
    protected GraphicalEditPart part = null;
    protected Diagram diagram;
    protected DiagramManager dmgr;
    protected boolean debug = DiagramUIPlugin.getDefault().isDebugging();
    protected MethodConfiguration config = null;

    public AbstractDiagramGraphicalViewerEx(Composite parent, Object wrapper) {
        super(parent, wrapper);
    }

    public EditPart loadDiagram(Object wrapper, boolean needReset, IFilter filter, Suppression sup) {
        IFigure figure;
        Object o;
        EditPart editPart = this.createEditPart(wrapper, filter, sup);
        if (editPart == null) {
            if (this.debug) {
                System.err.println("Editpart is null: " + wrapper);
            }
            return editPart;
        }
        this.graphicalViewer.setContents(editPart);
        DiagramEditPart diagramEditPart = (DiagramEditPart)editPart;
        Resource resource = diagramEditPart.getDiagramView().eResource();
        boolean oldDeliver = resource.eDeliver();
        try {
            if (resource != null) {
                resource.eSetDeliver(false);
            }
            this.refresh(diagramEditPart);
        }
        finally {
            if (resource != null) {
                resource.eSetDeliver(oldDeliver);
            }
        }
        this.parent.pack(true);
        if (editPart != null && this.debug) {
            for (EditPart name : editPart.getChildren()) {
                View view = (View)name.getModel();
                if (!this.debug) continue;
                System.out.println(String.valueOf(view.getType()) + ":" + ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X()) + "," + ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y()));
            }
        }
        if ((o = TngUtil.unwrap((Object)wrapper)) instanceof VariabilityElement && this.getDiagramType() != null && this.getDiagramType().equalsIgnoreCase("ActivityDetail") && TngUtil.hasContributor((VariabilityElement)((VariabilityElement)o))) {
            needReset = true;
        }
        if (needReset) {
            this.cleanUpDiagram();
            this.parent.pack(true);
        }
        if ((figure = this.getFigure()) != null) {
            Rectangle bounds = figure.getBounds();
            if (bounds.x < 0 || bounds.y < 0) {
                if (editPart instanceof ActivityEditPart) {
                    ((ActivityEditPart)editPart).moveFigure(-bounds.x, -bounds.y);
                }
                this.parent.pack(true);
                bounds = figure.getBounds();
            }
        }
        return editPart;
    }

    public DiagramInfo getDiagramInfo() {
        DiagramInfo diagramInfo = null;
        Object element = this.part.getModel();
        if (element instanceof LinkedObject) {
            element = ((LinkedObject)element).getObject();
        }
        if (element instanceof View) {
            if ((element = ((View)element).getElement()) != null && element instanceof EModelElement) {
                element = BridgeHelper.getMethodElement((EModelElement)((EModelElement)element));
            }
            if (element instanceof Node) {
                element = ((Node)element).getLinkedElement();
            }
        }
        if (element instanceof MethodElement) {
            diagramInfo = new DiagramInfo(this.getDiagramType(), (MethodElement)element);
            this.loadDiagramInfo(this.part, diagramInfo);
        }
        return diagramInfo;
    }

    public void createDiagramImage(ImageFileFormat imageFileFormat) {
    }

    protected EditPartFactory createEditPartFactory() {
        return EditPartService.getInstance();
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
        DiagramGraphicalViewer viewer = (DiagramGraphicalViewer)this.getGraphicalViewer();
        DiagramRootEditPart root = (DiagramRootEditPart)EditPartService.getInstance().createRootEditPart(this.getDiagram());
        FreeformLayer extLabelsLayer = new FreeformLayer();
        extLabelsLayer.setLayoutManager((LayoutManager)new DelegatingLayout());
        LayeredPane scalableLayers = (LayeredPane)root.getLayer((Object)"Scalable Layers");
        FreeformLayer scaledFeedbackLayer = new FreeformLayer();
        scaledFeedbackLayer.setEnabled(false);
        scalableLayers.addLayerAfter((Layer)scaledFeedbackLayer, (Object)"Scaled Feedback Layer", (Object)"Decoration Unprintable Layer");
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.createEditPartFactory());
    }

    protected Diagram getDiagram() {
        if (this.diagram == null) {
            EObject e;
            block12: {
                try {
                    Object o;
                    if (this.diagram == null && (o = TngUtil.unwrap((Object)this.wrapper)) instanceof Activity) {
                        Activity act = (Activity)o;
                        this.dmgr = DiagramManager.getInstance((Process)TngUtil.getOwningProcess((BreakdownElement)act), (Object)this);
                        List list = this.dmgr.getDiagrams(act, DiagramImageService.getIntType(this.getDiagramType()));
                        if (!list.isEmpty()) {
                            this.diagram = (Diagram)list.get(0);
                        } else if (this.debug) {
                            System.out.println("Diagram is empty for " + act);
                        }
                    }
                }
                catch (Exception e2) {
                    if (!this.debug) break block12;
                    e2.printStackTrace();
                }
            }
            if (this.diagram == null) {
                if (this.debug) {
                    System.out.println("Creating diagram of  " + this.getDiagramType());
                }
                try {
                    this.diagram = this.dmgr.createDiagram((Activity)TngUtil.unwrap((Object)this.wrapper), DiagramImageService.getIntType(this.getDiagramType()), DiagramImageService.getPreferenceHint(this.getDiagramType()));
                }
                catch (Exception exception) {}
            }
            if (this.diagram != null && (e = this.diagram.getElement()) instanceof Node) {
                ((Node)e).addConsumer((Object)this);
            }
        }
        return this.diagram;
    }

    protected void createGraphicalViewer() {
        this.graphicalViewer = new DiagramGraphicalViewerEx();
        this.graphicalViewer.createControl(this.parent);
        this.configureGraphicalViewer();
    }

    protected void loadDiagramInfo(GraphicalEditPart part, DiagramInfo diagramInfo) {
        List children = part.getChildren();
        for (Object o : children) {
            if (!(o instanceof GraphicalEditPart)) continue;
            part = (GraphicalEditPart)o;
            Object model = part.getModel();
            Object e = model;
            if (e instanceof LinkedObject) {
                e = ((LinkedObject)e).getObject();
            }
            if (e instanceof View) {
                if ((e = ((View)e).getElement()) instanceof Node) {
                    if (e instanceof NodeContainer) {
                        this.loadDiagramInfo((GraphicalEditPart)o, diagramInfo);
                    }
                    e = ((Node)e).getLinkedElement();
                }
                if (e != null && e instanceof EModelElement) {
                    e = BridgeHelper.getMethodElement((EModelElement)((EModelElement)e));
                }
            }
            if (e instanceof DiagramElement || !(e instanceof MethodElement)) continue;
            boolean suppressed = model instanceof NamedNode ? ((NamedNode)model).isSuppressed() : ((MethodElement)e).getSuppressed().booleanValue();
            IFigure f = part.getFigure();
            Rectangle bounds = f.getBounds();
            String altTag = null;
            if (f instanceof WrapLabel) {
                altTag = ((WrapLabel)f).getText();
            }
            e = this.getElementForAddArea((MethodElement)e);
            diagramInfo.addArea((MethodElement)e, bounds.x, bounds.y, bounds.width, bounds.height, altTag, suppressed);
        }
    }

    protected MethodElement getElementForAddArea(MethodElement e) {
        MethodElement e1;
        if (DescriptorPropUtil.useLinkedElementInDiagram && e instanceof Descriptor && (e1 = ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)e))) != null && (e1 = LibraryEditUtil.getInstance().getCalcualtedElement(e1, this.getMethodConfiguration())) != null) {
            return e1;
        }
        return e;
    }

    public void dispose() {
        EObject e;
        super.dispose();
        if (this.dmgr != null) {
            this.dmgr.removeConsumer((Object)this);
        }
        if (this.diagram != null && (e = this.diagram.getElement()) instanceof Node) {
            ((Node)e).removeConsumer((Object)this);
        }
    }

    protected void refresh(DiagramEditPart editPart) {
        block2: {
            try {
                DiagramEditorUtil.refresh((DiagramEditPart)editPart, (IProgressMonitor)new NullProgressMonitor(), (boolean)true);
                DiagramEditorUtil.refreshLabels((DiagramEditPart)editPart);
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                System.out.println("Error diagram refresh while publishing : " + e);
            }
        }
    }

    public void updateDiagramElement(final Diagram model, final MethodElement element, final Suppression sup, final MethodConfiguration configuration, final IFilter filter, IProgressMonitor monitor) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)model);
        AbstractEMFOperation op = new AbstractEMFOperation(domain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                org.eclipse.epf.diagram.model.Diagram d = (org.eclipse.epf.diagram.model.Diagram)model.getElement();
                d.setSuppression(sup);
                if (filter == null && configuration != null) {
                    ProcessConfigurator p = new ProcessConfigurator(AbstractDiagramGraphicalViewerEx.this.config);
                    d.setFilter((IFilter)p);
                } else {
                    d.setFilter(filter);
                }
                d.setLinkedElement(element);
                return Status.OK_STATUS;
            }
        };
        try {
            op.execute(monitor, null);
        }
        catch (ExecutionException e) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        this.config = config;
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }

    protected class DiagramGraphicalViewerEx
    extends DiagramGraphicalViewer
    implements IDiagramEditorInputProvider {
        private DiagramEditorInput input;

        protected DiagramGraphicalViewerEx() {
        }

        public DiagramEditorInput getDiagramEditorInput() {
            if (this.input == null) {
                this.input = new DiagramEditorInput(AbstractDiagramGraphicalViewerEx.this.wrapper, null, DiagramImageService.getIntType(AbstractDiagramGraphicalViewerEx.this.getDiagramType()));
            }
            return this.input;
        }

        public IEditorPart getEditor() {
            return null;
        }
    }
}

