/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.viewer;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.epf.diagram.ad.edit.parts.ActivityPartitionEditPart;
import org.eclipse.epf.diagram.core.bridge.ActivityDiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.ui.viewer.AbstractDiagramGraphicalViewerEx;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Composite;

public class NewActivityDiagramViewer
extends AbstractDiagramGraphicalViewerEx {
    private ActivityDiagramAdapter adapter;

    public NewActivityDiagramViewer(Composite parent, Object act) {
        super(parent, act);
    }

    public void dispose() {
        if (this.adapter != null && this.diagram != null && this.diagram.getElement() != null) {
            this.diagram.getElement().eAdapters().remove((Object)this.adapter);
        }
        super.dispose();
    }

    protected EditPart createEditPart(Object wrapper, IFilter filter, Suppression sup) {
        Activity e = null;
        if (wrapper instanceof ActivityWrapperItemProvider) {
            e = (Activity)TngUtil.unwrap((Object)wrapper);
            this.adapter = new ActivityDiagramAdapter((BreakdownElementWrapperItemProvider)((ActivityWrapperItemProvider)wrapper));
        } else if (wrapper instanceof Activity) {
            e = (Activity)wrapper;
            this.adapter = new ActivityDiagramAdapter(e);
        }
        if (this.adapter != null) {
            try {
                this.adapter.setView((View)this.diagram);
                this.adapter.setFilter(filter);
                this.adapter.setSuppression(sup);
                this.adapter.setEditingDomain((InternalTransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)this.diagram.getElement()));
                this.diagram.getElement().eAdapters().add((Object)this.adapter);
                DiagramEditDomain domain = new DiagramEditDomain(null);
                ((IDiagramGraphicalViewer)this.graphicalViewer).setEditDomain((EditDomain)domain);
                this.part = EditPartService.getInstance().createGraphicEditPart((View)this.diagram);
                if (this.part == null) {
                    DiagramUIPlugin.getDefault().getLogger().logError("Publishing: Activity Diagram EditPart creation failed for : " + e);
                }
                return this.part;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected String getDiagramType() {
        return "Activity";
    }

    protected void loadDiagramInfo(GraphicalEditPart part, DiagramInfo diagramInfo) {
        List children = part.getChildren();
        for (Object o : children) {
            EModelElement ex;
            if (o instanceof ActivityPartitionEditPart) {
                ActivityPartitionEditPart partition = (ActivityPartitionEditPart)o;
                List partitionChildren = partition.getChildren();
                for (Object o1 : partitionChildren) {
                    if (!(o1 instanceof GraphicalEditPart)) continue;
                    this.loadDiagramInfo((GraphicalEditPart)o1, diagramInfo);
                }
                continue;
            }
            if (!(o instanceof GraphicalEditPart)) continue;
            part = (GraphicalEditPart)o;
            Object model = part.getModel();
            Object e = model;
            if (e instanceof View && (ex = (EModelElement)((View)e).getElement()) != null) {
                e = BridgeHelper.getMethodElement((EModelElement)ex);
            }
            if (e instanceof MethodElement) {
                boolean suppressed = model instanceof Node ? BridgeHelper.getMethodElement((EModelElement)((EModelElement)((Node)model).getElement())).getSuppressed().booleanValue() : ((MethodElement)e).getSuppressed().booleanValue();
                IFigure f = part.getFigure();
                Rectangle bounds = f.getBounds();
                String altTag = null;
                if (f instanceof WrapLabel) {
                    altTag = ((WrapLabel)f).getText();
                }
                e = this.getElementForAddArea((MethodElement)e);
                diagramInfo.addArea((MethodElement)e, bounds.x, bounds.y, bounds.width, bounds.height, altTag, suppressed);
                continue;
            }
            diagramInfo.addGraphicalNodes();
        }
    }

    protected void createGraphicalViewer() {
        this.graphicalViewer = new DiagramGraphicalViewer();
        this.graphicalViewer.createControl(this.parent);
        this.configureGraphicalViewer();
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
        DiagramGraphicalViewer viewer = (DiagramGraphicalViewer)this.getGraphicalViewer();
        DiagramRootEditPart root = (DiagramRootEditPart)EditPartService.getInstance().createRootEditPart(this.getDiagram());
        LayeredPane cfr_ignored_0 = (LayeredPane)root.getLayer((Object)"Printable Layers");
        FreeformLayer extLabelsLayer = new FreeformLayer();
        extLabelsLayer.setLayoutManager((LayoutManager)new DelegatingLayout());
        LayeredPane scalableLayers = (LayeredPane)root.getLayer((Object)"Scalable Layers");
        FreeformLayer scaledFeedbackLayer = new FreeformLayer();
        scaledFeedbackLayer.setEnabled(false);
        scalableLayers.addLayerAfter((Layer)scaledFeedbackLayer, (Object)"Scaled Feedback Layer", (Object)"Decoration Unprintable Layer");
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.createEditPartFactory());
    }
}

