/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.wpdd.edit.policies.DiagramBaseItemSemanticEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class LinkReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public LinkReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Link)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Node) || !(this.newEnd instanceof Node)) {
            return false;
        }
        Node target = this.getLink().getTarget();
        if (!(this.getLink().eContainer() instanceof Node)) {
            return false;
        }
        Node container = (Node)this.getLink().eContainer();
        return DiagramBaseItemSemanticEditPolicy.LinkConstraints.canExistLink_3001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Node) || !(this.newEnd instanceof Node)) {
            return false;
        }
        Node source = this.getLink().getSource();
        if (!(this.getLink().eContainer() instanceof Node)) {
            return false;
        }
        Node container = (Node)this.getLink().eContainer();
        return DiagramBaseItemSemanticEditPolicy.LinkConstraints.canExistLink_3001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Link getLink() {
        return (Link)this.getElementToEdit();
    }

    protected Node getOldSource() {
        return (Node)this.oldEnd;
    }

    protected Node getNewSource() {
        return (Node)this.newEnd;
    }

    protected Node getOldTarget() {
        return (Node)this.oldEnd;
    }

    protected Node getNewTarget() {
        return (Node)this.newEnd;
    }
}

