/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.wpdd.part.DiagramCreationWizardPage;
import org.eclipse.epf.diagram.wpdd.part.DiagramDiagramEditorUtil;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DiagramCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected DiagramCreationWizardPage diagramModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void addPages() {
        this.diagramModelFilePage = new DiagramCreationWizardPage("DiagramModelFile", this.getSelection(), "wpdd");
        this.diagramModelFilePage.setTitle("Create WPDD Diagram");
        this.diagramModelFilePage.setDescription("Select file that will contain diagram and domain models.");
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                DiagramCreationWizard.this.diagram = DiagramDiagramEditorUtil.createDiagram(DiagramCreationWizard.this.diagramModelFilePage.getURI(), monitor);
                if (DiagramCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && DiagramCreationWizard.this.diagram != null) {
                    try {
                        DiagramDiagramEditorUtil.openDiagram(DiagramCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)DiagramCreationWizard.this.getContainer().getShell(), (String)"Error opening diagram editor", null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Creation Problems", null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                WPDDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("New WPDD Diagram");
        this.setDefaultPageImageDescriptor(WPDDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewModelWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }
}

