/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.WorkProductNode;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(WPDDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("WPDD".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return DiagramVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                WPDDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return DiagramVisualIDRegistry.getDiagramVisualID(domainElement, domainElementMetaclass);
    }

    private static int getDiagramVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (ModelPackage.eINSTANCE.getWorkProductDependencyDiagram().isSuperTypeOf(domainElementMetaclass) && DiagramVisualIDRegistry.isDiagramWorkProductDependencyDiagram_79((WorkProductDependencyDiagram)domainElement)) {
            return 79;
        }
        return DiagramVisualIDRegistry.getUnrecognizedDiagramID(domainElement);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return DiagramVisualIDRegistry.getNodeVisualID(containerView, domainElement, domainElementMetaclass, null);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement, EClass domainElementMetaclass, String semanticHint) {
        int containerVisualID;
        String containerModelID = DiagramVisualIDRegistry.getModelID(containerView);
        if (!"WPDD".equals(containerModelID)) {
            return -1;
        }
        if ("WPDD".equals(containerModelID)) {
            containerVisualID = DiagramVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return -1;
        }
        int nodeVisualID = semanticHint != null ? DiagramVisualIDRegistry.getVisualID(semanticHint) : -1;
        switch (containerVisualID) {
            case 1001: {
                if (4001 == nodeVisualID) {
                    return 4001;
                }
                return DiagramVisualIDRegistry.getUnrecognizedWorkProductNode_1001ChildNodeID(domainElement, semanticHint);
            }
            case 79: {
                if ((semanticHint == null || 1001 == nodeVisualID) && ModelPackage.eINSTANCE.getWorkProductNode().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isNodeWorkProductNode_1001((WorkProductNode)domainElement))) {
                    return 1001;
                }
                return DiagramVisualIDRegistry.getUnrecognizedWorkProductDependencyDiagram_79ChildNodeID(domainElement, semanticHint);
            }
            case 3001: {
                if (4002 == nodeVisualID) {
                    return 4002;
                }
                return DiagramVisualIDRegistry.getUnrecognizedLink_3001LinkLabelID(semanticHint);
            }
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return DiagramVisualIDRegistry.getLinkWithClassVisualID(domainElement, domainElementMetaclass);
    }

    public static int getLinkWithClassVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (ModelPackage.eINSTANCE.getLink().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || DiagramVisualIDRegistry.isLinkWithClassLink_3001((Link)domainElement))) {
            return 3001;
        }
        return DiagramVisualIDRegistry.getUnrecognizedLinkWithClassID(domainElement);
    }

    private static boolean isDiagramWorkProductDependencyDiagram_79(WorkProductDependencyDiagram element) {
        return true;
    }

    private static int getUnrecognizedDiagramID(EObject domainElement) {
        return -1;
    }

    private static boolean isNodeWorkProductNode_1001(WorkProductNode element) {
        return true;
    }

    private static int getUnrecognizedWorkProductNode_1001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedWorkProductDependencyDiagram_79ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLink_3001LinkLabelID(String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkWithClassID(EObject domainElement) {
        return -1;
    }

    private static boolean isLinkWithClassLink_3001(Link element) {
        return true;
    }
}

