/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.wpdd.part.DiagramVisualIDRegistry;
import org.eclipse.epf.diagram.wpdd.providers.DiagramElementTypes;
import org.eclipse.epf.diagram.wpdd.view.factories.LinkNameViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.LinkViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.WorkProductDependencyDiagramViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.WorkProductNodeNameViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.WorkProductNodeViewFactory;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramViewProvider
extends AbstractViewProvider {
    protected Class getDiagramViewClass(IAdaptable semanticAdapter, String diagramKind) {
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        if ("WPDD".equals(diagramKind) && DiagramVisualIDRegistry.getDiagramVisualID(semanticElement) != -1) {
            return WorkProductDependencyDiagramViewFactory.class;
        }
        return null;
    }

    protected Class getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        if (containerView == null) {
            return null;
        }
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        if (elementType != null && !DiagramElementTypes.isKnownElementType(elementType)) {
            return null;
        }
        EClass semanticType = this.getSemanticEClass(semanticAdapter);
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        int nodeVID = DiagramVisualIDRegistry.getNodeVisualID(containerView, semanticElement, semanticType, semanticHint);
        switch (nodeVID) {
            case 1001: {
                return WorkProductNodeViewFactory.class;
            }
            case 4001: {
                return WorkProductNodeNameViewFactory.class;
            }
            case 4002: {
                return LinkNameViewFactory.class;
            }
        }
        return null;
    }

    protected Class getEdgeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        if (elementType != null && !DiagramElementTypes.isKnownElementType(elementType)) {
            return null;
        }
        EClass semanticType = this.getSemanticEClass(semanticAdapter);
        if (semanticType == null) {
            return null;
        }
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        int linkVID = DiagramVisualIDRegistry.getLinkWithClassVisualID(semanticElement, semanticType);
        switch (linkVID) {
            case 3001: {
                return LinkViewFactory.class;
            }
        }
        return this.getUnrecognizedConnectorViewClass(semanticAdapter, containerView, semanticHint);
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    private Class getUnrecognizedConnectorViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        return null;
    }
}

