/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.dataexchange.util.IResourceHandler;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.export.services.DiagramHandler;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.services.ExportResourceHandler;
import org.eclipse.epf.export.xml.services.ExportXMLData;
import org.eclipse.epf.export.xml.services.ExportXMLLogger;
import org.eclipse.epf.export.xml.services.XMLLibrary;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.MigrationUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.ecore.IModelObject;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.xml.uma.BreakdownElement;
import org.eclipse.epf.xml.uma.ContentCategoryPackage;
import org.eclipse.epf.xml.uma.RoleDescriptor;
import org.eclipse.epf.xml.uma.UmaPackage;
import org.eclipse.epf.xml.uma.WorkOrder;
import org.eclipse.epf.xml.uma.WorkProductDescriptor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportXMLService {
    protected ExportXMLData data;
    private boolean debug = ExportXMLPlugin.getDefault().isDebugging();
    private XMLLibrary xmlLib;
    private List discardedElements = new ArrayList();
    ExportXMLLogger logger = null;
    private Map umaIdToXmlIdMap = new HashMap();
    private DiagramHandler diagramHandler;
    private Map<String, TaskDescriptor> tdMap;
    private Set<org.eclipse.epf.uma.WorkOrder> successors;
    private List processedElements = new ArrayList();

    public ExportXMLService(ExportXMLData data) {
        this.data = data;
        this.logger = new ExportXMLLogger(new File(this.data.xmlFile).getParentFile());
    }

    public static ExportXMLService newInstance(ExportXMLData data) {
        Object obj = ExtensionHelper.create(ExportXMLService.class, (Object)data);
        if (obj instanceof ExportXMLService) {
            return (ExportXMLService)obj;
        }
        return new ExportXMLService(data);
    }

    public File getLogPath() {
        return this.logger.getLogPath();
    }

    public void dispose() {
        this.logger.dispose();
    }

    public void doExport(IProgressMonitor monitor) {
        try {
            ExportResourceHandler handler = new ExportResourceHandler(new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()), new File(this.data.getXMLFile()).getParentFile());
            ContentProcessor contentProc = new ContentProcessor((IResourceHandler)handler, (ILogger)this.logger);
            this.diagramHandler = new DiagramHandler(new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()), new File(this.data.getXMLFile()).getParentFile()){

                public void visitElementMap(int passId) {
                    if (passId != 0) {
                        return;
                    }
                    Map map = this.getElementMap();
                    for (DiagramHandler.MapEntryValue value : map.values()) {
                        IModelObject xmlObj;
                        if (value.targetFile == null || value.sourceFile == null || !((xmlObj = ExportXMLService.this.getXmlObject(value.element)) instanceof org.eclipse.epf.xml.uma.Process)) continue;
                        org.eclipse.epf.xml.uma.Process proc = (org.eclipse.epf.xml.uma.Process)xmlObj;
                        String uri = value.sourceFile.getAbsolutePath();
                        String srcRootFolderPath = this.getRoot(value.element).getAbsolutePath();
                        int ix = srcRootFolderPath.length();
                        uri = uri.substring(ix + 1);
                        uri = URI.createFileURI((String)uri).toString();
                        proc.setDiagramURI(uri);
                    }
                }

                public void execute() {
                    super.execute();
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            this.exportDiagramImageFiles();
                        }
                    });
                }

                private void exportDiagramImageFiles() {
                    LibraryService.getInstance().getCurrentMethodLibraryLocation();
                    DiagramImageService diagramService = new DiagramImageService(null);
                    diagramService.setForXMLExport(true);
                    try {
                        try {
                            Map map = this.getElementMap();
                            for (DiagramHandler.MapEntryValue value : map.values()) {
                                ElementLayoutManager layoutMgr;
                                Process proc = (Process)value.element;
                                MethodConfiguration config = proc.getDefaultContext();
                                if (config == null && (config = ProcessScopeUtil.getInstance().loadScope(proc)) == null) continue;
                                diagramService.setConfig(config);
                                IConfigurationManager mgr = LibraryService.getInstance().getConfigurationManager(config);
                                if (mgr == null || (layoutMgr = mgr.getElementLayoutManager()) == null) continue;
                                IFilter filter = layoutMgr.getDiagramAdapterFactory().getFilter();
                                File diagramXmiFile = value.targetFile;
                                if (diagramXmiFile == null || !diagramXmiFile.exists()) continue;
                                diagramService.setPubDir(diagramXmiFile.getParentFile());
                                Map activities = MigrationUtil.getActivities((Process)proc, (boolean)true);
                                for (Activity act : activities.values()) {
                                    String[] types = new String[]{"Activity", "ActivityDetail", "WPDependency"};
                                    int i = 0;
                                    while (i < types.length) {
                                        block11: {
                                            String imagePath = ResourceHelper.getXmlExportedDiagramImageFileName((MethodElement)act, (String)types[i], (String)".jpeg");
                                            try {
                                                diagramService.saveDiagram((Object)act, imagePath, types[i], filter, Suppression.getSuppression((Process)proc));
                                            }
                                            catch (Exception e) {
                                                if (!ExportXMLService.this.debug) break block11;
                                                ExportXMLService.this.logger.logError(NLS.bind((String)ExportXMLResources.exportXMLService_error, (Object)e.getMessage()), e);
                                            }
                                        }
                                        ++i;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ExportXMLService.this.debug) {
                                ExportXMLService.this.logger.logError(NLS.bind((String)ExportXMLResources.exportXMLService_error, (Object)e.getMessage()), e);
                            }
                            diagramService.dispose();
                        }
                    }
                    finally {
                        diagramService.dispose();
                    }
                }
            };
            MethodLibrary src = LibraryService.getInstance().getCurrentMethodLibrary();
            this.xmlLib = new XMLLibrary(contentProc, (ILogger)this.logger, this.data.getXMLFile());
            this.xmlLib.createLibrary(src.getGuid(), src.getName());
            IModelObject target = this.xmlLib.getRoot();
            this.creatEDataObjectTree((MethodElement)src, target);
            this.iteratEDataObject((MethodElement)src);
            this.handleSuccessors();
            this.xmlLib.fixLibraryForExport();
            this.xmlLib.fixTaskDescriptorsForExport(this.tdMap);
            this.diagramHandler.visitElementMap(0);
            if (this.data.exportType == 2) {
                this.xmlLib.storeExtraInfo(src.getMethodPlugins());
            }
            this.xmlLib.save();
            this.diagramHandler.execute();
        }
        catch (Exception e) {
            this.logger.logError(NLS.bind((String)ExportXMLResources.exportXMLService_error, (Object)e.getMessage()), e);
        }
    }

    private boolean isPluginSelected(MethodPlugin plugin) {
        if (this.data.exportType == 1) {
            return true;
        }
        if (this.data.exportType == 2) {
            return this.data.selectedPlugins != null && this.data.selectedPlugins.contains(plugin);
        }
        if (this.data.exportType == 3) {
            return true;
        }
        return true;
    }

    private boolean isConfigExcluded(MethodConfiguration config) {
        if (this.data.exportType == 2) {
            return this.data.associatedConfigs == null || !this.data.associatedConfigs.contains(config.getGuid());
        }
        return false;
    }

    private void creatEDataObjectTree(MethodElement srcObj, IModelObject targetObj) {
        if (srcObj instanceof MethodPlugin) {
            MethodPlugin plugin = (MethodPlugin)srcObj;
            if (!this.isPluginSelected(plugin)) {
                return;
            }
            this.discardedElements.addAll(TngUtil.getAllSystemPackages((MethodPlugin)plugin));
            List topmostUserPackages = this.getTopmostUserPackage(plugin);
            List categoryPkgs = TngUtil.getContentCategoryPackages((MethodPlugin)plugin);
            ContentCategoryPackage xmlPkg = (ContentCategoryPackage)this.xmlLib.getContentCategoryPackage(plugin.getGuid());
            String contentCategoryPackageId = xmlPkg.getId();
            for (MethodPackage pkg : topmostUserPackages) {
                if (categoryPkgs.contains(pkg)) {
                    this.setIdMapping(pkg.getGuid(), contentCategoryPackageId);
                    this.creatEDataObjectTree((MethodElement)pkg, (IModelObject)xmlPkg);
                    continue;
                }
                this.creatEDataObjectTree((MethodElement)pkg, targetObj);
            }
        } else {
            for (Object nextObj : srcObj.eContents()) {
                MethodElement child;
                MethodElement methodElement = child = nextObj instanceof MethodElement ? (MethodElement)nextObj : null;
                if (child == null) continue;
                if (child instanceof org.eclipse.epf.uma.WorkOrder && srcObj instanceof MethodPackage) {
                    org.eclipse.epf.uma.WorkOrder workOrder = (org.eclipse.epf.uma.WorkOrder)child;
                    MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)workOrder, (String)"successor");
                    if (prop == null) continue;
                    this.getSuccessors().add(workOrder);
                    continue;
                }
                if (child instanceof MethodPlugin && !this.isPluginSelected((MethodPlugin)child) || child instanceof MethodConfiguration && this.isConfigExcluded((MethodConfiguration)child) || this.isDiscarded(child)) continue;
                this.createXmlObject(child, targetObj);
            }
        }
    }

    private void setIdMapping(String umaId, String xmlId) {
        if (!this.umaIdToXmlIdMap.containsKey(umaId)) {
            this.umaIdToXmlIdMap.put(umaId, xmlId);
        }
    }

    private String getXmlId(String umaId) {
        if (this.umaIdToXmlIdMap.containsKey(umaId)) {
            return (String)this.umaIdToXmlIdMap.get(umaId);
        }
        return umaId;
    }

    private boolean isDiscarded(Object o) {
        if (o instanceof Diagram) {
            return true;
        }
        return this.discardedElements.contains(o);
    }

    private IModelObject getXmlObject(MethodElement srcObj) {
        String id = srcObj.getGuid();
        if (this.umaIdToXmlIdMap.containsKey(id)) {
            id = (String)this.umaIdToXmlIdMap.get(id);
        }
        return this.xmlLib.getElement(id);
    }

    private void createXmlObject(MethodElement umaElement, IModelObject targetContainer) {
        EReference feature = umaElement.eContainmentFeature();
        this.createXmlObject(umaElement, targetContainer, feature.getName());
    }

    private void createXmlObject(MethodElement umaElement, IModelObject targetContainer, String containmentFeature) {
        try {
            List steps;
            TaskDescriptor td;
            if (umaElement == null) {
                return;
            }
            String elementType = umaElement.getType().getName();
            IModelObject xmlElement = this.xmlLib.createElement(targetContainer, containmentFeature, umaElement.eClass().getName(), elementType, umaElement.getGuid());
            if (umaElement instanceof TaskDescriptor && (td = (TaskDescriptor)umaElement).getTask() != null && (steps = td.getSelectedSteps()) != null && !steps.isEmpty()) {
                if (this.tdMap == null) {
                    this.tdMap = new HashMap<String, TaskDescriptor>();
                }
                this.tdMap.put(td.getGuid(), td);
            }
            if (xmlElement != null) {
                if (umaElement instanceof org.eclipse.epf.uma.WorkOrder && xmlElement instanceof WorkOrder) {
                    this.xmlLib.getSuccessOrWorkOrderMap().put((WorkOrder)xmlElement, (org.eclipse.epf.uma.WorkOrder)umaElement);
                }
                this.creatEDataObjectTree(umaElement, xmlElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void iteratEDataObject(MethodElement srcObj) {
        Scope scope = null;
        Process proc = null;
        try {
            if (srcObj instanceof Process) {
                proc = (Process)srcObj;
                scope = ProcessScopeUtil.getInstance().getScope(proc);
                if (scope != null) {
                    this.setScope(proc, null);
                }
            }
            this.iteratEDataObject_(srcObj);
        }
        finally {
            if (scope != null && proc != null) {
                this.setScope(proc, scope);
            }
        }
    }

    private void setScope(Process proc, Scope scope) {
        boolean oldDeliver = proc.eDeliver();
        try {
            proc.eSetDeliver(false);
            proc.setDefaultContext((MethodConfiguration)scope);
            proc.getValidContext().clear();
            if (scope != null) {
                proc.getValidContext().add(scope);
            }
        }
        finally {
            proc.eSetDeliver(oldDeliver);
        }
    }

    private void iteratEDataObject_(MethodElement srcObj) {
        MethodPlugin plugin;
        this.diagramHandler.registerElement(srcObj, true);
        if (srcObj instanceof MethodPlugin && !this.isPluginSelected(plugin = (MethodPlugin)srcObj)) {
            return;
        }
        if (this.isProcessed(srcObj.getGuid())) {
            return;
        }
        this.setProcessed(srcObj.getGuid());
        IModelObject targetObj = this.getXmlObject(srcObj);
        if (targetObj == null) {
            if (srcObj instanceof MethodPackage) {
                Iterator it = ((MethodPackage)srcObj).getChildPackages().iterator();
                while (it.hasNext()) {
                    this.iteratEDataObject((MethodElement)it.next());
                }
            }
            return;
        }
        this.handleDescriptorExtraReferences(srcObj, targetObj);
        EClass eClass = srcObj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object value = srcObj.eGet(feature);
            try {
                if (value instanceof List && !feature.getName().equals("methodElementProperty")) {
                    for (MethodElement src_value : (List)value) {
                        IModelObject workOrder;
                        if (src_value instanceof org.eclipse.epf.uma.WorkOrder && (workOrder = this.getXmlObject(src_value)) == null) {
                            this.createXmlObject(src_value, targetObj, feature.getName());
                        }
                        String xmlId = this.getXmlId(src_value.getGuid());
                        this.xmlLib.setReferenceValue(targetObj, feature.getName(), xmlId, src_value.getType());
                        this.iteratEDataObject(src_value);
                    }
                    continue;
                }
                if (value instanceof MethodElement) {
                    MethodElement src_value = (MethodElement)value;
                    if (src_value.eContainer() == null) continue;
                    String xmlId = this.getXmlId(src_value.getGuid());
                    this.xmlLib.setReferenceValue(targetObj, feature.getName(), xmlId, src_value.getType());
                    this.iteratEDataObject(src_value);
                    continue;
                }
                if (this.isDiscarded(srcObj)) continue;
                if (value instanceof WorkOrderType) {
                    value = ((WorkOrderType)value).getName();
                }
                this.xmlLib.setAtributeFeatureValue(targetObj, feature.getName(), value);
            }
            catch (Exception e) {
                String msg = NLS.bind((String)ExportXMLResources.exportXMLService_feature_error, (Object)LibraryUtil.getTypeName((MethodElement)srcObj), (Object)feature.getName());
                this.logger.logError(msg, e);
            }
        }
    }

    private boolean isProcessed(String guid) {
        return this.processedElements.contains(guid);
    }

    private void setProcessed(String guid) {
        if (!this.processedElements.contains(guid)) {
            this.processedElements.add(guid);
        }
    }

    private List getTopmostUserPackage(MethodPlugin plugin) {
        MethodPackage pkg_core_content = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        MethodPackage pkg_custom_categories = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        MethodPackage pkg_disciplines = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
        MethodPackage pkg_domains = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.domainPath);
        MethodPackage pkg_rolesets = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.roleSetPath);
        MethodPackage pkg_tools = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.toolPath);
        MethodPackage pkg_wptypes = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.workProductTypePath);
        MethodPackage pkg_cp = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
        MethodPackage pkg_dp = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
        MethodPackage pkg_proc_contribution = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.processContributionPath);
        ArrayList<MethodPackage> pkgs = new ArrayList<MethodPackage>();
        pkgs.add(pkg_core_content);
        pkgs.add(pkg_custom_categories);
        pkgs.add(pkg_disciplines);
        pkgs.add(pkg_domains);
        pkgs.add(pkg_rolesets);
        pkgs.add(pkg_tools);
        pkgs.add(pkg_wptypes);
        pkgs.add(pkg_cp);
        pkgs.add(pkg_dp);
        if (pkg_proc_contribution != null) {
            pkgs.add(pkg_proc_contribution);
        }
        return pkgs;
    }

    public ExportXMLLogger getLogger() {
        return this.logger;
    }

    private Set<org.eclipse.epf.uma.WorkOrder> getSuccessors() {
        if (this.successors == null) {
            this.successors = new HashSet<org.eclipse.epf.uma.WorkOrder>();
        }
        return this.successors;
    }

    private void handleSuccessors() {
        if (this.getSuccessors() == null) {
            return;
        }
        String fname = "linkToPredecessor";
        for (org.eclipse.epf.uma.WorkOrder srcWorkOrder : this.getSuccessors()) {
            String xmlId;
            IModelObject targetObj;
            WorkBreakdownElement wbe = srcWorkOrder.getPred();
            if (wbe == null || (targetObj = this.getXmlObject((MethodElement)wbe)) == null) continue;
            IModelObject tgtWorkOrder = this.getXmlObject((MethodElement)srcWorkOrder);
            if (tgtWorkOrder == null) {
                this.createXmlObject((MethodElement)srcWorkOrder, targetObj, fname);
            }
            if ((xmlId = this.getXmlId(srcWorkOrder.getGuid())) == null) continue;
            try {
                this.xmlLib.setReferenceValue(targetObj, fname, xmlId, srcWorkOrder.getType());
            }
            catch (Exception e) {
                String msg = NLS.bind((String)ExportXMLResources.exportXMLService_feature_error, (Object)LibraryUtil.getTypeName((MethodElement)wbe), (Object)fname);
                this.logger.logError(msg, e);
            }
        }
    }

    private void handleDescriptorExtraReferences(MethodElement srcObj, IModelObject targetObj) {
        try {
            this.handleDescriptorExtraReferences_(srcObj, targetObj);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private void handleDescriptorExtraReferences_(MethodElement srcObj, IModelObject targetObj) {
        boolean ok;
        if (!(srcObj instanceof Descriptor)) {
            return;
        }
        boolean bl = ok = targetObj instanceof RoleDescriptor || targetObj instanceof WorkProductDescriptor || targetObj instanceof org.eclipse.epf.xml.uma.TaskDescriptor;
        if (!ok) {
            return;
        }
        Descriptor srcDes = (Descriptor)srcObj;
        BreakdownElement tgtDes = (BreakdownElement)targetObj;
        List refList = LibraryEditUtil.getInstance().getExcludeRefList(srcDes);
        for (EReference ref : refList) {
            this.handleExtraRef(srcDes, tgtDes, ref);
        }
        this.handleExtraRef(srcDes, tgtDes, org.eclipse.epf.uma.UmaPackage.eINSTANCE.getDescriptor_GuidanceExclude());
        this.handleExtraRef(srcDes, tgtDes, org.eclipse.epf.uma.UmaPackage.eINSTANCE.getDescriptor_GuidanceAdditional());
    }

    private void handleExtraRef(Descriptor srcDes, BreakdownElement tgtDes, EReference ref) {
        UmaPackage xmlUp = UmaPackage.eINSTANCE;
        EClass mepClass = xmlUp.getMethodElementProperty();
        List refValueList = (List)srcDes.eGet((EStructuralFeature)ref);
        if (refValueList != null && !refValueList.isEmpty()) {
            EList xmlMepList = tgtDes.getMethodElementProperty();
            org.eclipse.epf.xml.uma.MethodElementProperty xmlMep = (org.eclipse.epf.xml.uma.MethodElementProperty)EcoreUtil.create((EClass)mepClass);
            xmlMep.setName("XML_" + ref.getName());
            String value = "";
            int i = 0;
            while (i < refValueList.size()) {
                MethodElement elem = (MethodElement)refValueList.get(i);
                if (value.length() > 0) {
                    value = String.valueOf(value) + "/";
                }
                value = String.valueOf(value) + elem.getGuid();
                ++i;
            }
            xmlMep.setValue(value);
            xmlMepList.add(xmlMep);
        }
    }
}

