/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.wizards;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.services.ConfigurationExportService;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.preferences.ExportXMLPreferences;
import org.eclipse.epf.export.xml.services.ExportXMLData;
import org.eclipse.epf.export.xml.services.ExportXMLService;
import org.eclipse.epf.export.xml.wizards.SelectConfigPage;
import org.eclipse.epf.export.xml.wizards.SelectExportTypePage;
import org.eclipse.epf.export.xml.wizards.SelectPluginPage;
import org.eclipse.epf.export.xml.wizards.SelectXMLFilePage;
import org.eclipse.epf.export.xml.wizards.ViewExportSummaryPage;
import org.eclipse.epf.export.xml.wizards.ViewPluginInfoPage;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportXMLWizard
extends Wizard
implements IExportWizard {
    private SelectExportTypePage selectExportTypePage;
    protected SelectPluginPage selectPluginPage;
    protected ViewPluginInfoPage viewPluginInfoPage;
    protected ViewExportSummaryPage viewExportSummaryPage;
    protected SelectConfigPage selectConfigPage;
    protected SelectXMLFilePage selectXMLFilePage;
    protected ExportXMLData xmlData = new ExportXMLData();
    protected PluginExportData pluginData = new PluginExportData();
    protected ConfigurationExportData configData = new ConfigurationExportData();
    private String currLibPathToResume;
    private File tempExportFolder;

    public ExportXMLWizard() {
        this.setWindowTitle(ExportXMLResources.exportXMLWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.selectExportTypePage = new SelectExportTypePage();
        this.selectPluginPage = new SelectPluginPage(this.pluginData);
        this.viewPluginInfoPage = new ViewPluginInfoPage(this.pluginData);
        this.viewExportSummaryPage = new ViewExportSummaryPage(this.pluginData);
        this.selectConfigPage = new SelectConfigPage(this.configData);
        this.selectXMLFilePage = new SelectXMLFilePage();
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ExportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ExportXML.gif"));
        this.addPage((IWizardPage)this.selectExportTypePage);
        this.addPage((IWizardPage)this.selectPluginPage);
        this.addPage((IWizardPage)this.viewPluginInfoPage);
        this.addPage((IWizardPage)this.viewExportSummaryPage);
        this.addPage((IWizardPage)this.selectConfigPage);
        this.addPage((IWizardPage)this.selectXMLFilePage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(ExportXMLPlugin.getDefault().getSharedImage("full/obj16/XMLFile.gif"));
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.selectXMLFilePage && this.selectXMLFilePage.isPageComplete();
    }

    public boolean performFinish() {
        boolean ok;
        String xmlFilePath = this.selectXMLFilePage.getPath();
        File xmlFile = new File(xmlFilePath);
        File folder = xmlFile.getParentFile();
        String folderPath = folder.getAbsolutePath();
        if (xmlFile.exists() ? !(ok = ExportXMLPlugin.getDefault().getMsgDialog().displayPrompt(ExportXMLResources.exportXMLWizard_title, ExportXMLResources.bind((String)ExportXMLResources.overwriteText_msg1, (Object[])new String[]{xmlFilePath, folderPath}))) : folder.exists() && folder.listFiles() != null && folder.listFiles().length > 0 && !(ok = ExportXMLPlugin.getDefault().getMsgDialog().displayPrompt(ExportXMLResources.exportXMLWizard_title, ExportXMLResources.bind((String)ExportXMLResources.overwriteText_msg, (Object[])new String[]{folderPath})))) {
            return false;
        }
        try {
            if (folder.exists()) {
                FileUtil.deleteAllFiles((String)folderPath);
            }
        }
        catch (Throwable e) {
            ExportXMLPlugin.getDefault().getLogger().logError(e);
        }
        final boolean exportConfig = this.xmlData.getExportType() == 3;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                service = null;
                try {
                    monitor.beginTask(ExportXMLResources.exportingXML_text, -1);
                    ExportXMLWizard.this.xmlData.setXMLFile(ExportXMLWizard.this.selectXMLFilePage.getPath());
                    service = ExportXMLService.newInstance(ExportXMLWizard.this.xmlData);
                    if (!exportConfig) ** GOTO lbl11
                    if (!ExportXMLWizard.access$1(ExportXMLWizard.this, monitor)) {
                        return;
                    }
                    try {
                        monitor.setTaskName(ExportXMLResources.exportingXML_text);
lbl11:
                        // 2 sources

                        service.doExport(monitor);
                        ExportXMLPreferences.setExportType(ExportXMLWizard.this.xmlData.getExportType());
                        ExportXMLPreferences.setXMLFile(ExportXMLWizard.this.xmlData.getXMLFile());
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    try {
                        if (exportConfig) {
                            ExportXMLWizard.access$0(ExportXMLWizard.this, monitor);
                        }
                    }
                    finally {
                        monitor.done();
                        if (service != null) {
                            service.dispose();
                        }
                    }
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExportXMLPlugin.getDefault().getMsgDialog().displayError(ExportXMLResources.exportXMLWizard_title, NLS.bind((String)ExportXMLResources.exportXMLWizard_error, (Object)realException.getMessage()), realException);
            return false;
        }
        String msg = ExportXMLResources.exportXMLWizard_reviewLog;
        MsgBox.prompt((String)msg, (int)32);
        return true;
    }

    private boolean preExportConfig(IProgressMonitor monitor) {
        String userHome = System.getProperty("user.home");
        String desLibFolderPath = String.valueOf(userHome) + File.separator + "EPF" + File.separator + "Export" + File.separator + Long.toHexString(Calendar.getInstance().getTimeInMillis()) + File.separator;
        this.tempExportFolder = new File(desLibFolderPath);
        MethodLibrary currLib = LibraryService.getInstance().getCurrentMethodLibrary();
        this.currLibPathToResume = currLib.eResource().getURI().toFileString();
        List configs = this.xmlData.getSelectedConfigs();
        if (configs == null || configs.isEmpty()) {
            return false;
        }
        MethodConfiguration config = (MethodConfiguration)configs.get(0);
        ConfigurationExportData data = new ConfigurationExportData();
        data.llData.setLibName(currLib.getName());
        data.llData.setParentFolder(this.tempExportFolder.getAbsolutePath());
        data.exportOneConfig = true;
        data.exportConfigSpecs = false;
        data.selectedConfigs = new ArrayList();
        data.selectedConfigs.add(config);
        Exception[] ex = new Exception[]{null};
        try {
            monitor.setTaskName(ExportXMLResources.export_config_to_temp_location);
            ConfigurationExportService.newInstance((ConfigurationExportData)data).run((IProgressMonitor)new NullProgressMonitor());
            monitor.setTaskName(ExportXMLResources.open_lib_from_temp_exported_location);
            OpenLibraryWizard wizard = new OpenLibraryWizard();
            wizard.openMethodLibrary(this.tempExportFolder.getAbsolutePath(), "xmi", false);
        }
        catch (Exception e) {
            ex[0] = e;
        }
        if (ex[0] != null) {
            throw new RuntimeException(ex[0]);
        }
        return true;
    }

    private void postExportConfig(IProgressMonitor monitor) {
        if (this.currLibPathToResume == null) {
            return;
        }
        MethodLibrary currLib = LibraryService.getInstance().getCurrentMethodLibrary();
        String currLibPath = currLib.eResource().getURI().toFileString();
        if (this.currLibPathToResume.equals(currLibPath)) {
            return;
        }
        final File libFolder = new File(this.currLibPathToResume).getParentFile();
        final Exception[] ex = new Exception[]{null};
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                boolean oldB = LibraryUIManager.isSkipInstallPathCheck();
                try {
                    try {
                        LibraryUIManager.setSkipInstallPathCheck((boolean)true);
                        OpenLibraryWizard wizard = new OpenLibraryWizard();
                        wizard.openMethodLibrary(libFolder.getAbsolutePath(), "xmi", false);
                    }
                    catch (Exception e) {
                        ex[0] = e;
                        LibraryUIManager.setSkipInstallPathCheck((boolean)oldB);
                    }
                }
                finally {
                    LibraryUIManager.setSkipInstallPathCheck((boolean)oldB);
                }
            }
        });
        if (ex[0] != null) {
            throw new RuntimeException(ex[0]);
        }
        if (this.tempExportFolder != null && this.tempExportFolder.exists()) {
            FileUtil.deleteAllFiles((String)this.tempExportFolder.getAbsolutePath());
            this.tempExportFolder = null;
        }
        this.currLibPathToResume = null;
    }

    static /* synthetic */ void access$0(ExportXMLWizard exportXMLWizard, IProgressMonitor iProgressMonitor) {
        exportXMLWizard.postExportConfig(iProgressMonitor);
    }

    static /* synthetic */ boolean access$1(ExportXMLWizard exportXMLWizard, IProgressMonitor iProgressMonitor) {
        return exportXMLWizard.preExportConfig(iProgressMonitor);
    }
}

