/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.preferences.ExportXMLPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectXMLFilePage
extends WizardPage {
    public static final String PAGE_NAME = SelectXMLFilePage.class.getName();
    private Text pathText;
    private String path;

    public SelectXMLFilePage() {
        super(PAGE_NAME);
        this.setTitle(ExportXMLResources.selectXMLFilePage_title);
        this.setDescription(ExportXMLResources.selectXMLFilePage_desc);
        this.setImageDescriptor(ExportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ExportXML.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText(ExportXMLResources.fileLabel_text);
        this.pathText = new Text(composite, 2048);
        this.pathText.setLayoutData((Object)new GridData(768));
        this.pathText.setText(ExportXMLPreferences.getXMLFile());
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SelectXMLFilePage.this.isValidPath(SelectXMLFilePage.this.pathText.getText().trim())) {
                    SelectXMLFilePage.this.setPageComplete(true);
                    SelectXMLFilePage.this.setErrorMessage(null);
                } else {
                    SelectXMLFilePage.this.setPageComplete(false);
                    SelectXMLFilePage.this.setErrorMessage(ExportXMLResources.invalidXMLFile_error);
                }
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setLayoutData((Object)new GridData(3));
        browseButton.setText(ExportXMLResources.browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String path = fd.open();
                boolean ok = false;
                if (path != null) {
                    SelectXMLFilePage.this.pathText.setText(path);
                    ok = SelectXMLFilePage.this.isValidPath(path);
                }
                SelectXMLFilePage.this.setPageComplete(ok);
                SelectXMLFilePage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(this.isValidPath(this.pathText.getText().trim()));
    }

    private boolean isValidPath(String path) {
        IPath ecPath = Path.fromOSString((String)path);
        if (ecPath.isValidPath(path) && path.endsWith(".xml")) {
            this.path = path;
            return true;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getPath() {
        return this.path;
    }
}

