/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramHandler {
    private File sourceLibRoot;
    private File targetLibRoot;
    private Map<String, MapEntryValue> elementMap = new HashMap<String, MapEntryValue>();
    private static boolean debug = false;

    public DiagramHandler(File sourceLibRoot, File targetLibRoot) {
        this.sourceLibRoot = sourceLibRoot;
        this.targetLibRoot = targetLibRoot;
    }

    protected Map<String, MapEntryValue> getElementMap() {
        return this.elementMap;
    }

    private boolean needToProcess(MethodElement elem) {
        boolean b = elem instanceof CapabilityPattern || elem instanceof DeliveryProcess;
        return b;
    }

    public void registerElement(MethodElement elem) {
        this.registerElement(elem, false);
    }

    public void registerElement(MethodElement elem, boolean processEntry) {
        if (!this.needToProcess(elem)) {
            return;
        }
        if (this.elementMap.containsKey(elem.getGuid())) {
            return;
        }
        MapEntryValue mapEntryValue = new MapEntryValue();
        mapEntryValue.element = elem;
        this.elementMap.put(elem.getGuid(), mapEntryValue);
        if (processEntry) {
            this.processEntry(elem, mapEntryValue);
        }
    }

    public void postRegisterElements() {
        for (MapEntryValue value : this.elementMap.values()) {
            this.processEntry(value.element, value);
        }
    }

    private void processEntry(MethodElement elem, MapEntryValue mapEntryValue) {
        File[] files = this.getFiles(elem);
        File sourceFile = files[0];
        File targetFile = files[1];
        if (sourceFile != null && sourceFile.exists()) {
            mapEntryValue.sourceFile = sourceFile;
        }
        if (targetFile.exists()) {
            if (mapEntryValue.sourceFile == null || DiagramHandler.needCopy(mapEntryValue.sourceFile, targetFile)) {
                mapEntryValue.targetFile = targetFile;
            }
            mapEntryValue.existing = true;
        } else if (mapEntryValue.sourceFile != null) {
            mapEntryValue.targetFile = targetFile;
        }
        if (debug) {
            System.out.println("LD> mapEntryValue: ");
            System.out.println(mapEntryValue.toDebugString("LD> "));
            System.out.println("");
        }
    }

    public List getModifiedFiles() {
        ArrayList<String> ret = new ArrayList<String>();
        for (MapEntryValue value : this.elementMap.values()) {
            if (!value.existing || value.targetFile == null) continue;
            ret.add(value.targetFile.getAbsolutePath());
        }
        return ret;
    }

    public void execute() {
        block2: {
            try {
                this.execute_();
            }
            catch (Throwable e) {
                if (!debug) break block2;
                e.printStackTrace();
            }
        }
    }

    private void execute_() {
        for (MapEntryValue value : this.elementMap.values()) {
            if (value.targetFile == null) continue;
            if (value.sourceFile != null) {
                value.targetFile.getParentFile();
                FileUtil.copyFile((File)value.sourceFile, (File)value.targetFile);
                if (!debug) continue;
                System.out.println("LD: File copied: " + value.sourceFile);
                continue;
            }
            value.targetFile.delete();
        }
    }

    public static boolean needCopy(File source, File dest) {
        boolean ret = true;
        if (dest.exists()) {
            ret = dest.lastModified() != source.lastModified() || dest.length() != source.length();
        }
        return ret;
    }

    protected File[] getFiles(MethodElement elem) {
        return this.getFiles(elem, true);
    }

    protected File[] getFiles(MethodElement elem, boolean export) {
        File[] files = new File[2];
        String elementPath = ResourceHelper.getElementPath((MethodElement)elem);
        if (debug) {
            System.out.println("LD> elementPath: " + elementPath);
        }
        if (elementPath == null || elementPath.length() == 0) {
            if (debug) {
                System.out.println("LD> elementPath is null or empty!");
            }
            return files;
        }
        String diagramPath = String.valueOf(elementPath) + elem.getName() + File.separator + "diagram.xmi";
        if (debug) {
            System.out.println("LD> diagramPath 0: " + diagramPath);
        }
        File srcRoot = this.sourceLibRoot;
        File tgtRoot = this.targetLibRoot;
        if (export) {
            srcRoot = this.getRoot(elem);
        } else {
            tgtRoot = this.getRoot(elem);
        }
        if (export) {
            Resource res = elem.eResource();
            if (res != null) {
                File modelFile = new File(res.getURI().toFileString());
                File folder = modelFile.getParentFile();
                String folderPath = folder.getAbsolutePath();
                int ix = srcRoot.getAbsolutePath().length();
                if (folderPath.length() > ix && folderPath.substring(0, ix).equalsIgnoreCase(srcRoot.getAbsolutePath())) {
                    diagramPath = String.valueOf(folderPath.substring(ix + 1)) + File.separator + "diagram.xmi";
                }
            }
        } else {
            ProcessComponent pc = UmaUtil.getProcessComponent((MethodElement)elem);
            if (pc != null && !pc.getName().equals(elem.getName())) {
                diagramPath = String.valueOf(elementPath) + pc.getName() + File.separator + "diagram.xmi";
            }
        }
        files[0] = new File(srcRoot, diagramPath);
        files[1] = new File(tgtRoot, diagramPath);
        return files;
    }

    public void visitElementMap(int passId) {
    }

    public File getSourceLibRoot() {
        return this.sourceLibRoot;
    }

    protected File getRoot(MethodElement elem) {
        ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((MethodElement)elem);
        String pluginPath = libResMgr.getPhysicalPluginPath(elem);
        File root = new File(pluginPath).getParentFile();
        return root;
    }

    public File getTargetLibRoot() {
        return this.targetLibRoot;
    }

    protected static class MapEntryValue {
        public MethodElement element;
        public File sourceFile;
        public File targetFile;
        public boolean existing = false;

        protected MapEntryValue() {
        }

        public String toDebugString(String prompt) {
            String str = String.valueOf(prompt) + "element: " + this.element.getName();
            str = String.valueOf(str) + "\n" + prompt + "sourceFile: " + this.sourceFile;
            str = String.valueOf(str) + "\n" + prompt + "targetFile: " + this.targetFile;
            str = String.valueOf(str) + "\n" + prompt + "existing: " + this.existing;
            return str;
        }
    }
}

