/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.wizards.ExportConfigDestinationPage;
import org.eclipse.epf.export.wizards.ExportConfigurationWizard;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExportConfigSelectSpecsPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME = ExportConfigSelectSpecsPage.class.getName();
    private Table table;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_briefDesc;
    private int checkedCount = 0;
    private List checkedConfigList = new ArrayList();
    private ConfigurationExportData data;
    private Button selectAllButton;
    private Button deselectAllButton;

    public ExportConfigSelectSpecsPage(ConfigurationExportData data) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.selectConfigSpecsPage_title);
        this.setDescription(ExportResources.selectConfigSpecsPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_lib_conf_wizban.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Composite container1 = new Composite(container, 0);
        container1.setLayout((Layout)new GridLayout(3, false));
        ExportConfigSelectSpecsPage.createLabel((Composite)container1, (String)ExportResources.selectConfigSpecsPage_configsLabel_text);
        this.selectAllButton = ExportConfigSelectSpecsPage.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_SelectAllButtonLabel);
        this.deselectAllButton = ExportConfigSelectSpecsPage.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_DeselectAllButtonLabel);
        this.ctrl_chkboxTableViewer = ExportConfigSelectSpecsPage.createCheckboxTableViewer((Composite)container, (int)1);
        this.table = this.ctrl_chkboxTableViewer.getTable();
        ArrayList configList = new ArrayList(LibraryService.getInstance().getCurrentMethodLibrary().getPredefinedConfigurations());
        if (configList.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getComparator();
            Collections.sort(configList, comparator);
        }
        MethodConfiguration[] a = new MethodConfiguration[configList.size()];
        MethodConfiguration[] configs = configList.toArray(a);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodConfiguration) {
                    return ((MethodConfiguration)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (configs != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)configs);
        }
        ExportConfigSelectSpecsPage.createLabel((Composite)container, (String)AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_briefDesc = ExportConfigSelectSpecsPage.createMultiLineText((Composite)container, (String)"", (int)360, (int)80, (int)3);
        if (configs != null && configs.length > 0) {
            this.setDisplayAttributes(configs[0]);
        }
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
        final MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportConfigSelectSpecsPage.this.ctrl_chkboxTableViewer.setAllChecked(true);
                if (lib != null) {
                    ExportConfigSelectSpecsPage.this.checkedConfigList.clear();
                    ExportConfigSelectSpecsPage.this.checkedConfigList.addAll(lib.getPredefinedConfigurations());
                    ExportConfigSelectSpecsPage.this.checkedCount = ExportConfigSelectSpecsPage.this.checkedConfigList.size();
                }
                ExportConfigSelectSpecsPage.this.setPageComplete(ExportConfigSelectSpecsPage.this.isPageComplete());
                ExportConfigSelectSpecsPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportConfigSelectSpecsPage.this.ctrl_chkboxTableViewer.setAllChecked(false);
                if (lib != null) {
                    ExportConfigSelectSpecsPage.this.checkedConfigList.clear();
                    ExportConfigSelectSpecsPage.this.checkedCount = 0;
                }
                ExportConfigSelectSpecsPage.this.setPageComplete(ExportConfigSelectSpecsPage.this.isPageComplete());
                ExportConfigSelectSpecsPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object obj = event.getElement();
        if (event.getChecked()) {
            ++this.checkedCount;
            this.checkedConfigList.add(obj);
        } else {
            --this.checkedCount;
            this.checkedConfigList.remove(obj);
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] configs = selection.toArray();
            this.setDisplayAttributes((MethodConfiguration)configs[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodConfiguration config) {
        this.ctrl_briefDesc.setText(config.getBriefDescription());
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    protected void saveDataToModel() {
        this.data.selectedConfigs = this.checkedConfigList;
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        ExportConfigDestinationPage page = ((ExportConfigurationWizard)this.getWizard()).destinationPage;
        return page;
    }
}

