/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.services;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.dataexchange.util.BaseResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;

public class ImportResourceHandler
extends BaseResourceHandler {
    public ImportResourceHandler(File sourceLibRoot, File targetLibRoot) {
        super(sourceLibRoot, targetLibRoot);
    }

    public UrlInfo resolveFileUrl(Object owner, String srcUrl) throws Exception {
        UrlInfo info = new UrlInfo();
        info.sourceUrl = srcUrl;
        info.sourceFile = new File(this.sourceLibRoot, srcUrl).getCanonicalFile();
        info.targetUrl = srcUrl;
        info.targetFile = null;
        if (info.sourceFile == null || !info.sourceFile.exists()) {
            return info;
        }
        if (owner instanceof MethodElement) {
            info.targetUrl = this.fixUrl(srcUrl);
            String elementPath = ResourceHelper.getElementPath((MethodElement)((MethodElement)owner));
            ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((MethodElement)((MethodElement)owner));
            String srcPluginPath = libResMgr.getPhysicalPluginPath((MethodElement)owner);
            File srcRoot = new File(srcPluginPath).getParentFile();
            info.targetFile = new File(new File(srcRoot, elementPath), info.targetUrl);
        } else {
            info.targetUrl = srcUrl;
            info.sourceFile = new File(this.sourceLibRoot, srcUrl);
        }
        return info;
    }

    private String fixUrl(String url) {
        int indx = (url = url.replace(File.separatorChar, '/')).lastIndexOf("resources/");
        if (indx >= 0) {
            return url.substring(indx);
        }
        return new File("resources", url).toString().replace(File.separatorChar, '/');
    }

    public void copyResource(String sourceFile, EObject obj, MethodPlugin umaPlugin) {
        ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((MethodElement)umaPlugin);
        String tgtPluginPath = libResMgr.getPhysicalPluginPath((MethodElement)umaPlugin);
        File tgtPluginRoot = new File(tgtPluginPath);
        File srcPluginRoot = new File(this.sourceLibRoot, umaPlugin.getName());
        File src = new File(srcPluginRoot, sourceFile);
        if (!src.exists() && !(src = new File(srcPluginRoot, sourceFile = NetUtil.decodedFileUrl((String)sourceFile))).exists()) {
            try {
                sourceFile = NetUtil.decodeURL((String)sourceFile);
                src = new File(srcPluginRoot, sourceFile);
            }
            catch (Exception exception) {}
        }
        if (src.exists()) {
            File tgt = new File(tgtPluginRoot, sourceFile);
            FileUtil.copyFile((File)src, (File)tgt);
        }
    }
}

