/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.importing.xml.preferences.ImportXMLPreferences;
import org.eclipse.epf.importing.xml.services.ImportXMLService;
import org.eclipse.epf.importing.xml.wizards.SelectXMLFilePage;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportXMLWizard
extends BaseWizard
implements IImportWizard {
    ImportXMLService service = ImportXMLService.newInstance();
    private boolean succeed = true;
    private SelectXMLFilePage filePage = null;
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.import.xml.importXMLWizard";

    public ImportXMLWizard() {
        this.setWindowTitle(ImportXMLResources.importXMLWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
    }

    public void addPages() {
        ILibraryManager manager;
        IFileManager fileMgr = Services.getFileManager();
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            fileMgr.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        }
        if ((manager = LibraryService.getInstance().getCurrentLibraryManager()) != null && manager.isMethodLibraryReadOnly()) {
            File libraryFile = new File(LibraryService.getInstance().getCurrentMethodLibraryLocation(), "library.xmi");
            ImportXMLPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, ImportXMLResources.importXMLError_msg, NLS.bind((String)ImportXMLResources.importXMLError_reason, (Object)libraryFile.getAbsolutePath()));
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ImportXML.gif"));
        if (this.wizardExtender == null) {
            this.filePage = new SelectXMLFilePage();
            this.addPage((IWizardPage)this.filePage);
            return;
        }
        ArrayList<IWizardPage> wizardPages = new ArrayList<IWizardPage>();
        IWizardPage page = this.wizardExtender.getReplaceWizardPage(SelectXMLFilePage.PAGE_NAME);
        if (page != null) {
            this.filePage = (SelectXMLFilePage)page;
            wizardPages.add(page);
        } else {
            this.filePage = new SelectXMLFilePage();
            this.addPage((IWizardPage)this.filePage);
        }
        super.getNewWizardPages(wizardPages);
        for (IWizardPage wizardPage : wizardPages) {
            super.addPage(wizardPage);
        }
        this.wizardExtender.initWizardPages(wizardPages);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(ExportXMLPlugin.getDefault().getSharedImage("full/obj16/XMLFile.gif"));
    }

    public boolean performFinish() {
        boolean refresh = RefreshJob.getInstance().isEnabled();
        if (refresh) {
            RefreshJob.getInstance().setEnabled(false);
        }
        final boolean[] ret = new boolean[1];
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ret[0] = ImportXMLWizard.this.performFinish_();
            }
        });
        if (refresh) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            RefreshJob.getInstance().setEnabled(true);
        }
        ResourceUtil.refreshResources((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)new NullProgressMonitor());
        return ret[0];
    }

    private boolean performFinish_() {
        LibraryBackupUtil.promptBackupCurrentLibrary(null, (ILibraryService)LibraryService.getInstance());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask(ImportXMLResources.importingXML_text, -1);
                    String xmlFile = ImportXMLWizard.this.filePage.getPath();
                    boolean mergeOption = ImportXMLWizard.this.filePage.getMergeOption();
                    boolean checkBasePlugins = ImportXMLWizard.this.filePage.getCheckBasePlugins();
                    ImportXMLWizard.this.service.setOverwrite(!mergeOption);
                    ImportXMLWizard.this.service.setMergeLevel(ImportXMLWizard.this.filePage.getMergerLevel());
                    ImportXMLWizard.this.service.setCheckBasePlugins(checkBasePlugins);
                    ImportXMLWizard.this.succeed = ImportXMLWizard.this.service.loadXml(xmlFile);
                    if (!ImportXMLWizard.this.succeed) {
                        return;
                    }
                    if (!ImportXMLWizard.this.handleSynFreeFlag()) {
                        return;
                    }
                    ImportXMLWizard.this.service.doImport(monitor);
                    ImportXMLPreferences.setXMLFile(xmlFile);
                    ImportXMLPreferences.setMergeOption(mergeOption);
                    ImportXMLPreferences.setCheckBasePluginsOption(checkBasePlugins);
                    ImportXMLPreferences.setMergeLevel(ImportXMLWizard.this.filePage.getMergerLevel());
                    return;
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ImportXMLPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, realException.getMessage(), realException);
            return false;
        }
        return this.succeed;
    }

    public void dispose() {
        this.service.dispose();
    }

    private boolean handleSynFreeFlag() {
        final boolean needToConvert = ProcessUtil.isSynFree() && !this.service.isSynFreeLib();
        final boolean toReject = !ProcessUtil.isSynFree() && this.service.isSynFreeLib();
        final boolean[] result = new boolean[]{true};
        if (needToConvert || toReject) {
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    if (needToConvert) {
                        String message = ImportResources.ImportNoSynLibToSynLib_Error;
                        ImportPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, message);
                        result[0] = false;
                    } else if (toReject) {
                        String message = ImportResources.ImportSynLibToNoSynLib_Error;
                        ImportPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, message);
                        result[0] = false;
                    }
                }
            });
        }
        return result[0];
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }
}

