/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.export.services.ConfigurationSpec;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.services.ConfigSpecs;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.UmaFactory;
import org.w3c.dom.Element;

public class ConfigSpecsImportManager {
    ConfigSpecsImportManager() {
    }

    public ConfigSpecs getConfigSpecs(final LibraryDocument document) {
        final ConfigSpecs configSpecs = new ConfigSpecs();
        File configDir = new File(document.getFile().getParent(), "configurations");
        LibraryDocument.ConfigDocVisitor visitor = new LibraryDocument.ConfigDocVisitor(){

            public void visit(File file, Element node) {
                ConfigSpecs.Entry entry = configSpecs.newEntry();
                entry.configSpec = document.getConfigurationSpec(node);
                entry.existingConfig = ConfigSpecsImportManager.this.getExistingConfig(entry.configSpec.guid);
            }
        };
        LibraryDocument.visitConfigFiles((File)configDir, (LibraryDocument.ConfigDocVisitor)visitor);
        return configSpecs;
    }

    private MethodConfiguration getExistingConfig(String guid) {
        MethodConfiguration[] configs = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        if (configs == null || configs.length == 0) {
            return null;
        }
        int i = 0;
        while (i < configs.length) {
            MethodConfiguration config = configs[i];
            if (config.getGuid().equals(guid)) {
                return config;
            }
            ++i;
        }
        return null;
    }

    public void doImport(ConfigSpecs specs) {
        try {
            MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
            LibraryUtil.loadAll((MethodLibrary)lib);
            Iterator it = specs.iterator();
            while (it.hasNext()) {
                ConfigSpecs.Entry entry = (ConfigSpecs.Entry)it.next();
                if (!entry.selected) continue;
                MethodConfiguration config = this.createConfig(entry.configSpec);
                if (entry.existingConfig != null) {
                    List plugins = entry.existingConfig.getMethodPluginSelection();
                    List pkgs = entry.existingConfig.getMethodPackageSelection();
                    List views = entry.existingConfig.getProcessViews();
                    List added = entry.existingConfig.getAddedCategory();
                    List substracted = entry.existingConfig.getSubtractedCategory();
                    for (Object e : config.getMethodPluginSelection()) {
                        if (plugins.contains(e)) continue;
                        plugins.add(e);
                    }
                    for (Object e : config.getMethodPackageSelection()) {
                        if (pkgs.contains(e)) continue;
                        pkgs.add(e);
                    }
                    for (Object e : config.getProcessViews()) {
                        if (views.contains(e)) continue;
                        views.add(e);
                    }
                    for (Object e : config.getAddedCategory()) {
                        if (added.contains(e)) continue;
                        added.add(e);
                    }
                    for (Object e : config.getSubtractedCategory()) {
                        if (substracted.contains(e)) continue;
                        substracted.add(e);
                    }
                    if (config.getDefaultView() != null && config.getDefaultView() != entry.existingConfig.getDefaultView()) {
                        entry.existingConfig.setDefaultView(config.getDefaultView());
                    }
                    ConfigSpecsImportManager.setMepFeatureValue((MethodElement)entry.existingConfig, entry.existingConfig.getMethodElementProperty(), config.getMethodElementProperty());
                    continue;
                }
                lib.getPredefinedConfigurations().add(config);
            }
            LibraryUtil.saveLibrary((MethodLibrary)lib, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private MethodConfiguration createConfig(ConfigurationSpec spec) {
        MethodConfiguration config = UmaFactory.eINSTANCE.createMethodConfiguration();
        config.setName(spec.name);
        config.setBriefDescription(spec.brief_desc);
        config.setGuid(spec.guid);
        config.getMethodElementProperty().addAll(spec.mepList);
        List plugins = config.getMethodPluginSelection();
        List pkgs = config.getMethodPackageSelection();
        List views = config.getProcessViews();
        List added = config.getAddedCategory();
        List substracted = config.getSubtractedCategory();
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            MethodElement element;
            MethodElement element2;
            for (String guid : spec.pluginIds) {
                element2 = manager.getMethodElement(guid);
                if (element2 == null || plugins.contains(element2)) continue;
                plugins.add(element2);
            }
            for (String guid : spec.packageIds) {
                element2 = manager.getMethodElement(guid);
                if (element2 == null || pkgs.contains(element2)) continue;
                pkgs.add(element2);
            }
            for (String guid : spec.viewIds) {
                element2 = manager.getMethodElement(guid);
                if (element2 == null || views.contains(element2)) continue;
                views.add(element2);
            }
            for (String guid : spec.addedCCIds) {
                element2 = manager.getMethodElement(guid);
                if (element2 == null || added.contains(element2)) continue;
                added.add(element2);
            }
            for (String guid : spec.substractCCIds) {
                element2 = manager.getMethodElement(guid);
                if (element2 == null || substracted.contains(element2)) continue;
                substracted.add(element2);
            }
            if (spec.defaultView != null && (element = manager.getMethodElement(spec.defaultView)) instanceof CustomCategory) {
                config.setDefaultView((ContentCategory)((CustomCategory)element));
            }
        }
        return config;
    }

    private static void setMepFeatureValue(MethodElement element, List oldValue, List newValue) {
        int sz = newValue.size();
        if (oldValue.size() == sz) {
            if (sz == 0) {
                return;
            }
            boolean same = true;
            int i = 0;
            while (i < sz) {
                MethodElementProperty oldMep = (MethodElementProperty)oldValue.get(i);
                MethodElementProperty newMep = (MethodElementProperty)newValue.get(i);
                if (!oldMep.getName().equals(newMep.getName()) || !oldMep.getValue().equals(newMep.getValue())) {
                    same = false;
                    break;
                }
                ++i;
            }
            if (same) {
                return;
            }
        }
        oldValue.removeAll(oldValue);
        oldValue.addAll(newValue);
    }
}

