/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Point;

public class LibraryDiffManager {
    private MethodLibrary baseLibrary;
    private MethodLibrary importLibraty;
    private Map diffElementMap = new HashMap();
    private Map importElementMap = new HashMap();
    private Map currentElementMap = new HashMap();
    ElementDiffTree rootDiffTree = null;
    private boolean debug = ImportPlugin.getDefault().isDebugging();

    public LibraryDiffManager(MethodLibrary baseLibrary, MethodLibrary importLibraty) {
        this.baseLibrary = baseLibrary;
        this.importLibraty = importLibraty;
        this.rootDiffTree = new ElementDiffTree((MethodElement)baseLibrary, (MethodElement)importLibraty);
    }

    public MethodLibrary getImportingLibrary() {
        return this.importLibraty;
    }

    public ElementDiffTree buildDiffTree() {
        this.buildUIDMap((List)this.importLibraty.eContents(), this.importElementMap, true, false);
        this.buildUIDMap((List)this.baseLibrary.eContents(), this.currentElementMap, true, true);
        List plugins = this.baseLibrary.getMethodPlugins();
        for (MethodPlugin plugin : plugins) {
            List systemPackages = TngUtil.getAllSystemPackages((MethodPlugin)plugin);
            List categoryList = TngUtil.getContentCategoryPackages((MethodPlugin)plugin);
            for (Object o : categoryList) {
                if (!systemPackages.contains(o)) continue;
                systemPackages.remove(o);
            }
            int i = 0;
            while (i < systemPackages.size()) {
                MethodPackage pkg = (MethodPackage)systemPackages.get(i);
                if (TngUtil.isRootCutomCategoryPackage((MethodPackage)pkg)) {
                    systemPackages.remove(pkg);
                    break;
                }
                ++i;
            }
            this.iterateElement((MethodElement)plugin, this.rootDiffTree, systemPackages);
        }
        List configs = this.baseLibrary.getPredefinedConfigurations();
        for (MethodConfiguration config : configs) {
            this.iterateElement((MethodElement)config, this.rootDiffTree, new ArrayList());
        }
        this.handleNewElements((MethodElement)this.importLibraty);
        return this.rootDiffTree;
    }

    public ElementDiffTree getDiffTree() {
        return this.rootDiffTree;
    }

    public Map getDiffTreeMap() {
        return this.diffElementMap;
    }

    private void iterateElement(MethodElement element, ElementDiffTree diffTree, List systemPackages) {
        EList children;
        if (!this.selectable(element)) {
            return;
        }
        if (!systemPackages.contains(element) && !(element instanceof MethodLibrary)) {
            String uid = element.getGuid();
            ElementDiffTree diffChild = new ElementDiffTree(element, (MethodElement)this.importElementMap.get(uid));
            this.diffElementMap.put(uid, diffChild);
            diffTree.addChild(diffChild);
            diffTree = diffChild;
        }
        if ((children = element.eContents()) != null) {
            for (Object e : children) {
                if (e instanceof MethodElement) {
                    MethodElement child = (MethodElement)e;
                    if (!this.selectable(child)) continue;
                    this.iterateElement(child, diffTree, systemPackages);
                    continue;
                }
                if (!this.debug) continue;
                System.out.println("Error! " + e + " is not a MethodElement object");
            }
        }
    }

    private void handleNewElements(MethodElement element) {
        if (!this.selectable(element)) {
            return;
        }
        if (this.isNewElement(element)) {
            MethodElement lib_parent;
            MethodElement parent = (MethodElement)element.eContainer();
            while (this.isNewElement(parent)) {
                element = parent;
                parent = (MethodElement)parent.eContainer();
            }
            if (parent instanceof MethodLibrary) {
                parent = this.baseLibrary;
            }
            if ((lib_parent = (MethodElement)this.currentElementMap.get(parent.getGuid())) == null) {
                lib_parent = this.baseLibrary;
            }
            ElementDiffTree elementDiffTree = new ElementDiffTree(null, element, lib_parent);
            ElementDiffTree parentDiffTree = null;
            while (parentDiffTree == null && parent != null) {
                parentDiffTree = (ElementDiffTree)this.diffElementMap.get(parent.getGuid());
                parent = (MethodElement)parent.eContainer();
            }
            if (parentDiffTree == null) {
                parentDiffTree = this.rootDiffTree;
            }
            parentDiffTree.addChild(elementDiffTree);
        } else {
            EList children = element.eContents();
            for (Object obj : children) {
                if (!(obj instanceof MethodElement)) continue;
                MethodElement e = (MethodElement)obj;
                this.handleNewElements(e);
            }
        }
    }

    private boolean isNewElement(MethodElement element) {
        if (element == null || element instanceof MethodLibrary) {
            return false;
        }
        return !this.currentElementMap.containsKey(element.getGuid());
    }

    private void buildUIDMap(List elements, Map elementUIDMap, boolean recursive, boolean full) {
        for (Object e : elements) {
            if (e instanceof MethodElement) {
                MethodElement element = (MethodElement)e;
                if (!this.selectable(element) && !full) continue;
                String uid = element.getGuid();
                elementUIDMap.put(uid, element);
                if (!recursive) continue;
                this.buildUIDMap((List)element.eContents(), elementUIDMap, recursive, full);
                continue;
            }
            if (e instanceof Point || e instanceof Dimension || e instanceof MethodElementProperty) continue;
            ImportPlugin.getDefault().getLogger().logError("Import error. " + e + " is not a MethodElement object");
        }
    }

    public boolean selectable(MethodElement element) {
        return element instanceof MethodLibrary || element instanceof MethodPlugin || element instanceof MethodPackage || element instanceof MethodConfiguration;
    }

    public MethodElement getExistingElement(String guid) {
        return (MethodElement)this.currentElementMap.get(guid);
    }
}

