/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceScanner {
    public static final Pattern p_src_ref = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);
    public static final Pattern p_href_ref = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    File srcLibRoot;
    File targetLibRoot;
    private Map newFileMap = new HashMap();
    private Map existingFileMap = new HashMap();
    Map<String, String> renamePluginMap;

    public ResourceScanner(File srcLibRoot, File targetLibRoot, Map<String, String> renamePluginMap) {
        this.srcLibRoot = srcLibRoot;
        this.targetLibRoot = targetLibRoot;
        this.renamePluginMap = renamePluginMap;
    }

    public void scan(MethodElement owner, String source) {
        try {
            String url;
            Matcher m = p_src_ref.matcher(source);
            while (m.find()) {
                url = m.group(1);
                this.processUrl(owner, url);
            }
            m = p_href_ref.matcher(source);
            while (m.find()) {
                url = m.group(1);
                this.processUrl(owner, url);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processUrl(MethodElement owner, String url) {
        this.processUrl(owner, url, null);
    }

    private void processUrl(MethodElement owner, String url, MethodPlugin plugin) {
        if (url == null) {
            return;
        }
        int index = url.indexOf("#");
        if (index >= 0) {
            url = url.substring(0, index);
        }
        if ((index = url.indexOf("?")) >= 0) {
            url = url.substring(0, index);
        }
        if (url.trim().length() == 0) {
            return;
        }
        File srcFile = null;
        File targetFile = null;
        try {
            if (owner != null) {
                ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((MethodElement)owner);
                String elementPath = ResourceHelper.getElementPath((MethodElement)owner);
                srcFile = new File(new File(this.srcLibRoot, elementPath = this.getElementPathWithRenamedPlugin(elementPath)), url);
                if (!srcFile.isFile() || !srcFile.exists()) {
                    url = NetUtil.decodeURL((String)url);
                    srcFile = new File(new File(this.srcLibRoot, elementPath), url);
                }
                String pluginPath = libResMgr.getPhysicalPluginPath(owner);
                File targetRoot = new File(pluginPath).getParentFile();
                targetFile = new File(new File(targetRoot, elementPath), url);
            } else {
                if (plugin == null) {
                    throw new UnsupportedOperationException();
                }
                File srcPluginRoot = new File(this.srcLibRoot, plugin.getName());
                srcFile = new File(srcPluginRoot, url);
                if (!srcFile.isFile() || !srcFile.exists()) {
                    url = NetUtil.decodeURL((String)url);
                    srcFile = new File(srcPluginRoot, url);
                }
                ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((MethodElement)plugin);
                String srcPluginRootPath = libResMgr.getPhysicalPluginPath((MethodElement)plugin);
                targetFile = new File(srcPluginRootPath, url);
            }
            if (srcFile.isFile() && srcFile.exists()) {
                srcFile = srcFile.getCanonicalFile();
                if ((targetFile = targetFile.getCanonicalFile()).exists()) {
                    if (!(this.existingFileMap.containsKey(srcFile) || srcFile.length() == targetFile.length() && srcFile.lastModified() == targetFile.lastModified())) {
                        this.existingFileMap.put(srcFile, targetFile);
                    }
                } else if (!this.newFileMap.containsKey(srcFile)) {
                    this.newFileMap.put(srcFile, targetFile);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getElementPathWithRenamedPlugin(String elementPath) {
        String basePluginName;
        String importPluginName;
        int ix;
        if (this.renamePluginMap != null && !this.renamePluginMap.isEmpty() && (ix = elementPath.indexOf("\\")) > 0 && (importPluginName = this.renamePluginMap.get(basePluginName = elementPath.substring(0, ix))) != null) {
            return String.valueOf(importPluginName) + elementPath.substring(ix);
        }
        return elementPath;
    }

    public void copyResource(String url, MethodPlugin plugin) {
        this.processUrl(null, url, plugin);
    }

    public void copyResource(MethodElement owner, String url) {
        this.processUrl(owner, url);
    }

    public List getFilesTobeReplaced() {
        ArrayList<String> files = new ArrayList<String>();
        if (this.existingFileMap.size() > 0) {
            for (File f : this.existingFileMap.values()) {
                String path;
                if (f == null || files.contains(path = f.getAbsolutePath())) continue;
                files.add(path);
            }
        }
        return files;
    }

    public void execute() {
        File targetFile;
        File srcFile;
        for (Map.Entry entry : this.newFileMap.entrySet()) {
            srcFile = (File)entry.getKey();
            targetFile = (File)entry.getValue();
            FileUtil.copyFile((File)srcFile, (File)targetFile);
        }
        for (Map.Entry entry : this.existingFileMap.entrySet()) {
            srcFile = (File)entry.getKey();
            targetFile = (File)entry.getValue();
            FileUtil.copyFile((File)srcFile, (File)targetFile);
        }
    }
}

