/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DiffReportContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ElementDiffTree) {
            MethodElement e = ((ElementDiffTree)inputElement).getBaseElement();
            if (e instanceof ProcessComponent) {
                return new Object[0];
            }
            List items = ((ElementDiffTree)inputElement).getChildren();
            if (items != null) {
                ArrayList<ElementDiffTree> dirtyItems = new ArrayList<ElementDiffTree>();
                for (ElementDiffTree item : items) {
                    MethodElement base;
                    if (item.isOldOnly() || (base = item.getBaseElement()) instanceof MethodPackage && TngUtil.isRootCutomCategoryPackage((MethodPackage)((MethodPackage)base))) continue;
                    dirtyItems.add(item);
                }
                if (e instanceof MethodLibrary) {
                    Comparator<ElementDiffTree> comparator = new Comparator<ElementDiffTree>(){

                        @Override
                        public int compare(ElementDiffTree o1, ElementDiffTree o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            Collator collator = Collator.getInstance();
                            return collator.compare(o1.getName(), o2.getName());
                        }
                    };
                    Collections.sort(dirtyItems, comparator);
                }
                return dirtyItems.toArray();
            }
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof ElementDiffTree) {
            return ((ElementDiffTree)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ElementDiffTree) {
            return ((ElementDiffTree)element).hasChildren();
        }
        return false;
    }
}

