/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.SelectConfigSpecsToImportPage;
import org.eclipse.epf.importing.wizards.SelectConfigsToImport;
import org.eclipse.epf.importing.wizards.SelectImportConfigurationSource;
import org.eclipse.epf.importing.wizards.SelectPluginsToImport;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportConfigurationWizard
extends BaseWizard
implements IImportWizard {
    public boolean okToComplete = false;
    protected SelectImportConfigurationSource page1;
    protected SelectConfigsToImport configPage;
    protected SelectConfigSpecsToImportPage specsPage;
    protected ConfigurationImportData data = new ConfigurationImportData();
    protected ConfigurationImportService service = ConfigurationImportService.newInstance(this.data);
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.import.importConfigurationWizard";

    public ImportConfigurationWizard() {
        this.setWindowTitle(ImportResources.importConfigWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
    }

    public void addPages() {
        ILibraryManager manager;
        IFileManager fileMgr = Services.getFileManager();
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            fileMgr.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        }
        if ((manager = LibraryService.getInstance().getCurrentLibraryManager()) != null && manager.isMethodLibraryReadOnly()) {
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.importConfigWizard_title, ImportResources.ImportConfigurationWizard_readonly);
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportLibraryConfiguration.gif"));
        if (this.wizardExtender == null) {
            this.page1 = new SelectImportConfigurationSource(this.data, this.service);
            this.addPage((IWizardPage)this.page1);
            this.configPage = new SelectConfigsToImport(this.service);
            this.addPage((IWizardPage)this.configPage);
            this.specsPage = new SelectConfigSpecsToImportPage(this.data);
            this.addPage((IWizardPage)this.specsPage);
            return;
        }
        ArrayList<Object> wizardPages = new ArrayList<Object>();
        IWizardPage page = this.wizardExtender.getReplaceWizardPage(SelectImportConfigurationSource.PAGE_NAME);
        if (page != null) {
            this.page1 = (SelectImportConfigurationSource)page;
            this.page1.setData(this.data);
            this.page1.setService(this.service);
            wizardPages.add(page);
        } else {
            this.page1 = new SelectImportConfigurationSource(this.data, this.service);
            wizardPages.add((Object)this.page1);
        }
        page = this.wizardExtender.getReplaceWizardPage(SelectPluginsToImport.PAGE_NAME);
        if (page != null) {
            this.configPage = (SelectConfigsToImport)page;
            wizardPages.add(page);
        } else {
            this.configPage = new SelectConfigsToImport(this.service);
            wizardPages.add((Object)this.configPage);
        }
        page = this.wizardExtender.getReplaceWizardPage(SelectConfigSpecsToImportPage.PAGE_NAME);
        if (page != null) {
            this.specsPage = (SelectConfigSpecsToImportPage)page;
            wizardPages.add(page);
        } else {
            this.specsPage = new SelectConfigSpecsToImportPage(this.data);
            wizardPages.add((Object)this.specsPage);
        }
        super.getNewWizardPages(wizardPages);
        for (IWizardPage iWizardPage : wizardPages) {
            super.addPage(iWizardPage);
        }
        this.wizardExtender.initWizardPages(wizardPages);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(LibraryUIImages.IMG_METHOD_CONFIGURATON);
    }

    public boolean canFinish() {
        return this.okToComplete;
    }

    public boolean performFinish() {
        if (ProcessUtil.isSynFree() && !this.service.isSynFreeLib()) {
            String message = ImportResources.ImportNoSynLibToSynLib_Error;
            MessageDialog.openError((Shell)this.getShell(), (String)ImportResources.importConfigWizard_title, (String)message);
            return false;
        }
        if (!ProcessUtil.isSynFree() && this.service.isSynFreeLib()) {
            String message = ImportResources.ImportSynLibToNoSynLib_Error;
            MessageDialog.openError((Shell)this.getShell(), (String)ImportResources.importConfigWizard_title, (String)message);
            return false;
        }
        LibraryBackupUtil.promptBackupCurrentLibrary(null, (ILibraryService)LibraryService.getInstance());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(ImportResources.ImportConfigurationWizard_MSG1, -1);
                        ImportConfigurationWizard.this.service.performImport(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportConfigurationWizard_error, realException.getMessage());
            return false;
        }
        ImportUIPreferences.addImportConfigDir(this.data.llData.getParentFolder());
        return true;
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }
}

